//LabPlot : PstoEditDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfiledialog.h>
#include <klocale.h>
#include <ktempfile.h>
#include <kprocess.h>
#include <kmessagebox.h>
#include "PstoEditDialog.h"

using namespace std;

struct Format {
	QString name;
	QString ext;
	QString option;
};

#define NR_PAGESIZES 42
#define NR_FORMATS 43

const QString pagesizes[]={"a0","a1","a2","a3","a4","a5","b4","b5",
	"tabloid","ledger","legal","statement","excecutive","folio","quarto",
	"10x14","note","env_9","env_11","env_14","env_dl","env_c3",
	"env_c4","env_c5","env_c6","env_b4","env_b5","env_b6","env_italy",
	"env_monarch","env_personal","fanfold_us","fanfold_std_german",
	"fanfold_lgl_german","iso_b4","japanese_postcard","9x11","10x11","15x11",
	"env_invite","a_plus","b_plus"};

const Format formats[]={
	{"Flattened PostScript (no curves)","psf","psf"},
	{"Simplified PostScript with curves","ps","ps"},
	{"GhostScript PostScript","ps","gs:pswrite"},
	{"GhostScript EPS","eps","gs:epswrite"},
	{"GhostScript PDF","pdf","gs:pdfwrite"},
	{"Adobe Illustrator via ps2ai.ps of GhostScript","ai","ps2ai"},
	{"Interviews draw format (EPS)","eps","idraw"},
	{".fig format for xfig","fig","fig"},
	{"Tgif .obj format (for tgif version >= 3)","tgif","tgif"},
	{"gnuplot format","gpl","gnuplot"},
	{"tk and/or tk applet source code","tk","tk"},
	{"HPGL code","hpgl","hpgl"},
	{"PIC format for troff et.al.","pic","pic"},
	{"LaTeX2e picture format","tex","latex2e"},
	{"Mathematica Graphics","mma","mma"},
	{"MetaPost Format","mpo","mpost"},
	{"Sketch Format","sk","sk"},
	{"text in different forms","txt","text"},
	{".kil format for Kontour","kil","kil"},
	{"Adobe's Portable Document Format","pdf","pdf"},
	{"java 2 source code","java","java2"},
	{"java 1 applet source code","java","java1"},
	{"CAD exchange format","dxf","dxf"},
	{"CAD exchange format with splines","dxf","dxf_s"},
	{"Real3D Programming Language Format","rpl","rpl"},
	{"RenderMan Interface Bytestream","rib","rib"},
	{"LightWave 3D Object Format","lwo","lwo"},
	{"ASCII GNU metafile","gmfa","gmfa"},
	{"binary GNU metafile","gmfb","gmfb"},
	{"pnm via GNU libplot","pnm","plot-pnm"},
	{"cgm via GNU libplot","cgm","plot-cgm"},
	{"ai via GNU libplot","ai","plot-ai"},
	{"svg via GNU libplot","svg","plot-svg"},
	{"ps via GNU libplot","ps","plot-ps"},
	{"fig via GNU libplot","fig","plot-fig"},
	{"pcl via GNU libplot","pcl","plot-pcl"},
	{"hpgl via GNU libplot","hpgl","plot-hpgl"},
	{"tek via GNU libplot","tek","plot-tek"},
	{"scalable vector graphics","svg","svg"},
	{"(Frame)Maker Intermediate Format","mif","mif"},
	{"CGM binary Format (V1)","cgm","cgmb1"},
	{"CGM binary Format (V3)","cgm","cgmb"},
	{"CGM textual Format","cgm","cgmt"},
};

PstoEditDialog::PstoEditDialog(MainWin *mw, QString fn, int f, int s, double sc, double r, const char *name)
	: Dialog(mw, name)
{
	setCaption(i18n("Export via pstoedit"));
	
	QHBox *hb = new QHBox(vbox);
	QLabel *tmp = new QLabel(i18n("Export to : "),hb);
	format = new KComboBox(hb);
	QObject::connect(format,SIGNAL(activated (int)),SLOT(updateFilename(int)));
        QStringList formatlist;
	for(int i=0;i<NR_FORMATS;i++)
		formatlist<<formats[i].name;
        format->insertStringList(formatlist);
        format->setCurrentItem(f);

	hb = new QHBox(vbox);
	tmp = new QLabel(i18n("Page Size : "),hb);
	pagesize = new KComboBox(hb);
        QStringList pagesizelist;
	for(int i=0;i<NR_PAGESIZES;i++)
		pagesizelist<<pagesizes[i];
        pagesize->insertStringList(pagesizelist);
        pagesize->setCurrentItem(s);

	hb = new QHBox(vbox);
	new QLabel(i18n("File : "),hb);
	filele = new KLineEdit(fn,hb);
	KPushButton *newFile = new KPushButton(i18n("Browse..."),hb);
	QObject::connect(newFile,SIGNAL(clicked()),SLOT(selectFile()));

	hb = new QHBox(vbox);
	new QLabel(i18n("Scale : "),hb);
	scalele = new KLineEdit(QString::number(sc),hb);
	scalele->setValidator(new QDoubleValidator(scalele));
	new QLabel(i18n(" Rotation : "),hb);
	rotle = new KLineEdit(QString::number(r),hb);
	rotle->setValidator(new QDoubleValidator(-360,360,2,rotle));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(Apply()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void PstoEditDialog::updateFilename(int index) {
	QString filename =  filele->text();
	filename.replace( QRegExp(QString("[.]+.*")), "." + formats[index].ext );
	filele->setText(filename);
}

void PstoEditDialog::selectFile() {
	QString ext =  formats[format->currentItem()].ext;
	QString filename = QFileDialog::getSaveFileName( QString::null, "*." + ext, this );
	if ( filename ) {
		if(filename.find(QRegExp(QString("\\.%1").arg(ext)))==-1)
			filename.append(QString(".%1").arg(ext));
        	filele->setText(filename);
    	}
}

void PstoEditDialog::apply_clicked() {
	// append extension if needed
	QString ext =  formats[format->currentItem()].ext;
	if(filele->text().find(QRegExp(QString("\\.%1").arg(ext)))==-1)
			filele->setText(filele->text().append(QString(".%1").arg(ext)));
			
	// check if file exists
	if ( QFile::exists(filele->text()) ) {
		int answer = KMessageBox::warningYesNoCancel( this, 
			i18n( "Overwrite\n\'%1\'?" ).arg( filele->text() ), i18n("Export via pstoedit"));
		if (answer != KMessageBox::Yes)
			return;
	}

	KTempFile *tmpfile = new KTempFile(QString::null,".ps");
	tmpfile->setAutoDelete(true);	
	QString filename = tmpfile->name();        
	if (mw)  mw->activeWorksheet()->Print(filename);

	KProcess *proc = new KProcess;
	*proc << "pstoedit";
	*proc << "-f"<< formats[format->currentItem()].option <<"-pagesize"<<pagesize->currentText();
	*proc << "-scale"<<scalele->text()<<"-rotate"<<rotle->text()<< filename << filele->text();

	if( proc->start(KProcess::Block) == false) {
		kdDebug()<<"COULD NOT FIND pstoedit! Gving up."<<endl;
		KMessageBox::error(mw,i18n("Could not find pstoedit!"));
	}
	
	if(proc->exitStatus() == 1) {	// version >= 3.4 uses xscale/yscale instead of scale !
		kdDebug()<<"OK. New version of pstoedit"<<endl;

		KProcess *proc = new KProcess;
		*proc << "pstoedit";
		*proc << "-f"<< formats[format->currentItem()].option <<"-pagesize"<<pagesize->currentText();
		*proc << "-xscale"<<scalele->text()<<"-yscale"<<scalele->text()<<"-rotate"<<rotle->text();
		*proc << filename << filele->text();
		proc->start(KProcess::Block);
	}

	tmpfile->close();
}
