//LabPlot : Style.cc

#include <qtextstream.h>
#include <kdebug.h>
#include "Style.h"

Style::Style(int t, QColor c, bool f, QColor fc,int w, int p, int b)
{
	type = t;
	color = c;
	fill = f;
	fillcolor = fc;
	width=w;
	penStyle = p;
	brush = b;
	boxwidth=10;
	autoboxwidth=false;
}

void Style::save(QTextStream *t) {
	*t<<type<<' '<<color.name()<<endl;
	*t<<fill<<' '<<fillcolor.name()<<endl;
	*t<<width<<' '<<penStyle<<' '<<brush<<endl;
	*t<<boxwidth<<' '<<autoboxwidth<<endl;
}

int Style::open(QTextStream *t,int version) {
	kdDebug()<<"Style::open()"<<endl;
	QString c;
	int graphtype, f;

	*t>>graphtype>>type>>c;
	color=QColor(c);
	*t>>f>>c;
	fill= (bool)f;
	fillcolor=QColor(c);
	if (version>11)
		*t>>width>>penStyle>>brush;

	if(version>18) {
		int e;
		*t>>boxwidth>>e;
		autoboxwidth=(bool)e;
	}

	return graphtype;
}
