%define version 1.5.1.rc2
%define release 1

Name: 		LabPlot
URL:		http://labplot.sourceforge.net/
Version:	%{version}
Summary:	Function and Data Plotter
Release:	%{release}
Source:		LabPlot-%{version}.tar.bz2
Group:		Applications/Engineering	
Copyright:	GPL
Packager:	Stefan Gerlach <gerlach@mbi-berlin.de>
Distribution:	RedHat Linux 9
Vendor:		http://labplot.sourceforge.net/
BuildPrereq:	gsl-devel ImageMagick-c++-devel libart_lgpl-devel
Requires:	ImageMagick >= 5.4.7 ImageMagick-c++ >= 5.4.7 gsl audiofile
BuildRoot:	%{_tmppath}/LabPlot

%description
This is a program for plotting of functions and data manipulation.

%prep
rm -rf $RPM_BUILD_DIR/LabPlot-%{version}
tar jxf $RPM_SOURCE_DIR/LabPlot-%{version}.tar.bz2

%setup
export CFLAGS="-O2 -Wall"
export CXXFLAGS="-O2 -Wall"
%ifarch x86_64 sparc64 ppc64 amd64
./configure --prefix=/usr --disable-static --enable-libsuffix=64 --with-qt-libraries=/usr/lib/qt3/lib64 --enable-final
%else
./configure --prefix=/usr --disable-static --enable-final
%endif

%build
make

%clean
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/LabPlot-%{version}
rm -f ../file.list.LabPlot

%install
make DESTDIR="$RPM_BUILD_ROOT" install
cd $RPM_BUILD_ROOT
find . -type d | sed '1,2d;s,^\.,\%attr(755\,root\,root) \%dir ,' > $RPM_BUILD_DIR/file.list.LabPlot
find . -type f -o -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >> $RPM_BUILD_DIR/file.list.LabPlot

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%files -f ../file.list.LabPlot
%doc README TODO INSTALL ChangeLog CHANGES FEATURES LabPlot.lsm

#%undefine __check_files

%changelog
* Sat Mar 11 2006 - Stefan Gerlach
- update to 1.5.1
- generated files section
* Fri Aug 13 2005 - Stefan Gerlach
- update for 1.5.0
* Fri Mar 25 2005 - Stefan Gerlach
- update for 1.4.1
* Sun Dec 19 2004 - Stefan Gerlach
- update for 1.4.0
* Fri Oct 31 2004 - Stefan Gerlach
- updated for 1.4.0
- removed jasper and CDF
