//LabPlot : ArrangePlotDialog.h

#ifndef ARRANGEPLOTDIALOG_H
#define ARRANGEPLOTDIALOG_H

#include <qfont.h>
#include <qcheckbox.h>
#include "Worksheet.h"
#include "PlotDialog.h"

class ArrangePlotDialog: public PlotDialog
{
	Q_OBJECT
public:
	ArrangePlotDialog(MainWin *mw, const char *name);
public slots:
	void setX(int x) {xni->setValue(x); }				//!< set dimension in x range
	void setY(int y) {yni->setValue(y); }				//!< set dimension in y range
	void setGap(double g) { gaple->setText(QString::number(g)); }	//!< set gap between plots
	void setPanel(bool p=true) { panel->setChecked(p); }		//!< set panel plots
	void Apply() { apply_clicked(); }
private:
	void applyPanel(int nrx, int nry,  double gap);
	void hPanel(Plot *plot[], int nr, double gap);
	void vPanel(Plot *plot[], int nr, double gap);
	KIntNumInput *xni, *yni;
	KLineEdit *gaple;
	QCheckBox *panel;
private slots:
	void ok_clicked() { apply_clicked(); accept(); }
	void saveSettings();
	void apply_clicked();
	void updatePanelSelected(int state);
};

#endif //ARRANGEPLOTDIALOG_H
