//LabPlot : GraphL.cc

#include <stdlib.h>
#include <iostream>
#include <qimage.h>
#include <kdebug.h>
#include "GraphL.h"

using namespace std;

GraphL::GraphL(QString n, QString l, LRange r, LSource src, PType t, Style *st,
		Symbol *sy, PointL *p, int nr, bool s)
	: Graph(n,l,src,t,st,sy,nr,s)
{
	range.setMin(r.rMin());
	range.setMax(r.rMax());

	ptr = new PointL[nr];
	for(int i=0;i<nr;i++)
		ptr[i] = p[i];

	delete [] p;
}

GraphL::~GraphL() {
	delete [] ptr;

	delete label;
}

void GraphL::saveXML(QDomDocument doc, QDomElement graphtag) {
	QDomElement tag = doc.createElement( "Range" );
	tag.setAttribute("min",QString::number(range.rMin()));
	tag.setAttribute("max",QString::number(range.rMax()));
    	graphtag.appendChild( tag );

	for (int i=0;i< number;i++) {
		tag = doc.createElement( "Data" );
		tag.setAttribute("v",QString::number(ptr[i].V()));
		tag.setAttribute("l",ptr[i].L());
		tag.setAttribute("masked",QString::number(ptr[i].Masked()));
    		graphtag.appendChild( tag );
	}
}

void GraphL::save(QTextStream *t, QProgressDialog *progress) {
	saveGraph(t);

	*t<<number<<endl;
	*t<<range.rMin()<<' '<<range.rMax()<<endl;
	*t<<type<<' ';
	style->save(t);
	symbol->save(t);

	// save data
	progress->setTotalSteps(number);
	for (int i=0;i< number;i++) {
		if(i%1000 == 0) progress->setProgress(i);
		*t<<ptr[i].V()<<' '<<ptr[i].L()<<' '<<ptr[i].Masked()<<endl;
	}
	progress->cancel();
}

GraphL *GraphL::Clone() {
	GraphL *newg = new GraphL(*this);
	Label *l = new Label();
	*l = *(label);
	newg->setLabel(l);	// set label

	LRange nrange = range;
	newg->setRange(nrange);

	return newg;
}

void GraphL::open(QTextStream *t, int version, QProgressDialog *progress) {
	kdDebug()<<"GraphL::open()"<<endl;
	openGraph(t,version);

	if (version > 2)
		*t>>number;
	double zmin, zmax;
	*t>>zmin>>zmax;
	range.setMin(zmin); range.setMax(zmax);

	type = (PType) style->open(t,version);
	symbol->open(t,version);

	// read data
	double x;
	QString s;
	int m;
	ptr = new PointL[number];

	kdDebug()<<"	open() : reading data"<<endl;
	progress->setTotalSteps(number);
	for (int i=0;i< number;i++) {
		if(i%1000 == 0) progress->setProgress(i);

		if (version>18) {
			*t>>x>>s>>m;
			ptr[i].setMasked(m);
		}

		ptr[i].setPointL(x,s);
		kdDebug()<<i<<' '<<x<<' '<<s<<' '<<m<<endl;
	}
	progress->cancel();
}

void GraphL::openXML(QDomNode node) {
	kdDebug()<<"GraphL::openXML()"<<endl;
	int i=0;
	while(!node.isNull()) {
		QDomElement e = node.toElement();
//		kdDebug()<<"GRAPH TAG = "<<e.tagName()<<endl;
//		kdDebug()<<"GRAPH TEXT = "<<e.text()<<endl;

		openGraphXML(e);

		if(e.tagName() == "Number")
			ptr = new PointL[e.text().toInt()];
		else if(e.tagName() == "Range")
			range.setRange(e.attribute("min").toDouble(),e.attribute("max").toDouble());
		else if(e.tagName() == "Data") {
			ptr[i].setPointL(e.attribute("v").toDouble(),e.attribute("l"));
			ptr[i].setMasked((bool) e.attribute("masked").toInt());
			i++;
		}

		node = node.nextSibling();
	}
	kdDebug()<<"GraphL::openXML() DONE"<<endl;
}

QStringList GraphL::Info(){
	QStringList s;
	QString t=i18n("Label");

	QString sh=i18n("NO");
	if (shown)
		sh=i18n("YES");

	s << label->simpleTitle() << t << sh;
	s << QString::number(range.rMin())+ " .. " + QString::number(range.rMax());

	return s;
}
