/***************************************************************************
 *            aptcache.h
 *
 *  Mon Nov 13 11:56:58 2006
 *  Copyright  2006  Neil Williams
 *  linux@codehelp.co.uk
 ****************************************************************************/
/*
    This package is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
#ifndef _APTCACHE_H
#define _APTCACHE_H
/**	@file   aptcache.h
	@brief  Query the cache
	@author Neil Williams <codehelp@debian.org>
*/
/** @{
*/

/** \brief initialise the apt cache 

When installed this uses the emdebian cache for the current arch.

*/
gboolean
apt_init (const gchar * sourcelist, const gchar * suite_codename,
	const gchar * prefix, gint verbose);

/** lookup the package name against the cache. */
gboolean aptcache_lookup (const gchar * pkg);

/** clear the source package table */
void lu_clear_caches (void);

/** get the equivalent source package name for the supplied binary */
gchar * lu_get_sourcepkg (const gchar * binary);

/** get the version string for the package name */
gint lu_check_pkg_version (const gchar * package, const gchar * version);

/** @} */
#endif /* _APTCACHE_H */
