; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "LASSO dependencies"
!define PRODUCT_VERSION "0.4.1"
!define PRODUCT_PUBLISHER "Entr'ouvert"
!define PRODUCT_WEB_SITE "http://lasso.entrouvert.org"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

SetCompressor bzip2

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!define MUI_LICENSEPAGE_RADIOBUTTONS
!insertmacro MUI_PAGE_LICENSE "..\..\COPYING"
; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "French"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "Install-deps-0_4_1.exe"
InstallDir "$SYSDIR"
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Section "glib" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "..\..\..\..\..\usr\local\lib\libglib-2.0-0.dll"
  File "..\..\..\..\..\usr\local\lib\libgobject-2.0-0.dll"
  File "..\..\..\..\..\usr\local\lib\libgmodule-2.0-0.dll"
  File "..\..\..\..\..\usr\local\lib\libgthread-2.0-0.dll"
SectionEnd

Section "libxml2" SEC02
  File "..\..\..\..\..\usr\local\lib\libxml2.dll"
SectionEnd

Section "libxslt" SEC03
  File "..\..\..\..\..\usr\local\lib\libxslt.dll"
  File "..\..\..\..\..\usr\local\lib\libexslt.dll"
SectionEnd

Section "libxmlsec" SEC04
  File "..\..\..\..\..\usr\local\lib\libxmlsec.dll"
  File "..\..\..\..\..\usr\local\lib\libxmlsec-mscrypto.dll"
  File "..\..\..\..\..\usr\local\lib\libxmlsec-openssl.dll"
SectionEnd

Section "libopenssl" SEC05
  File "..\..\..\..\..\usr\local\lib\libeay32.dll"
  File "..\..\..\..\..\usr\local\lib\libssleay32.dll"
SectionEnd

Section "zlib" SEC06
  File "..\..\..\..\..\usr\local\lib\libz.dll"
SectionEnd

Section "iconv" SEC07
  File "..\..\..\..\..\usr\local\lib\libiconv.dll"
SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateDirectory "$SMPROGRAMS\Liberty Alliance Single Sign On Dependencies"
  CreateShortCut "$SMPROGRAMS\Liberty Alliance Single Sign On Dependencies\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\Liberty Alliance Single Sign On Dependencies\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} "Glib DLL"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} "lixml2 DLL"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC03} "libxslt1 DLL"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC04} "libxmlsec1 DLL with openssl and mscrypto module"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC05} "OpenSSL DLL"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC06} "Zlib DLL"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC07} "iconv DLL"
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) a t dsinstall avec succs de votre ordinateur."
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "tes-vous certains de vouloir dsinstaller totalement $(^Name) et tous ses composants ?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\libiconv.dll"
  Delete "$INSTDIR\libz.dll"
  Delete "$INSTDIR\libssleay32.dll"
  Delete "$INSTDIR\libeay32.dll"
  Delete "$INSTDIR\libxmlsec-openssl.dll"
  Delete "$INSTDIR\libxmlsec-mscrypto.dll"
  Delete "$INSTDIR\libxmlsec.dll"
  Delete "$INSTDIR\libexslt.dll"
  Delete "$INSTDIR\libxslt.dll"
  Delete "$INSTDIR\libxml2.dll"
  Delete "$INSTDIR\libgthread-2.0-0.dll"
  Delete "$INSTDIR\libgmodule-2.0-0.dll"
  Delete "$INSTDIR\libgobject-2.0-0.dll"
  Delete "$INSTDIR\libglib-2.0-0.dll"

  Delete "$SMPROGRAMS\Liberty Alliance Single Sign On Dependencies\Uninstall.lnk"
  Delete "$SMPROGRAMS\Liberty Alliance Single Sign On Dependencies\Website.lnk"

  RMDir "$SMPROGRAMS\Liberty Alliance Single Sign On Dependencies"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  SetAutoClose true
SectionEnd
