/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef SLIDINGLABEL_H
#define SLIDINGLABEL_H

#include <QLabel>

class QTimer;

class SlidingLabel : public QLabel
{
	Q_OBJECT
	public:
		SlidingLabel( QWidget *parent );

		QSize sizeHint() const;

	public slots:
		void setText( const QString &text );

	signals:
		void clicked();

	protected:
		virtual void mousePressEvent( QMouseEvent *e );
		virtual void paintEvent( QPaintEvent *e );

	private slots:
		void slotAnimationFrame();

	private:
		QRect textRect() const;
		void initScrollingIn();

		QString m_text;
		QString m_newText;
		int m_offset;
		double m_offsetStep;
		QTimer *m_switchTimer;
};

#endif // SLIDINGLABEL_H

