/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik J�evik, Last.fm Ltd <erik@last.fm>                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "CrashReporter.h"
#include "containerutils.h"
#include "Settings.h"

#include <QTranslator>

/******************************************************************************
    main
******************************************************************************/
int main( int argc, char* argv[] )
{
    QApplication app( argc, argv );

    UserSettings &user = The::settings().currentUser();
    
    if (user.isNull() || !user.crashReportingEnabled())
        return 0;

    // REFACTOR: move to lib
    QString langCode;
    QTranslator translatorApp;
    QTranslator translatorQt;

    #ifdef HIDE_RADIO
        langCode = "jp";
    #else
        // First check settings
        langCode = The::settings().appLanguage();

        if ( langCode.isEmpty() )
        {
            // If none found, use system locale
            QLocale::Language qtLang = QLocale::system().language();
            langCode = qtLanguageToLfmLangCode( qtLang );
        }
    #endif

    translatorApp.load( dataPath( "i18n/lastfm_%1" ).arg( langCode ) );
    translatorQt.load( dataPath( "i18n/qt_%1" ).arg( langCode ) );

    app.installTranslator( &translatorApp );
    app.installTranslator( &translatorQt );

    CrashReporter reporter( argc, argv );
    return reporter.exec();
}
