/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef MEDIADEVICE_H
#define MEDIADEVICE_H

#include "interfaces/MediaDeviceInterface.h"
#include <QSqlDatabase>
#include <QFileSystemWatcher>
#include <QMutex>
#include "TrackInfo.h"

#ifdef Q_WS_MAC
    #include "CocoaUtils.h"
    #include "CFStringToQString.h"
    #include <CoreFoundation/CoreFoundation.h>
    #include <Carbon/Carbon.h>
#endif

class CocoaThread;

class MediaDeviceWatcher : public QObject
{
    Q_OBJECT

    public:
        MediaDeviceWatcher();
        ~MediaDeviceWatcher();

    public slots:
        void forceDetection( const QString& path );

        #ifdef Q_WS_MAC
            void startWithiTunes();
        #endif

    private slots:
        void deviceAdded( const QString& uid );
        void deviceChangeStart( const QString& uid, QDateTime lastItunesUpdateTime );
        void deviceChangeEnd( const QString& uid );

        void trackChanged( const TrackInfo& track, int playCounter );

        void shutdownHelper( const QString& path );
        
    private:
        MediaDeviceInterface* m_gpod;
        QString m_savePath;
        QDomDocument m_newsubdoc;
        QDomElement m_submitQueue;
        QString m_runPath;

#ifdef Q_WS_MAC
        CocoaThread* m_cthread;
#endif

        bool updateTrack( TrackInfo track, bool autoScrobble = false );
        QList<TrackInfo> readQueue( const QString& uid );
};


#ifdef Q_WS_MAC

#ifdef __cplusplus
extern "C" {
#endif

    OSAID LowCompileAppleScript( const void* text, long textLength );

    /* LowRunAppleScript compiles and runs an AppleScript
    provided as text in the buffer pointed to by text.  textLength
    bytes will be compiled from this buffer and run as an AppleScript
    using all of the default environment and execution settings.  If
    resultData is not NULL, then the result returned by the execution
    command will be returned as typeChar in this descriptor record
    (or typeNull if there is no result information).  If the function
    returns errOSAScriptError, then resultData will be set to a
    descriptive error message describing the error (if one is
    available). */
    bool LowExecAppleScript( OSAID scriptID, QString& resultToken );

    /* AppleScriptAvailable returns true if AppleScript is available
    and the routines defined herein can be called. */
    bool AppleScriptAvailable();

#ifdef __cplusplus
}
#endif // end _cplusplus


class CocoaThread : public QThread
{
    public:
    CocoaThread( MediaDeviceWatcher* parent ) : QThread( parent ), m_parent( parent ), m_itunesRunning( false )
    {
        start();
    }

    ~CocoaThread() { m_run = false; }

    protected:
        void run();

    private:
        CocoaUtils* m_cocoa;
        MediaDeviceWatcher* m_parent;
        bool m_run;
        bool m_itunesRunning;

        bool isITunesRunning();
};


#endif // end Q_WS_MAC

#endif
