/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Erik Jalevik, Last.fm Ltd <erik@last.fm>                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef STREAMBUFFERMONITOR_H
#define STREAMBUFFERMONITOR_H

#ifdef MONITOR_STREAMING

#include "ui_streambuffermonitor.h"

#include <QtGui>

class AudioController;

/*************************************************************************/ /**
    Debug dialog for monitoring stream buffers.
******************************************************************************/
class StreamBufferMonitor : public QDialog
{
    Q_OBJECT

public:
    StreamBufferMonitor( QWidget *parent = 0 );

    void
    setAudioController( AudioController* ac )
    {
        m_ac = ac;
    }

    void
    run();

private:
    Ui::StreamBufferMonitor ui;

    AudioController* m_ac;
    
private slots:
    
    void onHttpBufferSizeChanged( int size );
    void onDecodedBufferSizeChanged( int size );
    void onOutputBufferSizeChanged( int size );
};

#endif // MONITOR_STREAMING
#endif // STREAMBUFFERMONITOR_H
