/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "appinfo.h"
#include "logger.h"
#include "versionnumber.h"
#include "container.h"
#include "containerutils.h"
#include "Settings.h"

using namespace std;

/******************************************************************************
    IsInstalled
******************************************************************************/
bool
CAppInfo::IsInstalled()
{
    return true;
}

/******************************************************************************
    IsVersionNewer
******************************************************************************/
bool
CAppInfo::IsVersionNewer()
{
    if (mVersionNewer == eUnknown)
    {
        QString exeVer = The::settings().version();
        CVersionNumber verExe(exeVer.toStdString());
        CVersionNumber verLatest(GetVersion().toStdString());
        
        mVersionNewer = verLatest > verExe ? eTrue : eFalse;
    }

    return mVersionNewer == eTrue;
}

/******************************************************************************
    IsRunning
******************************************************************************/
bool
CAppInfo::IsRunning()
{
    return true;
}

