/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "controlinterface.h"

#include "container.h"
#include "containerutils.h"
#include "Radio.h"
#include "Scrobbler-1.2.h"
#include "Settings.h"


ControlInterface::ControlInterface( Container* parent )
    : m_parent( parent )
    , m_handshaked( false )
{
    m_serverSocket = new QTcpServer( this );

    connect( m_serverSocket, SIGNAL( newConnection() ), this, SLOT( clientConnect() ) );
    m_serverSocket->listen( QHostAddress::LocalHost, 32213 );
}


void
ControlInterface::clientConnect()
{
    // Incoming connection from either a webbrowser or
    // some other program like the firefox extension.
    QTcpSocket* socket = m_serverSocket->nextPendingConnection();
    connect( socket, SIGNAL( readyRead() ), this, SLOT( clientRequest() ) );
}


void
ControlInterface::parseCommands( const QStringList& requests )
{
    foreach( QString request, requests )
        parseCommand( request );
}


void
ControlInterface::parseCommand( const QString& request )
{
    if ( !request.isEmpty() )
    {
        if ( request.contains( "lastfm://" ) )
        {
            #ifndef HIDE_RADIO
                LOGL( 3, "Calling radio with station" );
                if ( !m_handshaked )
                    m_parent->setPreloadStation( StationUrl( request ) );
                else
                    Container::instance().radio().playStation( StationUrl( request ) );
            #endif // HIDE_RADIO
        }

        if ( request.contains( "container://show" ) )
        {
            LOGL( 3, "Calling restoreWindow" );
            m_parent->restoreWindow();
        }

        if ( request.contains( "container://checkScrobblerCache" ) )
        {
            const QString user = request.split( "checkScrobblerCache/" ).at( 1 );
            if ( QFile::exists( savePath( user + "_mediadevice.xml" ) ) )
            {
                LOGL( 3, "Calling scrobbler with media device data" );
                The::scrobbler().submitMediaDeviceCache( The::currentUser().username() );
            }
        }

        if ( request.contains( "container://addMediaDevice" ) )
        {
            LOGL( 3, "Calling container for media device addition" );
            m_parent->addMediaDevice( request.split( "addMediaDevice/" ).at( 1 ) );
        }
    }
}


void
ControlInterface::clientRequest()
{
    QTcpSocket* socket = (QTcpSocket*)sender();
    QString request = QString( socket->readAll() );

    LOGL( 3, "clientRequest (old instance): " << request );

    parseCommand( request );

    socket->flush();
    socket->close();
    socket->deleteLater();
}


bool
ControlInterface::sendToInstance( const QString& data )
{
    LOGL( 3, "sendToInstance (new instance): " << data );
    
    QTcpSocket socket;
    socket.connectToHost( QHostAddress::LocalHost, 32213 );

    if ( socket.waitForConnected( 500 ) )
    {
        if ( data.length() > 0 )
        {
            QByteArray utf8Data = data.toUtf8();
            socket.write( utf8Data, utf8Data.length() );
            socket.flush();
        }

        socket.close();
        return true;
    }
    else
    {
        LOGL( 1, "sendToInstance failed" );
    }

    return false;
}
