/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifdef WIN32

// This file contains legacy code that doesn't work with Unicode.
#undef UNICODE
#undef _UNICODE

#include "crashhandler.h"
#include "logger.h"
#include "containerutils.h"

#include <tchar.h>
#include <tlhelp32.h>

#include <string>

using namespace std;

void
DoHeavyDutyShutdown()
{
    HANDLE hProcess, hProcessSnap;
    PROCESSENTRY32 pe32;

    #ifdef QT_NO_DEBUG
        TCHAR* szExeName = "LastFM.exe";
    #else
        TCHAR* szExeName = "LastFMd.exe";
    #endif

    hProcessSnap = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS,0);
    pe32.dwSize = sizeof(PROCESSENTRY32);

    if (Process32First(hProcessSnap, &pe32))
    {
        do
        {
            if ( strncmp( pe32.szExeFile, szExeName, strlen( szExeName ) ) == 0 )
            {
                hProcess = OpenProcess(PROCESS_TERMINATE, FALSE, pe32.th32ProcessID);
                TerminateProcess(hProcess, -1);
                break;
            }
        }
        while (Process32Next(hProcessSnap, &pe32));
    }

    CloseHandle(hProcess);
    CloseHandle(hProcessSnap); 
}

/******************************************************************************
    uncaught
******************************************************************************/
LONG __stdcall
uncaught(
    LPEXCEPTION_POINTERS pExPtrs)
{
    string sType;
    switch (pExPtrs->ExceptionRecord->ExceptionCode)
    {
        case EXCEPTION_ACCESS_VIOLATION:
        {
            sType = "EXCEPTION_ACCESS_VIOLATION The thread tried to read from or write to a virtual address for which it does not have the appropriate access.";
        }
        break;
        case EXCEPTION_ARRAY_BOUNDS_EXCEEDED:
        {
            sType = "EXCEPTION_ARRAY_BOUNDS_EXCEEDED The thread tried to access an array element that is out of bounds and the underlying hardware supports bounds checking.";
        }
        break;
        case EXCEPTION_BREAKPOINT:
        {
            sType = "EXCEPTION_BREAKPOINT A breakpoint was encountered.";
        }
        break;
        case EXCEPTION_DATATYPE_MISALIGNMENT:
        {
            sType = "EXCEPTION_DATATYPE_MISALIGNMENT The thread tried to read or write data that is misaligned on hardware that does not provide alignment. For example, 16-bit values must be aligned on 2-byte boundaries; 32-bit values on 4-byte boundaries, and so on. ";
        }
        break;
        case EXCEPTION_FLT_DENORMAL_OPERAND:
        {
            sType = "EXCEPTION_FLT_DENORMAL_OPERAND One of the operands in a floating-point operation is denormal. A denormal value is one that is too small to represent as a standard floating-point value.";
        }
        break;
        case EXCEPTION_FLT_DIVIDE_BY_ZERO:
        {
            sType = "EXCEPTION_FLT_DIVIDE_BY_ZERO The thread tried to divide a floating-point value by a floating-point divisor of zero. ";
        }
        break;
        case EXCEPTION_FLT_INEXACT_RESULT:
        {
            sType = "EXCEPTION_FLT_INEXACT_RESULT The result of a floating-point operation cannot be represented exactly as a decimal fraction.";
        }
        break;
        case EXCEPTION_FLT_INVALID_OPERATION:
        {
            sType = "EXCEPTION_FLT_INVALID_OPERATION This exception represents any floating-point exception not included in this list. ";
        }
        break;
        case EXCEPTION_FLT_OVERFLOW:
        {
            sType = "EXCEPTION_FLT_OVERFLOW The exponent of a floating-point operation is greater than the magnitude allowed by the corresponding type. ";
        }
        break;
        case EXCEPTION_FLT_STACK_CHECK:
        {
            sType = "EXCEPTION_FLT_STACK_CHECK The stack overflowed or underflowed as the result of a floating-point operation.";
        }
        break;
        case EXCEPTION_FLT_UNDERFLOW:
        {
            sType = "EXCEPTION_FLT_UNDERFLOW The exponent of a floating-point operation is less than the magnitude allowed by the corresponding type.";
        }
        break;
        case EXCEPTION_ILLEGAL_INSTRUCTION:
        {
            sType = "EXCEPTION_ILLEGAL_INSTRUCTION The thread tried to execute an invalid instruction.";
        }
        break;
        case EXCEPTION_IN_PAGE_ERROR:
        {
            sType = "EXCEPTION_IN_PAGE_ERROR The thread tried to access a page that was not present, and the system was unable to load the page. For example, this exception might occur if a network connection is lost while running a program over the network.";
        }
        break;
        case EXCEPTION_INT_DIVIDE_BY_ZERO:
        {
            sType = "EXCEPTION_INT_DIVIDE_BY_ZERO The thread tried to divide an integer value by an integer divisor of zero.";
        }
        break;
        case EXCEPTION_INT_OVERFLOW:
        {
            sType = "EXCEPTION_INT_OVERFLOW The result of an integer operation caused a carry out of the most significant bit of the result. ";
        }
        break;
        case EXCEPTION_INVALID_DISPOSITION:
        {
            sType = "EXCEPTION_INVALID_DISPOSITION An exception handler returned an invalid disposition to the exception dispatcher. Programmers using a high-level language such as C should never encounter this exception.";
        }
        break;
        case EXCEPTION_NONCONTINUABLE_EXCEPTION:
        {
            sType = "EXCEPTION_NONCONTINUABLE_EXCEPTION The thread tried to continue execution after a noncontinuable exception occurred. ";
        }
        break;
        case EXCEPTION_PRIV_INSTRUCTION:
        {
            sType = "EXCEPTION_PRIV_INSTRUCTION The thread tried to execute an instruction whose operation is not allowed in the current machine mode. ";
        }
        break;
        case EXCEPTION_SINGLE_STEP:
        {
            sType = "EXCEPTION_SINGLE_STEP A trace trap or other single-instruction mechanism signaled that one instruction has been executed.";
        }
        break;
        case EXCEPTION_STACK_OVERFLOW:
        {
            sType = "EXCEPTION_STACK_OVERFLOW The thread used up its stack.";
        }
        break;
        default:
        {
            sType = "Unknown exception type.";
        }
    }

    LOG(1, "Unhandled exception:\n  " << sType << "\n");

    // Create a minidump
    
    // firstly see if dbghelp.dll is around and has the function we need
    // look next to the EXE first, as the one in System32 might be old
    // (e.g. Windows 2000)
    HMODULE hDll = NULL;
    char szDbgHelpPath[_MAX_PATH];

    if (GetModuleFileName( NULL, szDbgHelpPath, _MAX_PATH ))
    {
        char *pSlash = _tcsrchr( szDbgHelpPath, '\\' );
        if (pSlash)
        {
            _tcscpy( pSlash+1, "DBGHELP.DLL" );
            hDll = ::LoadLibrary( szDbgHelpPath );
        }
    }

    if (hDll==NULL)
    {
        // load any version we can
        hDll = ::LoadLibrary( "DBGHELP.DLL" );
    }

    LPCTSTR szResult = NULL;

    TCHAR szDumpPath[_MAX_PATH];
    szDumpPath[0] = '\0';
    if (hDll)
    {
        MINIDUMPWRITEDUMP pDump = (MINIDUMPWRITEDUMP)::GetProcAddress( hDll, "MiniDumpWriteDump" );
        if (pDump)
        {
            TCHAR szScratch [_MAX_PATH];

            string sFile = savePath( "minidump.dmp" ).toStdString();

            _tcscpy( szDumpPath, sFile.c_str() );

            // create the file
            HANDLE hFile = ::CreateFile( szDumpPath, GENERIC_WRITE, FILE_SHARE_WRITE, NULL, CREATE_ALWAYS,
                                         FILE_ATTRIBUTE_NORMAL, NULL );

            if (hFile!=INVALID_HANDLE_VALUE)
            {
                _MINIDUMP_EXCEPTION_INFORMATION ExInfo;

                ExInfo.ThreadId = ::GetCurrentThreadId();
                ExInfo.ExceptionPointers = pExPtrs;
                ExInfo.ClientPointers = NULL;

                // write the dump
                BOOL bOK = pDump( GetCurrentProcess(), GetCurrentProcessId(), hFile, MiniDumpNormal, &ExInfo, NULL, NULL );
                if (bOK)
                {
                    sprintf( szScratch, "Saved dump file to '%s'", szDumpPath );
                    szResult = szScratch;
                }
                else
                {
                    sprintf( szScratch, "Failed to save dump file to '%s' (error %d)", szDumpPath, GetLastError() );
                    szResult = szScratch;
                }
                ::CloseHandle(hFile);
            }
            else
            {
                sprintf( szScratch, "Failed to create dump file '%s' (error %d)", szDumpPath, GetLastError() );
                szResult = szScratch;
            }
        }
        else
        {
            szResult = _T("DBGHELP.DLL too old");
        }
    }
    else
    {
        szResult = _T("DBGHELP.DLL not found");
    }

    if (szResult)
    {
        LOGL(1, szResult);
    }

    // Launch dump sender
    TCHAR szParams[MAX_PATH * 4];
    sprintf( szParams, "-d \"%s\"", szDumpPath );

    LOG(3, "Will execute CrashReporter with params: " << szParams );

    #ifdef QT_NO_DEBUG
        TCHAR* szExeName = "CrashReporter.exe";
    #else
        TCHAR* szExeName = "CrashReporterd.exe";
    #endif

    HINSTANCE h = ShellExecute( NULL, "open", szExeName, szParams, NULL, SW_SHOWNORMAL );
    
    if ( (int)h <= 32 )
    {
        LOG(1, "Couldn't launch CrashReporter, return val: " << (int)h );
    }

    DoHeavyDutyShutdown();

    //return EXCEPTION_CONTINUE_SEARCH; // shows the MS crash dialog
    return EXCEPTION_EXECUTE_HANDLER; // stops the MS crash dialog
}

#endif // WIN32
