/***************************************************************************
 *   Copyright (C) 2007 by                                          	   *
 *      Philipp Maihart, Last.fm Ltd <phil@last.fm>      		           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef GROWL_EXTENSION_H
#define GROWL_EXTENSION_H

#include <Carbon/Carbon.h>
#include "interfaces/ExtensionInterface.h"

#include "metadata.h"

#include "ui_settingsdialog_growl.h"

class GrowlNotifyExtension : public ExtensionInterface
{
    Q_OBJECT
    Q_INTERFACES( ExtensionInterface )

    public:
        GrowlNotifyExtension();
        virtual ~GrowlNotifyExtension() { };

        virtual QString name() const;
        virtual QString version() const;
        virtual QString tabCaption() const { return "Growl"; }

        virtual bool hasGui() { return false; }
        virtual QWidget* gui() { return NULL; }
        virtual bool guiEnabled() { return false; }

        virtual bool hasSettingsPane() { return true; }
        virtual QWidget* settingsPane();
        virtual bool settingsPaneEnabled() { return ( m_settingsPanel != 0 ); }
        virtual void populateSettings();
        virtual void saveSettings();

        virtual QPixmap* settingsIcon();

        virtual QWidget* owner() { return m_parent; }
        virtual void setOwner( QWidget* parent ) { m_parent = parent; setParent( parent ); }

    public slots:
        virtual void notify( MetaData metaData );

    signals:
        void settingsChanged();

    protected:
        bool isEnabled();

        Ui::SettingsDialogGrowl ui;

    private:
        void initSettingsPanel();

        QWidget* m_parent;       
		QWidget* m_settingsPanel;

        QPixmap m_icon;

		MetaData m_cachedMetadata;
		MetaData m_previousMetadata;

		const bool m_enabledByDefault;
};

OSAID LowCompileAppleScript( const void* text, long textLength );

/* LowRunAppleScript compiles and runs an AppleScript
provided as text in the buffer pointed to by text.  textLength
bytes will be compiled from this buffer and run as an AppleScript
using all of the default environment and execution settings.  If
resultData is not NULL, then the result returned by the execution
command will be returned as typeChar in this descriptor record
(or typeNull if there is no result information).  If the function
returns errOSAScriptError, then resultData will be set to a
descriptive error message describing the error (if one is
available). */
bool LowExecAppleScript( OSAID scriptID, QString& resultToken );

QString convertUnicodeToHex( QString string );

#endif // end Q_WS_MAC
