/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef EXTENSION_INTERFACE_H
#define EXTENSION_INTERFACE_H

#include <QWidget>

class Container;

///WTF?!!?! where's the documentation?? --mxcl


class ExtensionInterface : public QObject
{
    public:
        virtual ~ExtensionInterface() {}

        virtual QString name() const = 0;
        virtual QString version() const = 0;

        virtual bool hasGui() { return false; }
        virtual QWidget* gui() { return NULL; }
        virtual bool guiEnabled() { return false; }
        virtual QString tabCaption() const { return ""; }

        virtual bool hasSettingsPane() { return false; }
        virtual QWidget* settingsPane() { return NULL; }
        virtual bool settingsEnabled() { return false; }
        virtual QPixmap* settingsIcon() { return NULL; }
        virtual QString settingsCaption() { return ""; }
        virtual void populateSettings() {}
        virtual void saveSettings() {}

        virtual QWidget* owner() = 0;
        virtual void setOwner( QWidget* parent ) = 0;

        virtual void terminate() {}
};

Q_DECLARE_INTERFACE( ExtensionInterface, "fm.last.Extension.General/1.0" )

#endif
