/***************************************************************************
*   Copyright (C) 2007 by                                                 *
*      Philipp Maihart, Last.fm Ltd <phil@last.fm>                        *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
***************************************************************************/

#ifndef MESSAGEBOX_H
#define MESSAGEBOX_H

#include "lastfmtools_common.h"

#include <QMessageBox>

class MCEXP LastMessageBox : public QMessageBox
{
    Q_OBJECT
    
    public:
        LastMessageBox ();
        LastMessageBox ( Icon icon,
                     const QString & title,
                     const QString & text,
                     StandardButtons buttons = NoButton, 
                     Qt::WindowFlags f = Qt::Dialog | Qt::MSWindowsFixedSizeDialogHint, 
                     QStringList buttonTexts = QStringList() );
        
        virtual void setText ( const QString & text );
        virtual void setWindowTitle ( const QString & title );
        virtual const QSize sizeHint() { return QSize( 480, 153 ); }
        
        static QMessageBox::StandardButton critical(const QString & title = "", 
                                                    const QString & text = "", StandardButtons buttons = Ok, 
                                                    StandardButton defaultButton = NoButton, QStringList buttonTexts = QStringList() );
        static QMessageBox::StandardButton information( const QString & title = "", 
                                                    const QString & text = "", StandardButtons buttons = Ok, 
                                                    StandardButton defaultButton = NoButton, QStringList buttonTexts = QStringList() );
        static QMessageBox::StandardButton question( const QString & title = "", 
                                                    const QString & text = "", StandardButtons buttons = Ok, 
                                                    StandardButton defaultButton = NoButton, QStringList buttonTexts = QStringList() );
        static QMessageBox::StandardButton warning( const QString & title = "", 
                                                    const QString & text = "", StandardButtons buttons = Ok, 
                                                    StandardButton defaultButton = NoButton, QStringList buttonTexts = QStringList() );
};

#ifdef Q_WS_MAC
QMessageBox::StandardButton 
showMacMessageBox(QWidget *parent, QMessageBox::Icon icon,
                  const QString& title, const QString& text,
                  QMessageBox::StandardButtons buttons,
                  QMessageBox::StandardButton defaultButton,
                  QStringList buttonTexts = QStringList()
                  );
#endif

#endif // MESSAGEBOX_H
