/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Max Howell, Last.fm Ltd <max@last.fm>                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include <QUrl>

#include "containerutils.h"
#include "http.h"
#include "logger.h"
#include "Request.h"
#include "Settings.h"
#include "WebService.h"


Handshake::Handshake()
        : Request( TypeHandshake, "Handshake" )
        , m_isSubscriber( false )
{}

void
Handshake::start()
{
  #ifdef WIN32
    static const char *PLATFORM = "win32";
  #elif defined Q_WS_X11
    static const char *PLATFORM = "linux";
  #elif defined Q_WS_MAC
    static const char *PLATFORM = "mac";
  #else
    static const char *PLATFORM = "unknown";
  #endif
            
    QString const path = "/radio/handshake.php"
            "?version=" + m_version +
            "&platform=" + PLATFORM +
            "&username=" + QString( QUrl::toPercentEncoding( m_username ) ) +
            "&passwordmd5=" + m_password +
            "&language=" + The::settings().appLanguage();

    get( path );
}

void
Handshake::success( QByteArray data )
{
    Q_DEBUG_BLOCK;
    
    QString const result( data );
    
    LOGL( 3, "Handshake response:\n" << result );

    m_session = parameter( "session", result );
    m_baseHost = parameter( "base_url", result );
    m_basePath = parameter( "base_path", result );
    m_streamUrl.setUrl( parameter( "stream_url", result ) );
    m_isSubscriber = parameter( "subscriber", result ) == "1";
    m_message = parameter( "info_message", result );
    bool const is_banned = parameter( "banned", result ) == "1";
    
    if ( m_session.isEmpty() || 
         m_baseHost.isEmpty() || 
         m_basePath.isEmpty() ||
         m_streamUrl.isEmpty() )
    {
        setFailed( Handshake_SessionFailed, tr("Could not connect to server.") );
    } 
    else if ( is_banned )
    {
        LOGL( 1, "Client version is banned" );

        setFailed( Handshake_Banned,
           tr( "This client version is obsolete. Please update." ) );
    }
    else if ( m_session.toLower() == "failed" )
    {
        LOGL( 1, "Radio handshake failed: session == 'failed'" );
        
        QString msg = parameter( "msg", result ).toLower();
        
        if ( msg == "no such user" || msg == "padd md5 not 32 len" )
            setFailed( Handshake_WrongUserNameOrPassword,
                tr("Could not connect to server. Wrong username or password.") );
        else       
            setFailed( Handshake_SessionFailed,
                tr("Could not connect to server.") );
    }
    else if ( m_session.length() != 32 )
    {
        LOGL( 1, "Radio handshake failed: session length not 32 bytes. Retrying." );
        tryAgain();
    }
    else
    {
        Request::setBaseHost( m_baseHost );

        LOGL( 3, "Radio handshake successful. Host: " << m_baseHost << ", path: " << m_basePath );
    }
}
