/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef IMAGE_BUTTON_H
#define IMAGE_BUTTON_H

#include "lastfmtools_common.h"
#include <QLabel>
#include <QPixmap>


class MCEXP ImageButton : public QLabel
{
    Q_OBJECT

    public:
        ImageButton( QWidget* parent = 0 );

        void setImages(
                QString prefix,
                QString normal,
                QString down,
                QString hover,
                QString disabled );

        void setImages(
                QPixmap normal,
                QPixmap down,
                QPixmap hover,
                QPixmap disabled );

        void setEnabled( bool enabled );
        void setHoverCursor( QCursor cursor );

        void enterEvent( QEvent* event );
        void leaveEvent( QEvent* event );
        void mousePressEvent( QMouseEvent* event );
        void mouseReleaseEvent( QMouseEvent* event );

    private:
        QPixmap m_normal;
        QPixmap m_down;
        QPixmap m_hover;
        QPixmap m_disabled;

        //QCursor m_hoverCursor;

        bool m_enabled;

    signals:
        void clicked();
};

#endif
