/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef UTILS_H
#define UTILS_H

#include "lastfmtools_common.h"
#include "../RadioEnums.h"

#include <string>
#include <vector>

#include <QStringList>
#include <QString>

/*************************************************************************/ /**
    A bunch of static utility functions.
******************************************************************************/
class MCEXP CUtils
{
public:

    /*********************************************************************/ /**
        Takes a string containing several quoted strings, like
        "abc" "def" ...
        and separates the quoted strings out into the supplied vector.

        @param[in] sCompound The compound string to be parsed.
        @param[out] separated The vector to put the individual strings in.
    **************************************************************************/
    
    //FIXME WHY std::string!!
    static void ParseQuotedStrings(
            const std::string& sCompound,
            std::vector<std::string>& separated );

    /*********************************************************************/ /**
        Trims string of whitespace at beginning and end.

        @param[in] str String to trim.
    **************************************************************************/
    static void Trim( std::string& str );

    /*********************************************************************/ /**
        Strips all []-enclosed sections from string.

        @param[in] str String to strip.
    **************************************************************************/
    static void StripBBCode( std::string& str );
    
    static void StripBBCode( QString& str );

    /*********************************************************************/ /**
        Use this to URL encode any database item (artist, track, album). It
        internally calls UrlEncodeSpecialChars to double encode some special
        symbols according to the same pattern as that used on the website.
        
        Use for any urls that go to www.last.fm
        Do not use for ws.audioscrobbler.com

        @param[in] str String to encode.
    **************************************************************************/
    static QString UrlEncodeItem( QString item );

    /*********************************************************************/ /**
        Translate RadioStates to strings for debugging purposes.
    **************************************************************************/
    static QString radioState2String( RadioState state );
    

private:

    /*********************************************************************/ /**
        Encodes the following characters once to fit with the way artist
        names etc are encoded on the site: &, /, ;, +, #
        
        The string returned from this function can then be passed to QUrl::
        toPercentEncoding.

        @param[in] str String to encode.
    **************************************************************************/
    
    static QString& UrlEncodeSpecialChars( QString& str );
    
private:
    // no definition
    CUtils();
    CUtils( const CUtils& );
};

#endif // UTILS_H
