/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "logindialog.h"
#include "logger.h"

LoginDialog::LoginDialog( QWidget* parent,
                          LoginWidget::Mode mode,
                          QString defaultUser )
        : QDialog( parent )
        , m_loginWidget( this, mode, defaultUser )
{
    ui.setupUi( this );

    switch (mode) 
    {
        case LoginWidget::LOGIN:
            setWindowTitle( tr("Log In") );
            break;
        
        case LoginWidget::ADD_USER:
            setWindowTitle( tr("Add User") );
            break;
        
        case LoginWidget::CHANGE_PASS:
            setWindowTitle( tr("Change Password") );
            break;
    }

    // Want etched, not flat
    ui.line->setFrameShadow( QFrame::Sunken );

    ui.vboxLayout->insertWidget(0, &m_loginWidget);

    connect(&m_loginWidget, SIGNAL(verifyResult(bool, bool)),
            this,           SLOT  (loginVerified(bool)));

}

void
LoginDialog::accept()
{
    QApplication::setOverrideCursor(QCursor(Qt::WaitCursor));

    m_loginWidget.verify();
}

void
LoginDialog::loginVerified(
    bool valid)
{
    QApplication::restoreOverrideCursor();

    if (valid)
    {
        m_loginWidget.save();
        QDialog::accept();
    }
    else
    {
        // Do nothing, remain on login page    
    }
}    
