/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "gpoddevice.h"
#include <containerutils.h>
#include <Loqqer.h>


GPodDevice::GPodDevice()
    : m_itdb( 0 )
{
    gLogger.Init( savePath( "gpod.log" ), false );
    gLogger.SetLevel( 4 );

    LOGL( 3, "Initialising GPod" );

    m_itdb = itdb_new();
    if ( !m_itdb )
        LOGL( 3, "Could not find iPod" );

    itdb_set_mountpoint( m_itdb, QFile::encodeName( "/home/muesli/last.fm/client/Audioscrobbler/ipodData.new" ) );
    Itdb_Playlist *mpl = itdb_playlist_new( "iPod", false );
    itdb_playlist_set_mpl( mpl );

    GError* err = 0;
    m_itdb = itdb_parse( QFile::encodeName( "/home/muesli/last.fm/client/Audioscrobbler/ipodData.new" ), &err );
    if ( err )
    {
        g_error_free( err );
        if ( m_itdb )
        {
            itdb_free( m_itdb );
            m_itdb = 0;
            return;
        }
    }
}


QList<TrackInfo>
GPodDevice::tracks()
{
    QList<TrackInfo> tl;
    if ( !m_itdb )
        return tl;

    GList *cur;
    for ( cur = m_itdb->tracks; cur; cur = cur->next )
    {
        Itdb_Track *track = (Itdb_Track *)cur->data;

        QDateTime dt;
        if ( track )
            dt.setTime_t( itdb_time_mac_to_host( track->time_played ) );

        TrackInfo t;
        t.setArtist( track->artist );
        t.setAlbum( track->album );
        t.setTrack( track->title );
        t.setPath( track->ipod_path );
        t.setTimeStamp( dt.toString( "yyyy-MM-dd hh:mm:ss" ) );
        t.setDuration( track->tracklen / 1000 );
        t.setPlayCount( track->playcount );

        if ( dt.toString() != "Thu Jan 1 01:00:00 1970" )
            tl << t;
    }

    return tl;
}

Q_EXPORT_PLUGIN2( mediadevice, GPodDevice )
