/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "wikitextbrowser.h"
#include <QDebug>

void
WikiTextBrowser::setSource( const QUrl & /*name*/ )
{
    // This is only overridden to prevent QTextBrowser from calling
    // setSource after clicking the wiki link, thus emptying the
    // field.
}

QSize
WikiTextBrowser::minimumSizeHint() const
{
    return QSize( 0, 0 );
}

QSize
WikiTextBrowser::sizeHint() const
{
    QString contents = toPlainText();

    QRect itemRect = fontMetrics().boundingRect(
        QRect( 0, 0, width(), height() ),
        Qt::AlignLeft | Qt::AlignTop | Qt::TextWordWrap, contents );

    return QSize( itemRect.width(), itemRect.height() + fontMetrics().height() + 4 );
}
