/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "dragtextbrowser.h"

DragTextBrowser::DragTextBrowser( QWidget* parent )
    : QTextBrowser( parent )
    , m_parent( parent )
{
}


void
DragTextBrowser::mousePressEvent( QMouseEvent *event )
{
     if ( event->button() == Qt::LeftButton )
        m_dragStartPosition = event->pos();
}


void
DragTextBrowser::mouseReleaseEvent( QMouseEvent *event )
{
    QString anchor = anchorAt( m_dragStartPosition );
    QTextCursor c = document()->find( anchor );
    if ( !c.isNull() )
    {
        c.movePosition( QTextCursor::Right, QTextCursor::KeepAnchor );
        QTextCharFormat f = c.charFormat();
        QFont font = f.font();

//         qDebug() << "cursor" << c.position() << font.pointSizeF();

        font.setBold( true );
        font.setUnderline( false );
        f.setFont( font );
//         f.setFontPointSize( font.pointSizeF() );

        c.mergeCharFormat( f );
    }

    if ( !anchor.isEmpty() )
    {
        qDebug() << "Emitting click event:" << anchor;
        emit textClicked( anchor );
    }
}


void
DragTextBrowser::mouseMoveEvent( QMouseEvent *event )
{
    QTextBrowser::mouseMoveEvent( event );
    if ( !( event->buttons() & Qt::LeftButton ) )
        return;
    if ( ( event->pos() - m_dragStartPosition ).manhattanLength() < QApplication::startDragDistance() )
        return;

    QString anchor = anchorAt( event->pos() );
    if ( !anchor.isEmpty() )
    {
        qDebug() << "Starting drag event:" << anchor;

        QDrag *drag = new QDrag( this );

        QMimeData *mimeData = new QMimeData();
        mimeData->setText( anchor );

        QPainter painter;
        QPixmap pixmap( painter.fontMetrics().width( anchor ) + 16, painter.fontMetrics().height() + 4 );
        QRect rect( 0, 0, pixmap.width() - 1, pixmap.height() - 1 );

        painter.begin( &pixmap );
        painter.setBackgroundMode( Qt::OpaqueMode );

        painter.setBrush( Qt::white );
        painter.setPen( Qt::black );
        painter.drawRect( 0, 0, pixmap.width() - 1, pixmap.height() - 1 );

        painter.setPen( Qt::black );
        painter.drawText( 8, 12, anchor );
        painter.end();

        drag->setMimeData( mimeData );
        drag->setPixmap( pixmap );

        Qt::DropAction dropAction = drag->start( Qt::CopyAction );
    }
}

