/* search.c generated by valac 0.10.3, the Vala compiler
 * generated from search.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksourceview.h>
#include <float.h>
#include <math.h>
#include <config.h>
#include <stdio.h>


#define TYPE_GOTO_LINE (goto_line_get_type ())
#define GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GOTO_LINE, GotoLine))
#define GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GOTO_LINE, GotoLineClass))
#define IS_GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GOTO_LINE))
#define IS_GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GOTO_LINE))
#define GOTO_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GOTO_LINE, GotoLineClass))

typedef struct _GotoLine GotoLine;
typedef struct _GotoLineClass GotoLineClass;
typedef struct _GotoLinePrivate GotoLinePrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_SEARCH_AND_REPLACE (search_and_replace_get_type ())
#define SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplace))
#define SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))
#define IS_SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_AND_REPLACE))
#define IS_SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_AND_REPLACE))
#define SEARCH_AND_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))

typedef struct _SearchAndReplace SearchAndReplace;
typedef struct _SearchAndReplaceClass SearchAndReplaceClass;
typedef struct _SearchAndReplacePrivate SearchAndReplacePrivate;
typedef struct _Block13Data Block13Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_SELECTION_TYPE (selection_type_get_type ())

struct _GotoLine {
	GtkHBox parent_instance;
	GotoLinePrivate * priv;
};

struct _GotoLineClass {
	GtkHBoxClass parent_class;
};

struct _GotoLinePrivate {
	MainWindow* main_window;
	GtkEntry* entry;
};

struct _SearchAndReplace {
	GObject parent_instance;
	SearchAndReplacePrivate * priv;
};

struct _SearchAndReplaceClass {
	GObjectClass parent_class;
};

struct _SearchAndReplacePrivate {
	MainWindow* main_window;
	Document* working_document;
	GtkWidget* widget;
	GtkButton* button_arrow;
	GtkArrow* arrow;
	GtkEntry* entry_find;
	GtkLabel* label_find_normal;
	GtkLabel* label_find_error;
	GtkEntry* entry_replace;
	GtkFrame* frame_replace;
	GtkHBox* hbox_replace;
	GtkCheckMenuItem* check_case_sensitive;
	GtkCheckMenuItem* check_entire_word;
	gint min_nb_chars_for_incremental_search;
};

struct _Block13Data {
	int _ref_count_;
	SearchAndReplace * self;
	GtkButton* button_clear_find;
	GtkButton* button_clear_replace;
	GtkButton* button_replace;
	GtkButton* button_replace_all;
	GtkButton* button_previous;
	GtkButton* button_next;
	GtkMenu* menu;
};

typedef enum  {
	SELECTION_TYPE_NO_SELECTION,
	SELECTION_TYPE_ONE_LINE,
	SELECTION_TYPE_MULTIPLE_LINES
} SelectionType;


static gpointer goto_line_parent_class = NULL;
static gpointer search_and_replace_parent_class = NULL;

GType goto_line_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define GOTO_LINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GOTO_LINE, GotoLinePrivate))
enum  {
	GOTO_LINE_DUMMY_PROPERTY
};
GotoLine* goto_line_new (MainWindow* main_window);
GotoLine* goto_line_construct (GType object_type, MainWindow* main_window);
static void _lambda23_ (GotoLine* self);
static void __lambda23__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda24_ (GotoLine* self);
static void __lambda24__gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void _lambda25_ (GotoLine* self);
static void __lambda25__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void goto_line_on_changed (GotoLine* self);
static void _goto_line_on_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
void goto_line_show (GotoLine* self);
void utils_set_entry_error (GtkWidget* entry, gboolean _error_);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
gboolean document_goto_line (Document* self, gint line);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* main_window_get_active_view (MainWindow* self);
void document_view_scroll_to_cursor (DocumentView* self, double margin);
static void goto_line_finalize (GObject* obj);
GType search_and_replace_get_type (void) G_GNUC_CONST;
#define SEARCH_AND_REPLACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_AND_REPLACE, SearchAndReplacePrivate))
enum  {
	SEARCH_AND_REPLACE_DUMMY_PROPERTY
};
SearchAndReplace* search_and_replace_new (MainWindow* main_window);
SearchAndReplace* search_and_replace_construct (GType object_type, MainWindow* main_window);
static void _lambda26_ (GtkEntryIconPosition icon_pos, GdkEvent* event, Block13Data* _data13_);
static void __lambda26__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void _lambda27_ (SearchAndReplace* self);
static gboolean search_and_replace_get_search_and_replace_mode (SearchAndReplace* self);
static void __lambda27__gtk_button_clicked (GtkButton* _sender, gpointer self);
void search_and_replace_hide (SearchAndReplace* self);
static void _search_and_replace_hide_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda28_ (SearchAndReplace* self);
static void __lambda28__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda29_ (SearchAndReplace* self);
static void __lambda29__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda30_ (SearchAndReplace* self);
static void search_and_replace_set_search_text (SearchAndReplace* self, gboolean select);
void document_search_backward (Document* self);
static void __lambda30__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void search_and_replace_search_forward (SearchAndReplace* self);
static void _search_and_replace_search_forward_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _search_and_replace_search_forward_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void _lambda31_ (Block13Data* _data13_);
static void search_and_replace_clear_search (SearchAndReplace* self);
static void __lambda31__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _lambda32_ (Block13Data* _data13_);
static void __lambda32__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _lambda33_ (SearchAndReplace* self);
static void __lambda33__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void _lambda34_ (SearchAndReplace* self);
static void __lambda34__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void search_and_replace_replace (SearchAndReplace* self);
static void _search_and_replace_replace_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _search_and_replace_replace_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void _lambda35_ (SearchAndReplace* self);
void document_replace_all (Document* self, const char* text);
static void __lambda35__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _lambda36_ (GdkEventKey* event, SearchAndReplace* self);
void search_and_replace_show_search_and_replace (SearchAndReplace* self);
static gboolean __lambda36__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (Block13Data* _data13_);
GtkWidget* search_and_replace_get_widget (SearchAndReplace* self);
void search_and_replace_show_search (SearchAndReplace* self);
static void search_and_replace_show (SearchAndReplace* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_get_active_tab (MainWindow* self);
static void search_and_replace_set_replace_sensitivity (SearchAndReplace* self);
GType selection_type_get_type (void) G_GNUC_CONST;
SelectionType document_get_selection_type (Document* self);
static void search_and_replace_active_document_changed (SearchAndReplace* self);
static void _search_and_replace_active_document_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void search_and_replace_set_label_text (SearchAndReplace* self, const char* text, gboolean _error_);
static void search_and_replace_on_search_info_updated (SearchAndReplace* self, gboolean selected, guint nb_matches, guint num_match);
static void _search_and_replace_on_search_info_updated_document_search_info_updated (Document* _sender, gboolean selected, guint nb_matches, guint num_match, gpointer self);
void document_set_search_text (Document* self, const char* text, gboolean case_sensitive, gboolean entire_word, guint* nb_matches, guint* num_match, gboolean select);
static gboolean search_and_replace_get_case_sensitive (SearchAndReplace* self);
static gboolean search_and_replace_get_entire_word (SearchAndReplace* self);
void document_search_forward (Document* self);
void document_clear_search (Document* self, gboolean disconnect_signals);
gboolean document_get_readonly (Document* self);
void document_replace (Document* self, const char* text);
static void search_and_replace_finalize (GObject* obj);
static void search_and_replace_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);



static void _lambda23_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void __lambda23__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda23_ (self);
}


static void _lambda24_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void __lambda24__gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	_lambda24_ (self);
}


static void _lambda25_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void __lambda25__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	_lambda25_ (self);
}


static void _goto_line_on_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	goto_line_on_changed (self);
}


GotoLine* goto_line_construct (GType object_type, MainWindow* main_window) {
	GotoLine * self;
	GtkButton* close_button;
	GtkImage* img;
	GtkLabel* label;
	GtkEntry* _tmp0_;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	self->priv->main_window = main_window;
	gtk_box_set_spacing ((GtkBox*) self, 3);
	close_button = g_object_ref_sink ((GtkButton*) gtk_button_new ());
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) close_button, FALSE, FALSE, (guint) 0);
	gtk_button_set_relief (close_button, GTK_RELIEF_NONE);
	img = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLOSE, GTK_ICON_SIZE_MENU));
	gtk_container_add ((GtkContainer*) close_button, (GtkWidget*) img);
	g_signal_connect_object (close_button, "clicked", (GCallback) __lambda23__gtk_button_clicked, self, 0);
	label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Go to Line:")));
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) label, FALSE, FALSE, (guint) 2);
	self->priv->entry = (_tmp0_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->entry), _tmp0_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->entry, FALSE, FALSE, (guint) 0);
	gtk_entry_set_icon_from_stock (self->priv->entry, GTK_ENTRY_ICON_SECONDARY, GTK_STOCK_JUMP_TO);
	gtk_entry_set_icon_activatable (self->priv->entry, GTK_ENTRY_ICON_SECONDARY, TRUE);
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->entry, _ ("Line you want to move the cursor to"));
	gtk_widget_set_size_request ((GtkWidget*) self->priv->entry, 100, -1);
	g_signal_connect_object (self->priv->entry, "activate", (GCallback) __lambda24__gtk_entry_activate, self, 0);
	g_signal_connect_object (self->priv->entry, "icon-press", (GCallback) __lambda25__gtk_entry_icon_press, self, 0);
	g_signal_connect_object ((GtkEditable*) self->priv->entry, "changed", (GCallback) _goto_line_on_changed_gtk_editable_changed, self, 0);
	_g_object_unref0 (label);
	_g_object_unref0 (img);
	_g_object_unref0 (close_button);
	return self;
}


GotoLine* goto_line_new (MainWindow* main_window) {
	return goto_line_construct (TYPE_GOTO_LINE, main_window);
}


void goto_line_show (GotoLine* self) {
	g_return_if_fail (self != NULL);
	gtk_entry_set_text (self->priv->entry, "");
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_widget_grab_focus ((GtkWidget*) self->priv->entry);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static void goto_line_on_changed (GotoLine* self) {
	char* text;
	gint line;
	gboolean _error_;
	g_return_if_fail (self != NULL);
	if (gtk_entry_get_text_length (self->priv->entry) == 0) {
		utils_set_entry_error ((GtkWidget*) self->priv->entry, FALSE);
		return;
	}
	text = g_strdup (gtk_entry_get_text (self->priv->entry));
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gunichar c;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < string_get_length (text))) {
					break;
				}
				c = g_utf8_get_char (g_utf8_offset_to_pointer (text, i));
				if (!g_unichar_isdigit (c)) {
					utils_set_entry_error ((GtkWidget*) self->priv->entry, TRUE);
					_g_free0 (text);
					return;
				}
			}
		}
	}
	line = atoi (text);
	_error_ = !document_goto_line (main_window_get_active_document (self->priv->main_window), line = line - 1);
	utils_set_entry_error ((GtkWidget*) self->priv->entry, _error_);
	document_view_scroll_to_cursor (main_window_get_active_view (self->priv->main_window), 0.25);
	_g_free0 (text);
}


static void goto_line_class_init (GotoLineClass * klass) {
	goto_line_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GotoLinePrivate));
	G_OBJECT_CLASS (klass)->finalize = goto_line_finalize;
}


static void goto_line_instance_init (GotoLine * self) {
	self->priv = GOTO_LINE_GET_PRIVATE (self);
}


static void goto_line_finalize (GObject* obj) {
	GotoLine * self;
	self = GOTO_LINE (obj);
	_g_object_unref0 (self->priv->entry);
	G_OBJECT_CLASS (goto_line_parent_class)->finalize (obj);
}


GType goto_line_get_type (void) {
	static volatile gsize goto_line_type_id__volatile = 0;
	if (g_once_init_enter (&goto_line_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GotoLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) goto_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GotoLine), 0, (GInstanceInitFunc) goto_line_instance_init, NULL };
		GType goto_line_type_id;
		goto_line_type_id = g_type_register_static (GTK_TYPE_HBOX, "GotoLine", &g_define_type_info, 0);
		g_once_init_leave (&goto_line_type_id__volatile, goto_line_type_id);
	}
	return goto_line_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda26_ (GtkEntryIconPosition icon_pos, GdkEvent* event, Block13Data* _data13_) {
	SearchAndReplace * self;
	self = _data13_->self;
	g_return_if_fail (event != NULL);
	if (icon_pos == GTK_ENTRY_ICON_PRIMARY) {
		gtk_menu_popup (_data13_->menu, NULL, NULL, NULL, NULL, event->button.button, event->button.time);
	}
}


static void __lambda26__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	_lambda26_ (p0, p1, self);
}


static void _lambda27_ (SearchAndReplace* self) {
	if (search_and_replace_get_search_and_replace_mode (self)) {
		g_object_set (self->priv->arrow, "arrow-type", GTK_ARROW_DOWN, NULL);
		gtk_widget_hide ((GtkWidget*) self->priv->frame_replace);
		gtk_widget_hide ((GtkWidget*) self->priv->hbox_replace);
	} else {
		g_object_set (self->priv->arrow, "arrow-type", GTK_ARROW_UP, NULL);
		gtk_widget_show ((GtkWidget*) self->priv->frame_replace);
		gtk_widget_show ((GtkWidget*) self->priv->hbox_replace);
	}
}


static void __lambda27__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda27_ (self);
}


static void _search_and_replace_hide_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_hide (self);
}


static void _lambda28_ (SearchAndReplace* self) {
	gtk_entry_set_text (self->priv->entry_find, "");
}


static void __lambda28__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda28_ (self);
}


static void _lambda29_ (SearchAndReplace* self) {
	gtk_entry_set_text (self->priv->entry_replace, "");
}


static void __lambda29__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda29_ (self);
}


static void _lambda30_ (SearchAndReplace* self) {
	search_and_replace_set_search_text (self, FALSE);
	g_return_if_fail (self->priv->working_document != NULL);
	document_search_backward (self->priv->working_document);
}


static void __lambda30__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda30_ (self);
}


static void _search_and_replace_search_forward_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_search_forward (self);
}


static void _search_and_replace_search_forward_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	search_and_replace_search_forward (self);
}


static void _lambda31_ (Block13Data* _data13_) {
	SearchAndReplace * self;
	gboolean sensitive;
	self = _data13_->self;
	sensitive = gtk_entry_get_text_length (self->priv->entry_find) > 0;
	gtk_widget_set_sensitive ((GtkWidget*) _data13_->button_clear_find, sensitive);
	gtk_widget_set_sensitive ((GtkWidget*) _data13_->button_previous, sensitive);
	gtk_widget_set_sensitive ((GtkWidget*) _data13_->button_next, sensitive);
	gtk_widget_set_sensitive ((GtkWidget*) _data13_->button_replace, sensitive);
	gtk_widget_set_sensitive ((GtkWidget*) _data13_->button_replace_all, sensitive);
	if (gtk_entry_get_text_length (self->priv->entry_find) == 0) {
		gtk_widget_hide ((GtkWidget*) self->priv->label_find_normal);
		gtk_widget_hide ((GtkWidget*) self->priv->label_find_error);
		search_and_replace_clear_search (self);
	} else {
		if (gtk_entry_get_text_length (self->priv->entry_find) >= self->priv->min_nb_chars_for_incremental_search) {
			search_and_replace_set_search_text (self, TRUE);
		}
	}
}


static void __lambda31__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	_lambda31_ (self);
}


static void _lambda32_ (Block13Data* _data13_) {
	SearchAndReplace * self;
	self = _data13_->self;
	gtk_widget_set_sensitive ((GtkWidget*) _data13_->button_clear_replace, gtk_entry_get_text_length (self->priv->entry_replace) > 0);
}


static void __lambda32__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	_lambda32_ (self);
}


static void _lambda33_ (SearchAndReplace* self) {
	search_and_replace_set_search_text (self, TRUE);
}


static void __lambda33__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	_lambda33_ (self);
}


static void _lambda34_ (SearchAndReplace* self) {
	search_and_replace_set_search_text (self, TRUE);
}


static void __lambda34__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	_lambda34_ (self);
}


static void _search_and_replace_replace_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_replace (self);
}


static void _search_and_replace_replace_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	search_and_replace_replace (self);
}


static void _lambda35_ (SearchAndReplace* self) {
	g_return_if_fail (gtk_entry_get_text_length (self->priv->entry_find) != 0);
	search_and_replace_set_search_text (self, TRUE);
	document_replace_all (self->priv->working_document, gtk_entry_get_text (self->priv->entry_replace));
}


static void __lambda35__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda35_ (self);
}


static gboolean _lambda36_ (GdkEventKey* event, SearchAndReplace* self) {
	gboolean result = FALSE;
	if ((*event).keyval == 0xff09) {
		search_and_replace_show_search_and_replace (self);
		gtk_widget_grab_focus ((GtkWidget*) self->priv->entry_replace);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean __lambda36__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = _lambda36_ (event, self);
	return result;
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (Block13Data* _data13_) {
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		_g_object_unref0 (_data13_->self);
		_g_object_unref0 (_data13_->menu);
		_g_object_unref0 (_data13_->button_next);
		_g_object_unref0 (_data13_->button_previous);
		_g_object_unref0 (_data13_->button_replace_all);
		_g_object_unref0 (_data13_->button_replace);
		_g_object_unref0 (_data13_->button_clear_replace);
		_g_object_unref0 (_data13_->button_clear_find);
		g_slice_free (Block13Data, _data13_);
	}
}


SearchAndReplace* search_and_replace_construct (GType object_type, MainWindow* main_window) {
	SearchAndReplace * self = NULL;
	char* path;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (SearchAndReplace*) g_object_new (object_type, NULL);
	self->priv->main_window = main_window;
	path = g_build_filename (DATA_DIR, "ui", "search_and_replace.ui", NULL);
	{
		Block13Data* _data13_;
		GtkBuilder* builder;
		GtkWidget* _tmp0_;
		GtkButton* _tmp1_;
		GtkArrow* _tmp2_;
		GtkEntry* _tmp3_;
		GtkLabel* _tmp4_;
		GtkLabel* _tmp5_;
		GtkEventBox* eventbox_label1;
		GtkEventBox* eventbox_label2;
		GtkEntry* _tmp6_;
		GtkFrame* _tmp7_;
		GtkHBox* _tmp8_;
		GtkButton* button_close;
		GdkColor white = {0};
		GtkCheckMenuItem* _tmp9_;
		GtkCheckMenuItem* _tmp10_;
		_data13_ = g_slice_new0 (Block13Data);
		_data13_->_ref_count_ = 1;
		_data13_->self = g_object_ref (self);
		builder = gtk_builder_new ();
		gtk_builder_add_from_file (builder, path, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (builder);
			block13_data_unref (_data13_);
			goto __catch32_g_error;
		}
		self->priv->widget = (_tmp0_ = _g_object_ref0 (GTK_WIDGET (gtk_builder_get_object (builder, "search_and_replace"))), _g_object_unref0 (self->priv->widget), _tmp0_);
		gtk_widget_unparent (self->priv->widget);
		self->priv->button_arrow = (_tmp1_ = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "button_arrow"))), _g_object_unref0 (self->priv->button_arrow), _tmp1_);
		self->priv->arrow = (_tmp2_ = _g_object_ref0 (GTK_ARROW (gtk_builder_get_object (builder, "arrow"))), _g_object_unref0 (self->priv->arrow), _tmp2_);
		self->priv->entry_find = (_tmp3_ = _g_object_ref0 (GTK_ENTRY (gtk_builder_get_object (builder, "entry_find"))), _g_object_unref0 (self->priv->entry_find), _tmp3_);
		self->priv->label_find_normal = (_tmp4_ = _g_object_ref0 (GTK_LABEL (gtk_builder_get_object (builder, "label_find_normal"))), _g_object_unref0 (self->priv->label_find_normal), _tmp4_);
		self->priv->label_find_error = (_tmp5_ = _g_object_ref0 (GTK_LABEL (gtk_builder_get_object (builder, "label_find_error"))), _g_object_unref0 (self->priv->label_find_error), _tmp5_);
		eventbox_label1 = _g_object_ref0 (GTK_EVENT_BOX (gtk_builder_get_object (builder, "eventbox_label1")));
		eventbox_label2 = _g_object_ref0 (GTK_EVENT_BOX (gtk_builder_get_object (builder, "eventbox_label2")));
		_data13_->button_clear_find = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "button_clear_find")));
		self->priv->entry_replace = (_tmp6_ = _g_object_ref0 (GTK_ENTRY (gtk_builder_get_object (builder, "entry_replace"))), _g_object_unref0 (self->priv->entry_replace), _tmp6_);
		self->priv->frame_replace = (_tmp7_ = _g_object_ref0 (GTK_FRAME (gtk_builder_get_object (builder, "frame_replace"))), _g_object_unref0 (self->priv->frame_replace), _tmp7_);
		_data13_->button_clear_replace = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "button_clear_replace")));
		_data13_->button_replace = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "button_replace")));
		_data13_->button_replace_all = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "button_replace_all")));
		self->priv->hbox_replace = (_tmp8_ = _g_object_ref0 (GTK_HBOX (gtk_builder_get_object (builder, "hbox_replace"))), _g_object_unref0 (self->priv->hbox_replace), _tmp8_);
		_data13_->button_previous = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "button_previous")));
		_data13_->button_next = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "button_next")));
		button_close = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "button_close")));
		gdk_color_parse ("white", &white);
		gtk_widget_modify_bg ((GtkWidget*) eventbox_label1, GTK_STATE_NORMAL, &white);
		gtk_widget_modify_bg ((GtkWidget*) eventbox_label2, GTK_STATE_NORMAL, &white);
		_data13_->menu = g_object_ref_sink ((GtkMenu*) gtk_menu_new ());
		self->priv->check_case_sensitive = (_tmp9_ = g_object_ref_sink ((GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Case sensitive"))), _g_object_unref0 (self->priv->check_case_sensitive), _tmp9_);
		self->priv->check_entire_word = (_tmp10_ = g_object_ref_sink ((GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Entire words only"))), _g_object_unref0 (self->priv->check_entire_word), _tmp10_);
		gtk_menu_shell_append ((GtkMenuShell*) _data13_->menu, (GtkWidget*) ((GtkMenuItem*) self->priv->check_case_sensitive));
		gtk_menu_shell_append ((GtkMenuShell*) _data13_->menu, (GtkWidget*) ((GtkMenuItem*) self->priv->check_entire_word));
		gtk_widget_show_all ((GtkWidget*) _data13_->menu);
		g_signal_connect_data (self->priv->entry_find, "icon-press", (GCallback) __lambda26__gtk_entry_icon_press, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
		g_signal_connect_object (self->priv->button_arrow, "clicked", (GCallback) __lambda27__gtk_button_clicked, self, 0);
		g_signal_connect_object (button_close, "clicked", (GCallback) _search_and_replace_hide_gtk_button_clicked, self, 0);
		g_signal_connect_object (_data13_->button_clear_find, "clicked", (GCallback) __lambda28__gtk_button_clicked, self, 0);
		g_signal_connect_object (_data13_->button_clear_replace, "clicked", (GCallback) __lambda29__gtk_button_clicked, self, 0);
		g_signal_connect_object (_data13_->button_previous, "clicked", (GCallback) __lambda30__gtk_button_clicked, self, 0);
		g_signal_connect_object (_data13_->button_next, "clicked", (GCallback) _search_and_replace_search_forward_gtk_button_clicked, self, 0);
		g_signal_connect_object (self->priv->entry_find, "activate", (GCallback) _search_and_replace_search_forward_gtk_entry_activate, self, 0);
		g_signal_connect_data ((GtkEditable*) self->priv->entry_find, "changed", (GCallback) __lambda31__gtk_editable_changed, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
		g_signal_connect_data ((GtkEditable*) self->priv->entry_replace, "changed", (GCallback) __lambda32__gtk_editable_changed, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
		g_signal_connect_object (self->priv->check_case_sensitive, "toggled", (GCallback) __lambda33__gtk_check_menu_item_toggled, self, 0);
		g_signal_connect_object (self->priv->check_entire_word, "toggled", (GCallback) __lambda34__gtk_check_menu_item_toggled, self, 0);
		g_signal_connect_object (_data13_->button_replace, "clicked", (GCallback) _search_and_replace_replace_gtk_button_clicked, self, 0);
		g_signal_connect_object (self->priv->entry_replace, "activate", (GCallback) _search_and_replace_replace_gtk_entry_activate, self, 0);
		g_signal_connect_object (_data13_->button_replace_all, "clicked", (GCallback) __lambda35__gtk_button_clicked, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->entry_find, "key-press-event", (GCallback) __lambda36__gtk_widget_key_press_event, self, 0);
		_g_object_unref0 (button_close);
		_g_object_unref0 (eventbox_label2);
		_g_object_unref0 (eventbox_label1);
		_g_object_unref0 (builder);
		block13_data_unref (_data13_);
	}
	goto __finally32;
	__catch32_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkLabel* label;
			GtkWidget* _tmp11_;
			fprintf (stderr, "Error search and replace: %s\n", e->message);
			label = g_object_ref_sink ((GtkLabel*) gtk_label_new (e->message));
			gtk_label_set_line_wrap (label, TRUE);
			self->priv->widget = (_tmp11_ = _g_object_ref0 ((GtkWidget*) label), _g_object_unref0 (self->priv->widget), _tmp11_);
			_g_object_unref0 (label);
			_g_error_free0 (e);
		}
	}
	__finally32:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	gtk_widget_hide (self->priv->widget);
	_g_free0 (path);
	return self;
}


SearchAndReplace* search_and_replace_new (MainWindow* main_window) {
	return search_and_replace_construct (TYPE_SEARCH_AND_REPLACE, main_window);
}


GtkWidget* search_and_replace_get_widget (SearchAndReplace* self) {
	GtkWidget* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _g_object_ref0 (self->priv->widget);
	return result;
}


void search_and_replace_show_search (SearchAndReplace* self) {
	g_return_if_fail (self != NULL);
	g_object_set (self->priv->arrow, "arrow-type", GTK_ARROW_DOWN, NULL);
	search_and_replace_show (self);
	gtk_widget_hide ((GtkWidget*) self->priv->frame_replace);
	gtk_widget_hide ((GtkWidget*) self->priv->hbox_replace);
}


void search_and_replace_show_search_and_replace (SearchAndReplace* self) {
	g_return_if_fail (self != NULL);
	g_object_set (self->priv->arrow, "arrow-type", GTK_ARROW_UP, NULL);
	search_and_replace_show (self);
}


static void _search_and_replace_active_document_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	search_and_replace_active_document_changed (self);
}


static void search_and_replace_show (SearchAndReplace* self) {
	Document* doc;
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_tab (self->priv->main_window) != NULL);
	gtk_widget_show_all (self->priv->widget);
	gtk_widget_hide ((GtkWidget*) self->priv->label_find_normal);
	gtk_widget_hide ((GtkWidget*) self->priv->label_find_error);
	gtk_widget_grab_focus ((GtkWidget*) self->priv->entry_find);
	search_and_replace_set_replace_sensitivity (self);
	doc = _g_object_ref0 (main_window_get_active_document (self->priv->main_window));
	if (document_get_selection_type (doc) == SELECTION_TYPE_ONE_LINE) {
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		char* _tmp0_;
		gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) doc, &start, &end);
		gtk_entry_set_text (self->priv->entry_find, _tmp0_ = gtk_text_buffer_get_text ((GtkTextBuffer*) doc, &start, &end, FALSE));
		_g_free0 (_tmp0_);
	}
	g_signal_connect_object ((GObject*) self->priv->main_window, "notify::active-document", (GCallback) _search_and_replace_active_document_changed_g_object_notify, self, 0);
	_g_object_unref0 (doc);
}


void search_and_replace_hide (SearchAndReplace* self) {
	guint _tmp0_;
	GQuark _tmp1_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide (self->priv->widget);
	if (self->priv->working_document != NULL) {
		search_and_replace_clear_search (self);
	}
	g_signal_parse_name ("notify::active-document", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self->priv->main_window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _search_and_replace_active_document_changed_g_object_notify, self);
}


static void search_and_replace_set_label_text (SearchAndReplace* self, const char* text, gboolean _error_) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (_error_) {
		gtk_label_set_text (self->priv->label_find_error, text);
		gtk_widget_show ((GtkWidget*) self->priv->label_find_error);
		gtk_widget_hide ((GtkWidget*) self->priv->label_find_normal);
	} else {
		gtk_label_set_text (self->priv->label_find_normal, text);
		gtk_widget_show ((GtkWidget*) self->priv->label_find_normal);
		gtk_widget_hide ((GtkWidget*) self->priv->label_find_error);
	}
}


static void _search_and_replace_on_search_info_updated_document_search_info_updated (Document* _sender, gboolean selected, guint nb_matches, guint num_match, gpointer self) {
	search_and_replace_on_search_info_updated (self, selected, nb_matches, num_match);
}


static void search_and_replace_set_search_text (SearchAndReplace* self, gboolean select) {
	guint nb_matches = 0U;
	guint num_match = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window_get_active_document (self->priv->main_window) != NULL);
	if (gtk_entry_get_text_length (self->priv->entry_find) == 0) {
		return;
	}
	if (main_window_get_active_document (self->priv->main_window) != self->priv->working_document) {
		Document* _tmp0_;
		if (self->priv->working_document != NULL) {
			search_and_replace_clear_search (self);
		}
		self->priv->working_document = (_tmp0_ = _g_object_ref0 (main_window_get_active_document (self->priv->main_window)), _g_object_unref0 (self->priv->working_document), _tmp0_);
		g_signal_connect_object (self->priv->working_document, "search-info-updated", (GCallback) _search_and_replace_on_search_info_updated_document_search_info_updated, self, 0);
	}
	document_set_search_text (self->priv->working_document, gtk_entry_get_text (self->priv->entry_find), search_and_replace_get_case_sensitive (self), search_and_replace_get_entire_word (self), &nb_matches, &num_match, select);
	search_and_replace_on_search_info_updated (self, nb_matches != 0, nb_matches, num_match);
}


static void search_and_replace_search_forward (SearchAndReplace* self) {
	g_return_if_fail (self != NULL);
	search_and_replace_set_search_text (self, FALSE);
	g_return_if_fail (self->priv->working_document != NULL);
	document_search_forward (self->priv->working_document);
}


static void search_and_replace_on_search_info_updated (SearchAndReplace* self, gboolean selected, guint nb_matches, guint num_match) {
	g_return_if_fail (self != NULL);
	if (selected) {
		char* _tmp0_;
		search_and_replace_set_label_text (self, _tmp0_ = g_strdup_printf (_ ("%u of %u"), num_match, nb_matches), FALSE);
		_g_free0 (_tmp0_);
	} else {
		if (nb_matches == 0) {
			search_and_replace_set_label_text (self, _ ("Not found"), TRUE);
		} else {
			if (nb_matches == 1) {
				search_and_replace_set_label_text (self, _ ("One match"), FALSE);
			} else {
				char* _tmp1_;
				search_and_replace_set_label_text (self, _tmp1_ = g_strdup_printf (_ ("%u matches"), nb_matches), FALSE);
				_g_free0 (_tmp1_);
			}
		}
	}
}


static void search_and_replace_clear_search (SearchAndReplace* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->working_document != NULL) {
		guint _tmp0_;
		Document* _tmp1_;
		document_clear_search (self->priv->working_document, TRUE);
		g_signal_parse_name ("search-info-updated", TYPE_DOCUMENT, &_tmp0_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self->priv->working_document, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _search_and_replace_on_search_info_updated_document_search_info_updated, self);
		self->priv->working_document = (_tmp1_ = NULL, _g_object_unref0 (self->priv->working_document), _tmp1_);
	}
}


static void search_and_replace_active_document_changed (SearchAndReplace* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self->priv->label_find_normal);
	gtk_widget_hide ((GtkWidget*) self->priv->label_find_error);
	search_and_replace_set_replace_sensitivity (self);
}


static void search_and_replace_set_replace_sensitivity (SearchAndReplace* self) {
	gboolean readonly;
	g_return_if_fail (self != NULL);
	readonly = document_get_readonly (main_window_get_active_document (self->priv->main_window));
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->frame_replace, !readonly);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->hbox_replace, !readonly);
}


static void search_and_replace_replace (SearchAndReplace* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (gtk_entry_get_text_length (self->priv->entry_find) != 0);
	search_and_replace_set_search_text (self, TRUE);
	document_replace (self->priv->working_document, gtk_entry_get_text (self->priv->entry_replace));
}


static gboolean search_and_replace_get_search_and_replace_mode (SearchAndReplace* self) {
	gboolean result;
	GtkArrowType _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (g_object_get (self->priv->arrow, "arrow-type", &_tmp0_, NULL), _tmp0_) == GTK_ARROW_UP;
	return result;
}


static gboolean search_and_replace_get_case_sensitive (SearchAndReplace* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = gtk_check_menu_item_get_active (self->priv->check_case_sensitive);
	return result;
}


static gboolean search_and_replace_get_entire_word (SearchAndReplace* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = gtk_check_menu_item_get_active (self->priv->check_entire_word);
	return result;
}


static void search_and_replace_class_init (SearchAndReplaceClass * klass) {
	search_and_replace_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SearchAndReplacePrivate));
	G_OBJECT_CLASS (klass)->get_property = search_and_replace_get_property;
	G_OBJECT_CLASS (klass)->finalize = search_and_replace_finalize;
}


static void search_and_replace_instance_init (SearchAndReplace * self) {
	self->priv = SEARCH_AND_REPLACE_GET_PRIVATE (self);
	self->priv->min_nb_chars_for_incremental_search = 3;
}


static void search_and_replace_finalize (GObject* obj) {
	SearchAndReplace * self;
	self = SEARCH_AND_REPLACE (obj);
	_g_object_unref0 (self->priv->working_document);
	_g_object_unref0 (self->priv->widget);
	_g_object_unref0 (self->priv->button_arrow);
	_g_object_unref0 (self->priv->arrow);
	_g_object_unref0 (self->priv->entry_find);
	_g_object_unref0 (self->priv->label_find_normal);
	_g_object_unref0 (self->priv->label_find_error);
	_g_object_unref0 (self->priv->entry_replace);
	_g_object_unref0 (self->priv->frame_replace);
	_g_object_unref0 (self->priv->hbox_replace);
	_g_object_unref0 (self->priv->check_case_sensitive);
	_g_object_unref0 (self->priv->check_entire_word);
	G_OBJECT_CLASS (search_and_replace_parent_class)->finalize (obj);
}


GType search_and_replace_get_type (void) {
	static volatile gsize search_and_replace_type_id__volatile = 0;
	if (g_once_init_enter (&search_and_replace_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchAndReplaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_and_replace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchAndReplace), 0, (GInstanceInitFunc) search_and_replace_instance_init, NULL };
		GType search_and_replace_type_id;
		search_and_replace_type_id = g_type_register_static (G_TYPE_OBJECT, "SearchAndReplace", &g_define_type_info, 0);
		g_once_init_leave (&search_and_replace_type_id__volatile, search_and_replace_type_id);
	}
	return search_and_replace_type_id__volatile;
}


static void search_and_replace_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SearchAndReplace * self;
	self = SEARCH_AND_REPLACE (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




