/*
 * $Id: cmd_cpu.c,v 1.1 2004/12/21 23:26:18 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2003 - 2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include <lcrash.h>
#include <kl_libhwconfig.h>

/* External function prototypes
 */
void cpu_banner(FILE *, int);
int print_cpu_info(cpuinfo_t *, FILE *, int);

/*
 * cpu_cmd() -- Run the 'cpu' command.
 */
int
cpu_cmd(command_t *cmd)
{
        cpuinfo_t *cpu;

        if (kl_init_hwconfig()) {
		return(1);
	}
        if (cpu_count) {
                cpu = cpu_list;
                cpu_banner(cmd->ofp, BANNER|SMAJOR);
                do {
                        if (cpu->id >= 0) {
                                print_cpu_info(cpu, cmd->ofp, cmd->flags);
                        }
                        cpu = (cpuinfo_t *)cpu->c_next;
                } while (cpu != cpu_list);
        }
	return(0);
}

#define _CPU_USAGE "[-f] [-w outfile]"

/*
 * cpu_usage() -- Print the usage string for the 'cpu' command.
 */
void
cpu_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _CPU_USAGE);
}

/*
 * cpu_help() -- Print the help information for the 'cpu' command.
 */
void
cpu_help(command_t *cmd)
{
	CMD_HELP(cmd, _CPU_USAGE,
        "Display relevant information for each entry in cpu_list. ");
}

/*
 * cpu_parse() -- Parse the command line arguments for 'cpu'.
 */
int
cpu_parse(command_t *cmd)
{
	if (set_cmd_flags(cmd, (C_FULL|C_WRITE), 0)) {
		return(1);
	}
	return(0);
}

/*
 * cpu_complete() -- Complete arguments of 'cpu' command.
 */
char *
cpu_complete(command_t *cmd)
{
	char *ret;

	/* complete standard options (for example, -w option) arguments
	 */
	if ((ret = complete_standard_options(cmd)) != NOT_COMPLETED) {
		return(ret);
	}
	fprintf(cmd->ofp, "\n");
	cpu_usage(cmd);
	return(DRAW_NEW_ENTIRE_LINE);
}
