/*
 * $Id: cmd_namelist.c,v 1.1 2004/12/21 23:26:18 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <lcrash.h>

#define C_AFLAG (1 << C_LFLG_SHFT)

static char * filename;

void namelist_usage(command_t *);

/*
 * namelist_cmd()
 */
int
namelist_cmd(command_t *cmd)
{
	int i;

	/* let "addtypes" be an alias for "namelist -a" */
        if (!strcmp(cmd->command, "addtypes")) {
		cmd->flags |= C_AFLAG;
		if(cmd->nargs!=1){
			fprintf(KL_ERRORFP, "Invalid commandline.\n");
			namelist_usage(cmd);
			return(1);
		} else {
			filename = cmd->args[0];
		}
	}
	if (cmd->flags & C_AFLAG){
		fprintf(cmd->ofp, "Adding namelist.\n"
			"\n\t%s ", filename);
		fflush(cmd->ofp);
		if (kl_open_namelist(filename, ST_ALL)) {
			fprintf(KL_ERRORFP, "ERROR: Could not open "
				"namelist %s\n", filename);
			return(1);
		}
		fprintf(cmd->ofp, "\nDone.\n");
	} else if (cmd->nargs == 0) {
		if (numnmlist) {
			fprintf(cmd->ofp, "INDEX  NAMELIST\n"
				"==========================="
				"======================\n");
			for (i = 0; i < numnmlist; i++) {
				fprintf(cmd->ofp, "%5d  %s\n", 
					i, nmlist[i].namelist); 
			}
			fprintf(cmd->ofp, "================="
				"================================\n\n"
				"The current namelist is %s (%d)\n", 
				nmlist[curnmlist].namelist, curnmlist);
		} else {
			fprintf(cmd->ofp, "Currently, there aren't any "
				"namelists.\n");
		}
	} else if (cmd->nargs == 1) {
		kl_set_curnmlist(atoi(cmd->args[0]));
	} else {
		fprintf(KL_ERRORFP, "Invalid commandline.\n");
		namelist_usage(cmd);
		return(1);
	}

	return(0);
}

#define _NAMELIST_USAGE \
"\n        [-a namelist]"\
"\n        [index_number]"

#define _NAMELIST_HELP \
"Add/list opened namelists, i.e. files with type information.\n"\
"\nOPTIONS:"\
"\n -a namelist"\
"\n       Add type information of new namelist."\
"\n index_number"\
"\n       Current namelist is set to given index_number."\
"\n"\
"\nIf no arguments are given, display all currently opened namelists."\
"\n\"addtypes\" is an alias for \"namelist -a\"."
/*
 * namelist_usage() -- Print the usage string for the 'namelist' command.
 */
void
namelist_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _NAMELIST_USAGE);
}

/*
 * namelist_help() -- Print the help information for the 'namelist' command.
 */
void
namelist_help(command_t *cmd)
{
	CMD_HELP(cmd, _NAMELIST_USAGE, _NAMELIST_HELP);
}

/*
 * namelist_parse() -- Parse the command line arguments for 'namelist'.
 */
int
namelist_parse(command_t *cmd)
{
	option_t *op;

	filename = NULL;

	if (set_cmd_flags(cmd, (C_WRITE), "a:")) {
		return(1);
	}

	op = cmd->options;
	while (op) {
		switch(op->op_char) {
			case 'a':
				cmd->flags |= C_AFLAG;
				filename = op->op_arg;
				break;
		}
		op = op->op_next;
	}
	return(0);
}

/*
 * namelist_complete() -- Complete arguments of 'namelist' command.
 */
char *
namelist_complete(command_t *cmd)
{
	if ((cmd->nargs == 1) && (!strcmp(cmd->command,"addtypes"))) {
		return(complete_file_name(cmd->args[cmd->nargs -1], 100));
	} else if ((cmd->nargs == 2) && strcmp(cmd->command,"addtypes")) {
		return(complete_file_name(cmd->args[cmd->nargs -1], 100));
	} else {
		fprintf(cmd->ofp, "\n");
		namelist_usage(cmd);
	}
	return(DRAW_NEW_ENTIRE_LINE);
}
