/*
 * $Id: cmd_version.c,v 1.1 2004/12/21 23:26:19 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <lcrash.h>
#include <lc_config.h>

#define C_GFLAG (1 << C_LFLG_SHFT)

int
version_cmd(command_t *cmd)
{
	if (cmd->flags & C_GFLAG) {
		fprintf(cmd->ofp, "%d\n", GUI_VERSION);
	} else {
		print_version_info(cmd->ofp);
	}

	return 0;
}

#define _VERSION_USAGE \
"\n         [-g] [-w outfile]"

#define _VERSION_HELP \
"\nPrint version information.\n"\
"\nOPTIONS:"\
"\n -g"\
"\n       Print version of output format used by lcrash."

void
version_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _VERSION_USAGE);
}

void
version_help(command_t *cmd)
{
	CMD_HELP(cmd, _VERSION_USAGE, _VERSION_HELP);
}

int
version_parse(command_t *cmd)
{
	option_t *op;

	if (set_cmd_flags(cmd, C_WRITE, "g")) {
		return(1);
	}

	op = cmd->options;
	while (op) {
		switch (op->op_char) {
			case 'g':
				cmd->flags |= C_GFLAG;
				break;
		}
		op = op->op_next;
	}

	return(0);
}

/*
 * version_complete() -- Complete arguments of 'version' command.
 */
char *
version_complete(command_t *cmd)
{
	fprintf(cmd->ofp, "\n");
	version_usage(cmd);
	return(DRAW_NEW_ENTIRE_LINE);
}
