/*
 * cmds_arm.c
 * 
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Ported from cmds_i386.c
 * by Fleming Feng (fleming.feng@intel.com).
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright (C) 2003, Intel Corp. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <lcrash.h>

extern int mktrace_cmd(command_t *), mktrace_parse(command_t *);
extern void mktrace_help(command_t *), mktrace_usage(command_t *);

extern int rd_cmd(command_t *), rd_parse(command_t *);
extern void rd_help(command_t *), rd_usage(command_t *);

extern int defcpu_cmd(command_t *), defcpu_parse(command_t *);
extern void defcpu_help(command_t *), defcpu_usage(command_t *);

_command_t cmdset_arm[] = {
	{"mktrace", 0, mktrace_cmd, mktrace_parse, mktrace_help, mktrace_usage, NULL},
	{"mt", "mktrace" },
	{"rd", 0, rd_cmd, rd_parse, rd_help, rd_usage, NULL},
	{"defcpu", 0, defcpu_cmd, defcpu_parse, defcpu_help, defcpu_usage, NULL},
	{(char *)0 }
};
