/*
 * lc_dis_arm.h
 * 
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Ported from lc_dis_i386.h
 * by Fleming Feng (fleming.feng@intel.com).
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright (C) 2003, Intel Corp. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

/* Buffer to hold a cache of instruction bytes...we have to make sure
 * that there are AT LEAST 15 unread bytes in the buffer at all times,
 * as this is the maximum number of bytest that can belong to a single
 * instruction.
 *
 * Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */

#ifndef __LC_DIS_ARM_H
#define __LC_DIS_ARM_H

#define INSTR_STRLEN_MAX	256

typedef struct instr_rec_arm_s {
	struct instr_rec_arm_s	*next;
	struct instr_rec_arm_s	*prev;
	kaddr_t			 addr;	    /* start address of instruction */ 
	int		 	 size;
	unsigned long    	 opcode;
	char			 instr_string[INSTR_STRLEN_MAX];
} instr_rec_arm_t;

/* Function prototypes
 */
int get_instr_info_arm(	
	kaddr_t 	/* pc */, 
	instr_rec_arm_t * 	/* pointer to instr_rec_arm_s struct */);

instr_rec_arm_t *get_instr_stream_arm(
	kaddr_t 	/* program counter */, 
	int 		/* before count */, 
	int 		/* after count */);

void free_instr_stream_arm(
	instr_rec_arm_t *);

int dis_init_arm(FILE*, int);

#endif /*__LC_DIS_ARM_H*/
