/* Common target dependent code for GDB on ARM systems.
   Copyright 2002 Free Software Foundation, Inc.

   This file is part of GDB.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/*
   This file is combined from two files originally part of GDB.
   It is pulled into lkcdutils by Fleming Feng (fleming.feng@intel.com)
   in Feb, 2003 with minor modifications to fit into lkcdutils. */


/* Register numbers of various important registers.  Note that some of
   these values are "real" register numbers, and correspond to the
   general registers of the machine, and some are "phony" register
   numbers which are too large to be actual register numbers as far as
   the user is concerned but do serve to get the desired values when
   passed to read_register.  */

#if !defined(_TRACE_ARM_H)
#define _TRACE_ARM_H 1

#define ARM_A1_REGNUM 0		/* first integer-like argument */
#define ARM_A4_REGNUM 3		/* last integer-like argument */
#define ARM_SP_REGNUM 13	/* Contains address of top of stack */
#define ARM_LR_REGNUM 14	/* address to return to from a function call */
#define ARM_PC_REGNUM 15	/* Contains program counter */
#define ARM_F0_REGNUM 16	/* first floating point register */
#define ARM_F3_REGNUM 19	/* last floating point argument register */
#define ARM_F7_REGNUM 23	/* last floating point register */
#define ARM_FPS_REGNUM 24	/* floating point status register */
#define ARM_PS_REGNUM 25	/* Contains processor status */

#define ARM_FP_REGNUM 11	/* Frame register in ARM code, if used.  */
#define THUMB_FP_REGNUM 7	/* Frame register in Thumb code, if used.  */

#define ARM_NUM_ARG_REGS 	4
#define ARM_LAST_ARG_REGNUM 	ARM_A4_REGNUM
#define ARM_NUM_FP_ARG_REGS 	4
#define ARM_LAST_FP_ARG_REGNUM	ARM_F3_REGNUM

/* Size of integer registers.  */
#define INT_REGISTER_RAW_SIZE		4
#define INT_REGISTER_VIRTUAL_SIZE	4

/* Say how long FP registers are.  Used for documentation purposes and
   code readability in this header.  IEEE extended doubles are 80
   bits.  DWORD aligned they use 96 bits.  */
#define FP_REGISTER_RAW_SIZE	12

/* GCC doesn't support long doubles (extended IEEE values).  The FP
   register virtual size is therefore 64 bits.  Used for documentation
   purposes and code readability in this header.  */
#define FP_REGISTER_VIRTUAL_SIZE	8

/* Status registers are the same size as general purpose registers.
   Used for documentation purposes and code readability in this
   header.  */
#define STATUS_REGISTER_SIZE	4

/* Number of machine registers.  The only define actually required 
   is NUM_REGS.  The other definitions are used for documentation
   purposes and code readability.  */
/* For 26 bit ARM code, a fake copy of the PC is placed in register 25 (PS)
   (and called PS for processor status) so the status bits can be cleared
   from the PC (register 15).  For 32 bit ARM code, a copy of CPSR is placed
   in PS.  */
#define NUM_FREGS	8	/* Number of floating point registers.  */
#define NUM_SREGS	2	/* Number of status registers.  */
#define NUM_GREGS	16	/* Number of general purpose registers.  */


/* Instruction condition field values.  */
#define INST_EQ		0x0
#define INST_NE		0x1
#define INST_CS		0x2
#define INST_CC		0x3
#define INST_MI		0x4
#define INST_PL		0x5
#define INST_VS		0x6
#define INST_VC		0x7
#define INST_HI		0x8
#define INST_LS		0x9
#define INST_GE		0xa
#define INST_LT		0xb
#define INST_GT		0xc
#define INST_LE		0xd
#define INST_AL		0xe
#define INST_NV		0xf

#define FLAG_N		0x80000000
#define FLAG_Z		0x40000000
#define FLAG_C		0x20000000
#define FLAG_V		0x10000000

/* Type of floating-point code in use by inferior.  There are really 3 models
   that are traditionally supported (plus the endianness issue), but gcc can
   only generate 2 of those.  The third is APCS_FLOAT, where arguments to
   functions are passed in floating-point registers.  

   In addition to the traditional models, VFP adds two more.  */

/* Target-dependent structure in gdbarch.  */
#ifndef LOWEST_PC
#define LOWEST_PC (gdbarch_tdep (current_gdbarch)->lowest_pc)
#endif

typedef kaddr_t CORE_ADDR;

#define MAX_ARM_REGS 	(NUM_GREGS+NUM_SREGS+3*NUM_FREGS)

/* Describe the saved registers of a frame.  */

#if defined (EXTRA_FRAME_INFO) || defined (FRAME_FIND_SAVED_REGS)
/* XXXX - deprecated */
struct frame_saved_regs
  {
    /* For each register R (except the SP), regs[R] is the address at
       which it was saved on entry to the frame, or zero if it was not
       saved on entry to this frame.  This includes special registers
       such as pc and fp saved in special ways in the stack frame.

       regs[SP_REGNUM] is different.  It holds the actual SP, not the
       address at which it was saved.  */

    CORE_ADDR regs[NUM_REGS];
  };
#endif

/* We keep a cache of stack frames, each of which is a "struct
   frame_info".  The innermost one gets allocated (in
   wait_for_inferior) each time the inferior stops; current_frame
   points to it.  Additional frames get allocated (in
   get_prev_frame) as needed, and are chained through the next
   and prev fields.  Any time that the frame cache becomes invalid
   (most notably when we execute something, but also if we change how
   we interpret the frames (e.g. "set heuristic-fence-post" in
   mips-tdep.c, or anything which reads new symbols)), we should call
   reinit_frame_cache.  */

struct frame_info
  {
    /* Nominal address of the frame described.  See comments at FRAME_FP
       about what this means outside the *FRAME* macros; in the *FRAME*
       macros, it can mean whatever makes most sense for this machine.  */
    CORE_ADDR frame;

    /* Address at which execution is occurring in this frame.
       For the innermost frame, it's the current pc.
       For other frames, it is a pc saved in the next frame.  */
    CORE_ADDR pc;

    /* For each register, address of where it was saved on entry to
       the frame, or zero if it was not saved on entry to this frame.
       This includes special registers such as pc and fp saved in
       special ways in the stack frame.  The SP_REGNUM is even more
       special, the address here is the sp for the previous frame, not
       the address where the sp was saved.  */
    /* Allocated by frame_saved_regs_zalloc () which is called /
       initialized by FRAME_INIT_SAVED_REGS(). */
    CORE_ADDR saved_regs[MAX_ARM_REGS];	/*NUM_REGS + NUM_PSEUDO_REGS*/

    /* Anything extra for this structure that may have been defined
       in the machine dependent files. */
    /* Allocated by frame_obstack_alloc () which is called /
       initialized by INIT_EXTRA_FRAME_INFO */
	unsigned long framereg;
	unsigned long framesize;
	long frameoffset;

  };
int trace_init_arm(void);

#define FRAME_FP(fi) ((fi)->frame)

/* Function prototypes
 */
void print_pc_arm(
	kaddr_t 	/* PC */, 
	FILE *		/* output file pointer */);

int setup_trace_rec_arm(kaddr_t, kaddr_t, int, trace_t *);
int find_trace_arm(kaddr_t, kaddr_t, kaddr_t, kaddr_t, trace_t *, int);
int print_traces_arm(kaddr_t, int, int, FILE *);
void print_trace_arm(trace_t *, int, FILE *);
int task_trace_arm(kaddr_t, int, FILE *);
int do_list_arm(kaddr_t, int, FILE *);
int add_frame_arm(trace_t *, kaddr_t, kaddr_t);
void finish_trace_arm(trace_t *);
int dumptask_trace_arm(kaddr_t, int, FILE *);

#define STACK_SEGMENTS_ARM	1
#define STACK_SIZE_ARM		0x2000

#endif /* !defined (_TRACE_ARM_H)  */

