/*
 * $Id: kl_cpu.h,v 1.1 2004/12/21 23:26:20 tjm Exp $
 *
 * This file is part of libhwconfig.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2003-2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef __KL_CPU_H
#define __KL_CPU_H

#include <kl_list.h>

typedef struct cpuinfo_s {
	list_type_t	 list;
	int		 id;
	int		 node;
	kaddr_t		 addr; /* kernel address of cpuinfo struct */
	void		*ptr;  /* buffer containing cpuinfo struct */
} cpuinfo_t;
#define c_next list.next
#define c_prev list.prev

extern int cpu_count;
extern cpuinfo_t *cpu_list;

#endif /* __KL_CPU_H */
