/*
 *
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, NEC, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright 2000 Junichi Nomura, NEC Solutions <j-nomura@ce.jp.nec.com>
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 *
 * Added support for X86_64 architecture Mar 2004
 *      Prashanth Tamraparni (prasht@in.ibm.com)
 *      Sachin Sant (sachinp@in.ibm.com)
 */

/* This header file holds the architecture specific crash dump header */
#ifndef __KL_DUMP_X86_64_H
#define __KL_DUMP_X86_64_H

/* macros
 */
#ifndef KL_NR_CPUS
#define KL_NR_CPUS 128     /* max number CPUs */
#endif

#define KL_DUMP_MAGIC_NUMBER_X86_64     0xdeaddeadULL  /* magic number         */
#define KL_DUMP_VERSION_NUMBER_X86_64   0x2        /* version number          */
#define KL_IS_PAE_X86_64		0x0020
/* structures
 */

/* asm independent version of struct pt_regs for x86_64 */
struct kl_pt_regs_x86_64 {
	unsigned long r15;
	unsigned long r14;
	unsigned long r13;
	unsigned long r12;
	unsigned long rbp;
	unsigned long rbx;
/* arguments: non interrupts/non tracing syscalls only save upto here*/
 	unsigned long r11;
	unsigned long r10;	
	unsigned long r9;
	unsigned long r8;
	unsigned long rax;
	unsigned long rcx;
	unsigned long rdx;
	unsigned long rsi;
	unsigned long rdi;
	unsigned long orig_rax;
/* end of arguments */ 	
/* cpu exception frame or undefined */
	unsigned long rip;
	unsigned long xcs;
	unsigned long eflags; 
	unsigned long rsp; 
	unsigned long xss;
/* top of stack page */ 
}__attribute__((packed));

/*  Header for architecture-specific stuff.
 *  It follows right after the dump header.
 */
typedef struct kl_dump_header_x86_64_s {
        uint64_t               magic_number; /* magic number for architecture */
        uint32_t               version;     /* version number of this dump */
        uint32_t               header_size; /* size of this header */
	struct kl_pt_regs_x86_64 regs; /* the dump registers */
	/* smp specific */
	uint32_t               smp_num_cpus;
	int                    dumping_cpu;	
	struct kl_pt_regs_x86_64 smp_regs[KL_NR_CPUS];
	uint64_t               smp_current_task[KL_NR_CPUS];
	uint64_t               stack[KL_NR_CPUS];
	uint64_t               stack_ptr[KL_NR_CPUS];
} __attribute__((packed)) kl_dump_header_x86_64_t;

/*
 * The following struct is used just to calculate the size needed
 * to store per CPU info. (Make sure it is sync with the above struct)
 */
struct kl_dump_CPU_info_x86_64 {
       struct kl_pt_regs_x86_64        smp_regs;
       uint64_t                        smp_current_task;
       uint64_t                        stack;
       uint64_t                        stack_ptr;
} __attribute__((packed));

/* function declarations
 */
kaddr_t kl_dumprip_x86_64(kaddr_t);
kaddr_t kl_dumprsp_x86_64(kaddr_t);
int kl_get_dump_header_x86_64(kl_dump_header_x86_64_t*);
int kl_smp_dumptask_x86_64(kaddr_t);
int kl_set_dumparch_x86_64(void);
kaddr_t kl_kernelstack_x86_64(kaddr_t);
kaddr_t kl_mmap_virtop_x86_64(kaddr_t, void*);
kaddr_t kl_fix_vaddr_x86_64(kaddr_t, size_t);
int kl_init_virtop_x86_64(void);
int kl_virtop_x86_64(kaddr_t, void *, kaddr_t *);
#endif /* __KL_DUMP_X86_64_H */
