/*
    ldapdiff
    Copyright (C) 2000-2002 Thomas.Reith@rhoen.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#define VERSION    "GNU ldapdiff Version 0.9.2 by Thomas.Reith@rhoen.de"
#define COPYING    "Copyright (C) 2000-2003 Free Software Foundation, Inc."
#define LDAPCONF   "ldapdiff.conf"
#define SYSLOGNAME "ldapdiff"
#define SECTGLOB   "global"
#define DNNAME     "dn"

#define MAXCONFVAR     1024
#define MAXATTRLEN     4096
#define MAXLOGLEN      128
#define MAXLDIFLINELEN 64

#define LDALLOC(x,y)  ldifalloc(x,y,__FILE__,__LINE__);
#define LDDUP(x)      ldifdup(x,__FILE__,__LINE__);
#define LDBINDUP(x,y) ldifbindup(x,y,__FILE__,__LINE__);

typedef enum {
        SECTIONGLOBAL,
        SECTIONPROFILE,
        SECTIONNONE
} tesectiontype;

typedef enum {
        CONFLDAPHOST,
        CONFLDAPPORT,
        CONFROOTDN,
        CONFROOTPW,
        CONFMODFILE,
        CONFADDFILE,
        CONFONLINEUPDATE,
        CONFOFFLINEUPDATE,
        CONFONLINEERRFATAL,
        CONFPLUGIN,
        CONFPLUGINFILE,
        CONFPLUGINFUNCTION,
        CONFICONV,
        CONFLDIFCHARSET,
        CONFLDAPCHARSET,
        CONFSCHEMACHECK,
        CONFSCHEMABASE,
        CONFSCHEMAFILTER,
        CONFSCHEMAATTRIBUTE,
        CONFSCHEMAHACK,
        CONFBASEDN,
        CONFFILTER,
        CONFGROUP,
        CONFIGNORE,
        CONFMULTI,
        CONFNOEQUALITY,
        CONFMAPALIAS,
        CONFDELETEENTRY,
        CONFDELETEATTRIBUTE,
        CONFNONE     
} tevarid;

typedef enum {
        LOG0, /* print non fatal errors      */
        LOG1, /* print statistics            */
        LOG2  /* print debug informations    */
} teloglevel;

typedef enum {
        ATTRCHECK,
        ATTRIGNORE
} teignore;
        
typedef enum {
        MODENTRYADD,
        MODENTRYREPLACE,
        MODENTRYDELETE
} temodentry;

typedef enum {
	MODADD,
	MODMODIFY,
	MODDELETE
} temod;

typedef enum {
        ATTRASC,
        ATTRBIN,
        ATTRUNKNOWN
} teattrtype;

/* structure for config variables   */
struct s_conf {
 char               *section; 
 tesectiontype       sectiontype; 
 tevarid             varid;
 char               *var;
 char               *val;
};

/* pointered list of ldif attributes */
struct s_ldifentry {
 char               *var;       /* attribute name             */
 char               *val;       /* attribute value            */
 size_t              val_len;   /* attribute value len        */
 teattrtype          val_type;  /* attribute type             */
 struct s_ldifentry *next;      /* pointer to next attribute  */
};

/* pointered list of ldif entries */
struct s_ldif {
 char               *dnvar;     /* dn name (normally "dn")    */
 char               *dnval;     /* dn value                   */
 struct s_ldifentry *attrlist;  /* pointer to attributes list */
 struct s_ldif      *next;      /* pointer to next entry      */
};

/* pointered list of modify attribuites */
struct s_modentry {
 char              *var;        /* attribute name             */
 char              *val;        /* attribute value            */
 size_t             val_len;    /* attribute value len        */
 teattrtype         val_type;   /* attribute type             */
 temodentry         modtype;
 struct s_modentry *next;
};

/* 
pointered list of modify attributes grouped by var 
necessary for openldap 2.0.22 and above, see Kurt's statement in ITS#1589 
*/
struct s_addmodentry {
 struct s_modentry    *attrlist;
 int                   count;
 struct s_addmodentry *next;
};

/* pointered list of modify entries */
struct s_mod {
 char              *dnvar;
 char              *dnval;
 temod              modtype;
 struct s_modentry *attrlist;
 struct s_mod      *next;
};

/* pointered list of schema attributes */
struct s_schema {
 char                *var;
 char               **at_names;
 char                *at_equality_oid;
 int                  at_single_value;
 struct s_schema     *next;
};

/* file ldaread.c   */
extern void           ldifread(struct s_ldif**,char*);

/* file ldapiter.c  */
extern void           ldifiterldif(LDAP*,struct s_ldif*,struct s_mod**,struct s_schema*);
extern void           ldifiterldap(LDAP*,struct s_ldif*,struct s_mod**,struct s_schema*);

/* file ldapcmp.c   */
extern void           ldifcmp(struct s_ldif*,struct s_ldif*,struct s_mod**,struct s_schema*);
extern void           ldifadddn(struct s_ldif*,struct s_mod**);
extern void           ldifdeletedn(char*,char*,struct s_mod**);

/* file lapwrite.c  */
extern void           ldifwrite(struct s_mod*,struct s_schema*);

/* file ldapmisc.c  */
extern struct s_ldif* ldifadd(struct s_ldif**,char*,char*);
extern void           ldifaddentry(struct s_ldif*,char*,char*,size_t,teattrtype);
extern void           ldiffree(struct s_ldif**);
extern void          *ldifalloc(size_t,size_t,char*,int);
extern char          *ldifdup(char*,char*,int);
extern char          *ldifbindup(char*,size_t,char*,int);
extern int            ldifgetfilter(struct s_ldifentry*,char*);
extern int            ldifconfnormalize(char*,char*,char*);
extern void           ldiftrim(char*);
extern int            ldifgetfacility(char*);
extern teignore       ldifcheckignore(char*);
extern int            ldifcheckmulti(char*);
extern int            ldifchecknoequality(char*);
extern char          *ldifcheckalias(char*);
extern int            ldifcheckbase(char*);

/* file ldaplog.c   */
extern void           ldiflogval(teloglevel,char*,char*,char*,size_t);
extern void           ldiflog(teloglevel,char*,...);
extern void           ldiflogbin(teloglevel,char*,...);

/* file ldapconf.c  */
extern void           ldifinitconf(char*);
extern char          *ldifgetgconf(tevarid);
extern char          *ldifgetpconf(tevarid);

/* file ldapmod.c   */
extern void           ldifmodify(LDAP*,struct s_mod*,struct s_schema*);

/* file ldapstats.c */
extern void           ldifstats(struct s_mod*);

/* file ldapdl.c    */
extern void           ldifdl(struct s_mod*);

/* file ldapiconv.c */
extern void           ldificonvopen();
extern int            ldificonv(char**,char**);
extern void           ldificonvclose();

/* file ldapparse.c */
extern int            ldifparse(char*,char**,char**,size_t*,teattrtype*);

/* file ldapschema.c */
extern void           ldifschemacreate(LDAP*,struct s_schema**);
extern void           ldifschemafree(struct s_schema**);
extern int            ldifschemaequal(struct s_schema*,char*);
extern int            ldifschemamulti(struct s_schema*,char*);
extern char          *ldifschemarattr(struct s_schema*,char*);
extern void           ldifschemareplacealiases(struct s_ldif*,struct s_schema*);
