#############################################################################
#
#  Linux Desktop Testing Project http://ldtp.freedesktop.org
# 
#  Author:
#     Nagappan Alagappan <nagappan@gmail.com>
# 
#  Copyright 2008 Nagappan Alagappan
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA 02110, USA.
#
#############################################################################

from ldtplibutils import *

global _ldtpDebug

class CheckBox:
    def isCheckBoxEnabled (self, accessible):
        # FIXME: Implement wait_till_object_state_contains
        return True

    def click (self, accessible):
        if self.isCheckBoxEnabled (accessible) == False:
            return LdtpErrorCode.INVALID_OBJECT_STATE
        _component = accessible.queryComponent ()
        _flag = False
        if _component:
            _flag = _component.grabFocus ()
            if _ldtpDebug:
                print 'Grab focus %s' % _flag
            _component.unref ()
        _action = accessible.queryAction ()
        _flag = False
        if _action:
            # FIXME: Do action based on event, instead of 0
            _flag = _action.doAction (0)
            _action.unref ()
        if _flag:
            return LdtpErrorCode.SUCCESS
        else:
            return LdtpErrorCode.CLICK_FAILED

def checkBoxMain (cctxt, cmd):
    checkBoxInst = CheckBox ()
    if cmd == command.CLICK:
        status = checkBoxInst.click (cctxt.guiHandle.handle)
        checkBoxInst = None
        return status
    elif cmd == command.GRABFOCUS:
        status = grabFocus (cctxt.guiHandle.handle)
        checkBoxInst = None
        return status
    else:
        checkBoxInst = None
        return LdtpErrorCode.COMMAND_NOT_IMPLEMENTED
