/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * Linux Desktop Testing Project http://ldtp.freedesktop.org
 *
 * Author:
 *    Veerapuram Varadhan <v.varadhan@gmail.com>
 *
 * Copyright 2004 - 2006 Novell, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110, USA.
 */

#ifndef _LDTP_ERROR_H
#define _LDTP_ERROR_H

typedef enum _LDTPErrorCode {
	LDTP_ERROR_SUCCESS,
	LDTP_ERROR_ARGUMENT_NULL = -1001,
	LDTP_ERROR_ACCEPT_FAILED,
	LDTP_ERROR_UNABLE_TO_REINIT_LDTP,
	LDTP_ERROR_UNABLE_TO_ALLOCATE_MEMORY,
	LDTP_ERROR_UNABLE_TO_GET_APPLICATION_LIST,
	LDTP_ERROR_UNABLE_TO_GET_OBJECT_LIST,
	LDTP_ERROR_THREAD_CREATION_FAILED,
	LDTP_ERROR_THREAD_DETACH_FAILED,
	LDTP_ERROR_PACKET_INVALID,
	LDTP_ERROR_RECEIVE_RESPONSE,
	LDTP_ERROR_SENDING_RESPONSE,
	LDTP_ERROR_PARTIAL_DATA_SENT,
	LDTP_ERROR_INVALID_COMMAND,
	LDTP_ERROR_INVALID_STATE,
	LDTP_ERROR_APPMAP_NOT_INITIALIZED,
	LDTP_ERROR_OPENING_APPMAP_FILE,
	LDTP_ERROR_OPENING_LOG_FILE,
	LDTP_ERROR_APP_NOT_RUNNING,
	LDTP_ERROR_UNABLE_TO_UPDATE_APPMAP,
	LDTP_ERROR_WIN_NAME_NOT_FOUND_IN_APPMAP,
	LDTP_ERROR_OBJ_NAME_NOT_FOUND_IN_APPMAP,
	LDTP_ERROR_WIN_NOT_OPEN,
	LDTP_ERROR_UNABLE_TO_GET_CONTEXT_HANDLE,
	LDTP_ERROR_UNABLE_TO_GET_COMPONENT_HANDLE,
	LDTP_ERROR_UNABLE_TO_GET_PROPERTY,
	LDTP_ERROR_GET_OBJ_HANDLE_FAILED,
	LDTP_ERROR_UNABLE_TO_GET_CELL_HANDLE_FAILED,
	LDTP_ERROR_OBJ_INFO_MISMATCH,
	LDTP_ERROR_COMMAND_NOT_IMPLEMENTED,
	LDTP_ERROR_COMMAND_NOT_SUPPORTED,
	LDTP_ERROR_GETTEXTVALUE_FAILED,
	LDTP_ERROR_STATUSBAR_GETTEXT_FAILED,
	LDTP_ERROR_STATUSBAR_NOT_VISIBLE,
	LDTP_ERROR_CHILD_TYPE_UNIDENTIFIED,
	LDTP_ERROR_SELECTITEM_FAILED,
	LDTP_ERROR_VERIFY_ITEM_FAILED,
	LDTP_ERROR_SELECTINDEX_FAILED,
	LDTP_ERROR_TEXT_NOT_FOUND,
	LDTP_ERROR_TEXT_STATE_ENABLED,
	LDTP_ERROR_TEXT_STATE_NOT_ENABLED,
	LDTP_ERROR_SETTEXTVALUE_FAILED,
	LDTP_ERROR_VERIFY_SETTEXTVALUE_FAILED,
	LDTP_ERROR_CLICK_FAILED,
	LDTP_ERROR_DOUBLE_CLICK_FAILED,
	LDTP_ERROR_RIGHT_CLICK_FAILED,
	LDTP_ERROR_CHILD_IN_FOCUS,
	LDTP_ERROR_CHILD_NOT_FOCUSSED,
	LDTP_ERROR_UNABLE_TO_GET_MENU_HANDLE,
	LDTP_ERROR_UNABLE_TO_FIND_POPUP_MENU,
	LDTP_ERROR_MENU_VISIBLE,
	LDTP_ERROR_MENU_NOT_VISIBLE,
	LDTP_ERROR_HIDELIST_FAILED,
	LDTP_ERROR_SHOWLIST_FAILED,
	LDTP_ERROR_VERIFY_SHOWLIST_FAILED,
	LDTP_ERROR_ITEM_NOT_FOUND,
	LDTP_ERROR_FILECAPTURE_FAILED_OPEN_OUTPUT_FILE,
	LDTP_ERROR_VERIFY_DROPDOWN_FAILED,
	LDTP_ERROR_CALENDAR_EVENT_INDEX_GREATER,
	LDTP_ERROR_UNABLE_TO_SELECT_CALENDAR_EVENT_INDEX,
	LDTP_ERROR_UNABLE_TO_SELECT_CALENDAR_EVENT_NAME,
	LDTP_ERROR_NO_APPOINTMENTS_IN_CALENDAR,
	LDTP_ERROR_UNABLE_TO_GET_VALUE,
	LDTP_ERROR_UNABLE_TO_GRAB_FOCUS,
	LDTP_ERROR_OBJ_NOT_COMPONENT_TYPE,
	LDTP_ERROR_INVALID_DATE,
	LDTP_ERROR_INVALID_OBJECT_STATE,
	LDTP_ERROR_CHECK_ACTION_FAILED,
	LDTP_ERROR_UNCHECK_ACTION_FAILED,
	LDTP_ERROR_STATE_CHECKED,
	LDTP_ERROR_STATE_UNCHECKED,
	LDTP_ERROR_UNABLE_TO_SELECT_LABEL,
	LDTP_ERROR_LABEL_NOT_FOUND,
	LDTP_ERROR_UNABLE_TO_SELECT_LAYERED_PANE_ITEM,
	LDTP_ERROR_UNABLE_TO_SELECT_TEXT_ITEM,
	LDTP_ERROR_LIST_INDEX_GREATER,
	LDTP_ERROR_UNABLE_TO_GET_SELECTED_CHILD,
	LDTP_ERROR_UNABLE_TO_SELECT_CHILD,
	LDTP_ERROR_UNABLE_TO_GET_CHILD_MENU_ITEM,
	LDTP_ERROR_UNABLE_TO_LIST_MENU_ITEMS,
	LDTP_ERROR_UNABLE_TO_SELECT_LIST_ITEM,
	LDTP_ERROR_MENU_ITEM_DOES_NOT_EXIST,
	LDTP_ERROR_MENU_ITEM_STATE_DISABLED,
	LDTP_ERROR_SELECT_MENU_ITEM_FAILED,
	LDTP_ERROR_PAGE_TAB_NAME_SELECTION_FAILED,
	LDTP_ERROR_PAGE_TAB_NAME_ALREADY_IN_SELECTED_STATE,
	LDTP_ERROR_PAGE_TAB_NAME_DOESNOT_EXIST,
	LDTP_ERROR_PAGE_TAB_INDEX_DOESNOT_EXIST,
	LDTP_ERROR_PAGE_TAB_NAME_INPUT_DOESNOT_EXIST,
	LDTP_ERROR_PAGE_TAB_INDEX_INPUT_DOESNOT_EXIST,
	LDTP_ERROR_NO_PANEL_EXIST,
	LDTP_ERROR_PANEL_NAME_SELECTION_FAILED,
	LDTP_ERROR_PANEL_INDEX_SELECTION_FAILED,
	LDTP_ERROR_PANEL_COUNT_LESS_THAN_TOTAL_PANEL,
	LDTP_ERROR_PUSH_BUTTON_STATE_NOT_ENABLED,
	LDTP_ERROR_TOGGLE_BUTTON_STATE_NOT_ENABLED,
	LDTP_ERROR_RADIO_BUTTON_ALREADY_CHECKED,
	LDTP_ERROR_RADIO_BUTTON_STATE_NOT_ENABLED,
	LDTP_ERROR_RADIO_BUTTON_CHECKED,
	LDTP_ERROR_RADIO_BUTTON_NOT_CHECKED,
	LDTP_ERROR_RADIO_MENU_ITEM_ALREADY_CHECKED,
	LDTP_ERROR_RADIO_MENU_ITEM_CHECKED,
	LDTP_ERROR_RADIO_MENU_ITEM_NOT_CHECKED,
	LDTP_ERROR_NOT_VERTICAL_SCROLL_BAR,
	LDTP_ERROR_UNABLE_TO_SCROLL_WITH_GIVEN_VALUE,
	LDTP_ERROR_NOT_HORIZONTAL_SCROLL_BAR,
	LDTP_ERROR_SCROLL_BAR_MAX_REACHED,
	LDTP_ERROR_SCROLL_BAR_MIN_REACHED,
	LDTP_ERROR_NOT_VERTICAL_SLIDER,
	LDTP_ERROR_NOT_HORIZONTAL_SLIDER,
	LDTP_ERROR_SLIDER_SET_MAX_FAILED,
	LDTP_ERROR_SLIDER_SET_MIN_FAILED,
	LDTP_ERROR_SLIDER_MAX_REACHED,
	LDTP_ERROR_SLIDER_MIN_REACHED,
	LDTP_ERROR_UNABLE_TO_INCREASE_SLIDER_VALUE,
	LDTP_ERROR_UNABLE_TO_DECREASE_SLIDER_VALUE,
	LDTP_ERROR_UNABLE_TO_GET_SLIDER_VALUE,
	LDTP_ERROR_UNABLE_TO_SET_SPIN_BUTTON_VALUE,
	LDTP_ERROR_UNABLE_TO_SPIN_BUTTON_VALUES_NOT_SAME,
	LDTP_ERROR_TOGGLE_ACTION_FAILED,
	LDTP_ERROR_TOGGLE_CHECKED,
	LDTP_ERROR_TOGGLE_NOT_CHECKED,
	LDTP_ERROR_TOOLBAR_VISIBLE_BUTTON_COUNT_FAILED,
	LDTP_ERROR_TOOLBAR_BUTTON_COUNT_FAILED,
	LDTP_ERROR_UNABLE_TO_SET_TEXT,
	LDTP_ERROR_UNABLE_TO_CUT_TEXT,
	LDTP_ERROR_UNABLE_TO_COPY_TEXT,
	LDTP_ERROR_UNABLE_TO_PASTE_TEXT,
	LDTP_ERROR_UNABLE_TO_DELETE_TEXT,
	LDTP_ERROR_UNABLE_TO_SELECT_TEXT,
	LDTP_ERROR_UNABLE_TO_ACTIVATE_TEXT,
	LDTP_ERROR_UNABLE_TO_APPEND_TEXT,
	LDTP_ERROR_UNABLE_TO_INSERT_TEXT,
	LDTP_ERROR_UNABLE_TO_GET_TEXT_PROPERTY,
	LDTP_ERROR_ONE_OR_MORE_PROPERTIES_DOES_NOT_MATCH,
	LDTP_ERROR_TEXT_OBJECT_VALUE_CONTAINS_DIFF_PROEPRTY,
	LDTP_ERROR_TEXT_OBJECT_DOES_NOT_CONTAIN_PROEPRTY,
	LDTP_ERROR_TEXT_PROEPRTY_VALUE_PAIR_IS_INVALID,
	LDTP_ERROR_TEXT_TO_INSERT_IS_EMPTY,
	LDTP_ERROR_VERIFY_SET_TEXT_FAILED,
	LDTP_ERROR_VERIFY_PARTIAL_MATCH_FAILED,
	LDTP_ERROR_INVALID_COLUMN_INDEX_TO_SORT,
	LDTP_ERROR_UNABLE_TO_SORT,
	LDTP_ERROR_ROW_DOES_NOT_EXIST,
	LDTP_ERROR_COLUMN_DOES_NOT_EXIST,
	LDTP_ERROR_UNABLE_TO_SELECT_ROW,
	LDTP_ERROR_UNABLE_TO_GET_ROW_INDEX,
	LDTP_ERROR_SET_TABLE_CELL_FAILED,
	LDTP_ERROR_GET_TABLE_CELL_FAILED,
	LDTP_ERROR_VERIFY_TABLE_CELL_FAILED,
	LDTP_ERROR_VERIFY_TABLE_CELL_PARTIAL_MATCH_FAILED,
	LDTP_ERROR_ACTUAL_ROW_COUNT_LESS_THAN_GIVEN_ROW_COUNT,
	LDTP_ERROR_ACTUAL_COLUMN_COUNT_LESS_THAN_GIVEN_COLUMN_COUNT,
	LDTP_ERROR_GET_TREE_TABLE_CELL_FAILED,
	LDTP_ERROR_NO_CHILD_TEXT_TYPE_UNDER_TABLE,
	LDTP_ERROR_UNABLE_TO_PERFORM_ACTION,
	LDTP_ERROR_GUI_EXIST,
	LDTP_ERROR_GUI_NOT_EXIST,
	LDTP_ERROR_CALLBACK,
	LDTP_ERROR_UNABLE_TO_CREATE_PO,
	LDTP_ERROR_UNABLE_TO_DELETE_PO,
	LDTP_ERROR_ONLY_MO_MODE_SUPPORTED,
	LDTP_ERROR_UTF8_ENGLISH_LANG,
	LDTP_ERROR_UNABLE_TO_STAT_DIR,
	LDTP_ERROR_ROLE_NOT_IMPLEMENTED,
	LDTP_ERROR_UNABLE_TO_MOVE_MOUSE,
	LDTP_ERROR_INVALID_FORMAT,
	LDTP_ERROR_TOKEN_NOT_FOUND,
	LDTP_ERROR_UNABLE_TO_ENTER_KEY,
	LDTP_ERROR_UNABLE_TO_SET_CARET,
	LDTP_ERROR_OFFSET_OUT_OF_BOUND,
	LDTP_ERROR_TEXT_NOT_ACCESSIBLE,
	LDTP_ERROR_STOP_SCRIPT_ENGINE,
	LDTP_ERROR_WRONG_COMMAND_SEQUENCE,
	LDTP_ERROR_UNABLE_TO_LAUNCH_APP,
	LDTP_ERROR_CLIENT_DISCONNECTED,
	LDTP_ERROR_EVENT_NOTIFIER_NOT_ENABLED,
	LDTP_ERROR_SET_GUI_TIMEOUT_FAILED,
	LDTP_ERROR_SET_OBJ_TIMEOUT_FAILED,
	LDTP_ERROR_UNABLE_TO_GET_CHILD_WITH_PROVIDED_ROLE,
	LDTP_ERROR_UNABLE_TO_GET_PAGE_TAB_NAME,
	LDTP_ERROR_UNABLE_TO_VERIFY_PAGE_TAB_NAME,
	LDTP_ERROR_CHECK_BOX_STATE_NOT_ENABLED,
	LDTP_ERROR_UNABLE_TO_GET_WINDOW_LIST,
	LDTP_ERROR_UNABLE_TO_SET_SLIDER_VALUE,
	LDTP_ERROR_UNABLE_TO_GET_OBJECT_STATE,
	LDTP_ERROR_SET_APP_UNDER_TEST_NAME_FAILED
} LDTPErrorCode;

const char* ldtp_error_get_message (LDTPErrorCode error);

#endif
