/*
 * L.LatLngBounds represents a rectangular area on the map in geographical coordinates.
 */

L.LatLngBounds = L.Class.extend({
	initialize: function(southWest, northEast) {	// (LatLng, LatLng) or (LatLng[])
		if (!southWest) return;
		var latlngs = (southWest instanceof Array ? southWest : [southWest, northEast]);
		for (var i = 0, len = latlngs.length; i < len; i++) {
			this.extend(latlngs[i]);
		}
	},
	
	// extend the bounds to contain the given point
	extend: function(/*LatLng*/ latlng) {
		if (!this._southWest && !this._northEast) {
			this._southWest = new L.LatLng(latlng.lat, latlng.lng);
			this._northEast = new L.LatLng(latlng.lat, latlng.lng);
		} else {
			this._southWest.lat = Math.min(latlng.lat, this._southWest.lat);
			this._southWest.lng = Math.min(latlng.lng, this._southWest.lng);
			this._northEast.lat = Math.max(latlng.lat, this._northEast.lat);
			this._northEast.lng = Math.max(latlng.lng, this._northEast.lng);
		}
	},
	
	getCenter: function() /*-> LatLng*/ {
		return new L.LatLng(
				(this._southWest.lat + this._northEast.lat) / 2, 
				(this._southWest.lng + this._northEast.lng) / 2);
	},
	
	getSouthWest: function() { return this._southWest; },
	
	getNorthEast: function() { return this._northEast; },
	
	getNorthWest: function() {
		return new L.LatLng(this._northEast.lat, this._southWest.lng);
	},
	
	getSouthEast: function() {
		return new L.LatLng(this._southWest.lat, this._northEast.lng);
	},
	
	contains: function(/*LatLngBounds or LatLng*/ obj) /*-> Boolean*/ {
		var sw = this._southWest,
			ne = this._northEast,
			sw2, ne2;
		
		if (obj instanceof L.LatLngBounds) {
			sw2 = obj.getSouthWest();
			ne2 = obj.getNorthEast();
		} else {
			sw2 = ne2 = obj;
		}
		
		return (sw2.lat >= sw.lat) && (ne2.lat <= ne.lat) &&
				(sw2.lng >= sw.lng) && (ne2.lng <= ne.lng);
	}
});

//TODO International date line?