/***************************************************************************
 *   Copyright (C) 2007 by Miguel Chavez Gamboa                            *
 *   miguel.chavez.gamboa@gmail.com                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *

 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#define QT_GUI_LIB
//The above line is because that define is needed, and as i dont use qmake, i must define it here..
//And only caused problems with the QSqlRelationalDelegate.. what a thing.

#include "squeezeview.h"
#include "settings.h"
#include "usersdelegate.h"
#include "usereditor.h"
#include "clienteditor.h"
#include "promoeditor.h"
#include "producteditor.h"
#include "purchaseeditor.h"
#include "../../src/hash.h"
#include "../../src/misc.h"
#include "../../src/structs.h"
#include "../../src/enums.h"
#include "../../src/productdelegate.h"
#include "offersdelegate.h"

#include <QLabel>
#include <QPixmap>
#include <QByteArray>
#include <QBuffer>
#include <QTimer>
#include <QDoubleValidator>
#include <QRegExp>
#include <QTableView>

#include <QDataWidgetMapper>
#include <QSqlRelationalTableModel>
#include <QSqlRelationalDelegate>
#include <QItemDelegate>
#include <QHeaderView>

#include <klocale.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <kmessagebox.h>

//TODO: Change all qDebug to errorDialogs or remove them.

enum {pWelcome=0, pBrowseProduct=1, pBrowseOffers=2, pBrowseUsers=3, pBrowseMeasures=4, pBrowseCategories=5, pBrowseClients=6};


squeezeView::squeezeView(QWidget *parent)
    : QWidget(parent)
{
  ui_mainview.setupUi(this);
  settingsChanged();
  setAutoFillBackground(true);

  counter = 5;
  modelsOk = false;
  timerCheckDb = new QTimer(this);
  timerCheckDb->setInterval(1000);
  categoriesHash.clear();
  setupSignalConnections();
  QTimer::singleShot(1100, this, SLOT(setupDb()));
  QTimer::singleShot(2000, timerCheckDb, SLOT(start()));
  //timerCheckDb->start();

  //ui_mainview.groupFilterProducts->hide();
  //ui_mainview.groupFilterOffers->hide();
  ui_mainview.chOffersTodayDiscounts->setEnabled(false);
  ui_mainview.chOffersOldDiscounts->setEnabled(false);

  ui_mainview.stackedWidget->setCurrentIndex(pWelcome);
}

void squeezeView::login(){

  // no login now...

}

void squeezeView::setupSignalConnections()
{
  connect(ui_mainview.usersView, SIGNAL(activated(const QModelIndex &)), SLOT(usersViewOnSelected(const QModelIndex &)));
  connect(ui_mainview.clientsView, SIGNAL(activated(const QModelIndex &)), SLOT(clientsViewOnSelected(const QModelIndex &)));
  connect(ui_mainview.productsView, SIGNAL(activated(const QModelIndex &)), SLOT(productsViewOnSelected(const QModelIndex &)));

  connect(ui_mainview.groupFilterOffers, SIGNAL(toggled(bool)), SLOT(setOffersFilter()));
  connect(ui_mainview.chOffersSelectDate, SIGNAL(toggled(bool)), SLOT(setOffersFilter()));
  connect(ui_mainview.chOffersFilterByProduct, SIGNAL(toggled(bool)), SLOT(setOffersFilter()));
  connect(ui_mainview.editOffersFilterByProduct, SIGNAL( textEdited(const QString &) ), SLOT(setOffersFilter()));
  connect(ui_mainview.btnAddUser, SIGNAL(clicked()), SLOT(createUser()));
  connect(ui_mainview.btnAddOffer, SIGNAL(clicked()), SLOT(createOffer()));
  connect(ui_mainview.btnDeleteUser, SIGNAL(clicked()), SLOT(deleteSelectedUser()));
  connect(ui_mainview.btnDeleteOffer, SIGNAL(clicked()), SLOT(deleteSelectedOffer()));
  connect(ui_mainview.btnAddProduct, SIGNAL(clicked()), SLOT(createProduct()) );
  connect(ui_mainview.btnAddMeasure, SIGNAL(clicked()), SLOT(createMeasure()) );
  connect(ui_mainview.btnAddCategory, SIGNAL(clicked()), SLOT(createCategory()) );
  connect(ui_mainview.btnAddClient, SIGNAL(clicked()), SLOT(createClient()));
  connect(ui_mainview.btnDeleteProduct, SIGNAL(clicked()), SLOT(deleteSelectedProduct()) );
  connect(ui_mainview.btnDeleteMeasure, SIGNAL(clicked()), SLOT(deleteSelectedMeasure()) );
  connect(ui_mainview.btnDeleteCategory, SIGNAL(clicked()), SLOT(deleteSelectedCategory()) );
  connect(ui_mainview.btnDeleteClient, SIGNAL(clicked()), SLOT(deleteSelectedClient()));

  connect(timerCheckDb, SIGNAL(timeout()), this, SLOT(checkDBStatus()));
  connect(ui_mainview.offersDateEditor, SIGNAL(changed(const QDate &)), this, SLOT(setOffersFilter()));
}

void squeezeView::showProductsPage()
{
  ui_mainview.stackedWidget->setCurrentIndex(pBrowseProduct);
  if (productsModel->tableName().isEmpty()) setupProductsModel();
  ui_mainview.titleBar->setText(i18n("Products"));
  ui_mainview.titleBar->setPixmap((KIcon("lemon-box")));
}

void squeezeView::showOffersPage()
{
  ui_mainview.stackedWidget->setCurrentIndex(pBrowseOffers);
  if (offersModel->tableName().isEmpty()) setupOffersModel();
  ui_mainview.titleBar->setText(i18n("Offers"));
  ui_mainview.titleBar->setPixmap((KIcon("lemon-money")));
  ui_mainview.offersDateEditor->setDate(QDate::currentDate());

  //FIXME & NOTE: Offers that does not have existing products are ignored (hidden) on the view, but still exists on Database.
  //              This happens when an offer exists for a product, but the product code is changed or deleted later.
}

void squeezeView::showUsersPage()
{
  ui_mainview.stackedWidget->setCurrentIndex(pBrowseUsers);
  if (usersModel->tableName().isEmpty()) setupUsersModel();
  ui_mainview.titleBar->setText(i18n("Users"));
  ui_mainview.titleBar->setPixmap((KIcon("lemon-user")));
}

void squeezeView::showMeasuresPage()
{
  ui_mainview.stackedWidget->setCurrentIndex(pBrowseMeasures);
  if (measuresModel->tableName().isEmpty()) setupMeasuresModel();
  ui_mainview.titleBar->setText(i18n("Weight and Measures"));
  ui_mainview.titleBar->setPixmap((KIcon("lemon-ruler")));
}

void squeezeView::showCategoriesPage()
{
  ui_mainview.stackedWidget->setCurrentIndex(pBrowseCategories);
  if (categoriesModel->tableName().isEmpty()) setupCategoriesModel();
  ui_mainview.titleBar->setText(i18n("Categories"));
  ui_mainview.titleBar->setPixmap((KIcon("lemon-box")));//TODO:Make an icon for this...
}

void squeezeView::showClientsPage()
{
  ui_mainview.stackedWidget->setCurrentIndex(pBrowseClients);
  if (clientsModel->tableName().isEmpty()) setupClientsModel();
  ui_mainview.titleBar->setText(i18n("Clients"));
  ui_mainview.titleBar->setPixmap((KIcon("lemon-user")));//TODO:Make an icon for this...
}

void squeezeView::showTransactionsPage()
{
}

void squeezeView::toggleFilterBox(bool show)
{
  if (show) {
    switch (ui_mainview.stackedWidget->currentIndex())
    {
      case pBrowseProduct: ui_mainview.groupFilterProducts->show(); break;
      case pBrowseOffers:ui_mainview.groupFilterOffers->show(); break;
      case pWelcome: break;
      default: break;
    }
  }
  else {
    switch (ui_mainview.stackedWidget->currentIndex())
    {
      case pBrowseProduct: ui_mainview.groupFilterProducts->hide(); break;
      case pBrowseOffers:ui_mainview.groupFilterOffers->hide(); break;
      case pWelcome: break;
      default: break;
    }
  }
}

squeezeView::~squeezeView()
{
}


/*  ----------------- Database ----------------- */
void squeezeView::setupDb()
{
  QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));
  db = QSqlDatabase::addDatabase("QMYSQL");
  db.setHostName(Settings::editDBServer());
  db.setDatabaseName(Settings::editDBName());
  db.setUserName(Settings::editDBUsername());
  db.setPassword(Settings::editDBPassword());
  db.open();
  if (db.isOpen()) {
    emit signalConnected();
    productsModel   = new QSqlRelationalTableModel();
    offersModel     = new QSqlRelationalTableModel();
    usersModel      = new QSqlTableModel();
    measuresModel   = new QSqlTableModel();
    categoriesModel = new QSqlTableModel();
    clientsModel    = new QSqlTableModel();
    modelsOk = true;
  } else { emit signalDisconnected(); }
}

void squeezeView::openDB()
{
 bool ok=false;
  if (!db.isOpen()) {
   ok = db.open();
  } else ok = true;

  if (!ok) {
   emit signalDisconnected();
   qDebug()<<db.lastError();
  } else {
    emit signalConnected();
    if (!modelsCreated()) setupDb();
  }
}


//NOTE:There is a problem if connected and then mysql stop... db.isOpen() returns true.
void squeezeView::checkDBStatus()
{
 if (!isConnected()) {
  if (counter < 4) {
    counter++;
    emit signalChangeStatusbar(i18n("Trying connection in %1 seconds...", 5-counter));
  }
  else {
    counter = 0;
    emit signalChangeStatusbar(i18n("Connecting..."));
    openDB();
  }
 } else emit signalChangeStatusbar("");
}

void squeezeView::closeDB()
{
  db.close();
}

void squeezeView::setupUsersModel()
{
  if (db.isOpen()) {
    usersModel->setTable("users");

    ui_mainview.usersView->setModel(usersModel);
    ui_mainview.usersView->setViewMode(QListView::IconMode);
    ui_mainview.usersView->setGridSize(QSize(170,170));
    ui_mainview.usersView->setEditTriggers(QAbstractItemView::NoEditTriggers);
    ui_mainview.usersView->setResizeMode(QListView::Adjust);
    ui_mainview.usersView->setModelColumn(usersModel->fieldIndex("photo"));
    ui_mainview.usersView->setSelectionMode(QAbstractItemView::SingleSelection);


    UsersDelegate *delegate = new UsersDelegate(ui_mainview.usersView);
    ui_mainview.usersView->setItemDelegate(delegate);

    usersModel->select();

  }
  else {
      //At this point, what to do?
     // inform to the user about the error and finish app  or retry again some time later?
    QString details = db.lastError().text();
    KMessageBox::detailedError(this, i18n("Squeeze has encountered an error, click details to see the error details."), details, i18n("Error"));
    QTimer::singleShot(10000, this, SLOT(setupUsersModel()));
  }
}

void squeezeView::setupProductsModel()
{
  openDB();
  qDebug()<<"setupProducts.. after openDB";
  if (db.isOpen()) {
    productsModel->setTable("products");

    productCodeIndex = productsModel->fieldIndex("code");
    productDescIndex = productsModel->fieldIndex("name");
    productPriceIndex= productsModel->fieldIndex("price");
    productStockIndex= productsModel->fieldIndex("stockqty");
    productCostIndex = productsModel->fieldIndex("cost");
    productSoldUnitsIndex= productsModel->fieldIndex("soldunits");
    productLastSoldIndex= productsModel->fieldIndex("datelastsold");
    productUnitsIndex= productsModel->fieldIndex("units");
    productTaxIndex = productsModel->fieldIndex("taxpercentage");
    productETaxIndex= productsModel->fieldIndex("extrataxes");
    productPhotoIndex=productsModel->fieldIndex("photo");
    productCategoryIndex=productsModel->fieldIndex("category");


    ui_mainview.productsView->setModel(productsModel);
    ui_mainview.productsView->setViewMode(QListView::IconMode);
    ui_mainview.productsView->setGridSize(QSize(170,170));
    ui_mainview.productsView->setEditTriggers(QAbstractItemView::NoEditTriggers);
    ui_mainview.productsView->setResizeMode(QListView::Adjust);
    ui_mainview.productsView->setModelColumn(productsModel->fieldIndex("photo"));
    ui_mainview.productsView->setSelectionMode(QAbstractItemView::SingleSelection);


    ProductDelegate *delegate = new ProductDelegate(ui_mainview.productsView);
    ui_mainview.productsView->setItemDelegate(delegate);
    ui_mainview.productsView->setSelectionMode(QAbstractItemView::SingleSelection);

    productsModel->select();

    //populate Categories...
    populateCategoriesHash();
      QHashIterator<QString, int> item(categoriesHash);
      while (item.hasNext()) {
        item.next();
        ui_mainview.comboProductsFilterByCategory->addItem(item.key());
      }
      ui_mainview.comboProductsFilterByCategory->setCurrentIndex(0);
      connect(ui_mainview.comboProductsFilterByCategory,SIGNAL(currentIndexChanged(int)), this, SLOT( setProductsFilter()) );
      connect(ui_mainview.editProductsFilterByDesc,SIGNAL(returnPressed()), this, SLOT( setProductsFilter()) );
      connect(ui_mainview.rbProductsFilterByDesc, SIGNAL(toggled(bool)), this, SLOT( setProductsFilter()) );
      connect(ui_mainview.rbProductsFilterByCategory, SIGNAL(toggled(bool)), this, SLOT( setProductsFilter()) );
      connect(ui_mainview.rbProductsFilterByAvailable, SIGNAL(toggled(bool)), this, SLOT( setProductsFilter()) );
      connect(ui_mainview.rbProductsFilterByNotAvailable, SIGNAL(toggled(bool)), this, SLOT( setProductsFilter()) );
      connect(ui_mainview.rbProductsFilterByMostSold, SIGNAL(toggled(bool)), this, SLOT( setProductsFilter()) );
      connect(ui_mainview.rbProductsFilterByLessSold, SIGNAL(toggled(bool)), this, SLOT( setProductsFilter()) );
      connect(ui_mainview.groupFilterProducts, SIGNAL(toggled(bool)), this, SLOT( setProductsFilter()) );

      ui_mainview.rbProductsFilterByAvailable->setChecked(true);
      setProductsFilter();
      qDebug()<<"filter///";

  //   else {
  //       //At this point, what to do?
  //      // inform to the user about the error and finish app  or retry again some time later?
  //     QString details = db.lastError().text();
  //     KMessageBox::detailedError(this, i18n("Squeeze has encountered an error, click details to see the error details."), details, i18n("Error"));
  //     QTimer::singleShot(10000, this, SLOT(setupUsersModel()));
  //   }
 }
 qDebug()<<"setupProcuts.. done.";
}

void squeezeView::populateCategoriesHash()
{
  if (!db.isOpen()) openDB();
  if (db.isOpen()) {
    QSqlQuery myQuery(db);
    if (myQuery.exec("select * from categories;")) {
      while (myQuery.next()) {
        int fieldId   = myQuery.record().indexOf("catid");
        int fieldText = myQuery.record().indexOf("text");
        int id = myQuery.value(fieldId).toInt();
        QString text = myQuery.value(fieldText).toString();
        categoriesHash.insert(text, id);
      }
    }
    else {
      qDebug()<<"ERROR: "<<myQuery.lastError();
    }
 }
}

void squeezeView::setProductsFilter()
{
//NOTE: This is a QT BUG.
//   If filter by description is selected and the text is empty, and later is re-filtered
//   then NO pictures are shown; even if is refiltered again.
QRegExp regexp = QRegExp(ui_mainview.editProductsFilterByDesc->text());
if (!ui_mainview.groupFilterProducts->isChecked()) productsModel->setFilter("");
else {
  if (ui_mainview.rbProductsFilterByDesc->isChecked()) {
  //1st if: Filter by DESC.
    if (!regexp.isValid() || ui_mainview.editProductsFilterByDesc->text().isEmpty())  ui_mainview.editProductsFilterByDesc->setText("*");
    if (ui_mainview.editProductsFilterByDesc->text()=="*") productsModel->setFilter("");
    else  productsModel->setFilter(QString("products.name REGEXP '%1'").arg(ui_mainview.editProductsFilterByDesc->text()));
    productsModel->setSort(productStockIndex, Qt::DescendingOrder);
  }
  else if (ui_mainview.rbProductsFilterByCategory->isChecked()) {
  //2nd if: Filter by CATEGORY
    //Find catId for the text on the combobox.
    int catId=-1;
    QString catText = ui_mainview.comboProductsFilterByCategory->currentText();
    if (categoriesHash.contains(catText)) {
      catId = categoriesHash.value(catText);
    }
    productsModel->setFilter(QString("products.category=%1").arg(catId));
    productsModel->setSort(productStockIndex, Qt::DescendingOrder);
  }
  else if (ui_mainview.rbProductsFilterByAvailable->isChecked()) {
  //3rd if: filter by Available items
    productsModel->setFilter(QString("products.stockqty>0"));
    productsModel->setSort(productStockIndex, Qt::DescendingOrder);
  }
  else if (ui_mainview.rbProductsFilterByNotAvailable->isChecked()) {
  //4th if: filter by NOT Available items
    productsModel->setFilter(QString("products.stockqty=0"));
    productsModel->setSort(productSoldUnitsIndex, Qt::DescendingOrder);
  }
  else if (ui_mainview.rbProductsFilterByMostSold->isChecked()) {
  //5th if: filter by Most Sold items
    productsModel->setFilter("");
    productsModel->setSort(productSoldUnitsIndex, Qt::DescendingOrder);
  }
  else {
  //else: filter by less sold items
    productsModel->setFilter("");
    productsModel->setSort(productSoldUnitsIndex, Qt::AscendingOrder);
  }

  productsModel->select();
 }
}

//FIXME: We must validate dates at edit mode. CREATE an offerDelegate. <--TODO
//       For now, it does not crash lemon, only ignores the offer for the product.
void squeezeView::setupOffersModel()
{
  offersModel->setTable("offers");
  offersModel->setEditStrategy(QSqlTableModel::OnFieldChange);

  offerIdIndex       = offersModel->fieldIndex("id");
  offerProdIdIndex   = offersModel->fieldIndex("product_id");
  offerDiscountIndex = offersModel->fieldIndex("discount");
  offerDayIndex      = offersModel->fieldIndex("validuntilday");
  offerMonthIndex    = offersModel->fieldIndex("validuntilmonth");
  offerYearIndex     = offersModel->fieldIndex("validuntilyear");

  offersModel->setRelation(offerProdIdIndex, QSqlRelation("products", "code", "name"));

  offersModel->setHeaderData(offerIdIndex, Qt::Horizontal, i18n("Id"));
  offersModel->setHeaderData(offerProdIdIndex, Qt::Horizontal, i18n("Product Affected"));
  offersModel->setHeaderData(offerDiscountIndex, Qt::Horizontal, i18n("Discount Applied (%)") );
  offersModel->setHeaderData(offerDayIndex, Qt::Horizontal, i18n("Until Day") );
  offersModel->setHeaderData(offerMonthIndex, Qt::Horizontal, i18n("Until Month") );
  offersModel->setHeaderData(offerYearIndex, Qt::Horizontal, i18n("Until Year") );

  ui_mainview.tableBrowseOffers->setModel(offersModel);
  //QSqlRelationalDelegate *itemOffersDelegate = new QSqlRelationalDelegate(ui_mainview.tableBrowseOffers);
  OffersDelegate *itemOffersDelegate = new OffersDelegate(ui_mainview.tableBrowseOffers);
  ui_mainview.tableBrowseOffers->setItemDelegate(itemOffersDelegate);

  ui_mainview.tableBrowseOffers->setColumnHidden(offerIdIndex, true);

  offersModel->select();
  setOffersFilter();

  ui_mainview.tableBrowseOffers->setSelectionMode(QAbstractItemView::SingleSelection);

//    connect(ui_mainview.tableBrowseOffers->selectionModel(), SIGNAL(currentRowChanged(QModelIndex,QModelIndex)),
//            this, SLOT(offersTableSelectionChanged(QModelIndex)));
//   connect(ui_mainview.tableBrowseOffers->horizontalHeader(), SIGNAL(sectionClicked(int )),
//           this, SLOT(offerTableHeaderClicked(int)));
//   connect(offersModel, SIGNAL(modelReset()), this, SLOT(onOffersModelReset()) );

  ui_mainview.tableBrowseOffers->setCurrentIndex(offersModel->index(0, 0));
}

void squeezeView::setupMeasuresModel()
{
  if (db.isOpen()) {
    measuresModel->setTable("measures");
    measuresModel->setEditStrategy(QSqlTableModel::OnFieldChange);
    measuresModel->setHeaderData(measuresModel->fieldIndex("text"), Qt::Horizontal, i18n("Description"));

    ui_mainview.tableMeasures->setModel(measuresModel);
    ui_mainview.tableMeasures->setSelectionMode(QAbstractItemView::SingleSelection);
    ui_mainview.tableMeasures->setColumnHidden(measuresModel->fieldIndex("id"), true);
    ui_mainview.tableMeasures->setItemDelegate(new QItemDelegate(ui_mainview.tableMeasures));

    measuresModel->select();
    ui_mainview.tableMeasures->setCurrentIndex(measuresModel->index(0, 0));

  }
  else {
      //At this point, what to do?
     // inform to the user about the error and finish app  or retry again some time later?
    QString details = db.lastError().text();
    KMessageBox::detailedError(this, i18n("Squeeze has encountered an error, click details to see the error details."), details, i18n("Error"));
    QTimer::singleShot(10000, this, SLOT(setupMeasuresModel()));
  }
}

void squeezeView::setupCategoriesModel()
{
  if (db.isOpen()) {
    categoriesModel->setTable("categories");
    categoriesModel->setEditStrategy(QSqlTableModel::OnFieldChange);
    categoriesModel->setHeaderData(categoriesModel->fieldIndex("text"), Qt::Horizontal, i18n("Description"));

    ui_mainview.tableCategories->setModel(categoriesModel);
    ui_mainview.tableCategories->setSelectionMode(QAbstractItemView::SingleSelection);
    ui_mainview.tableCategories->setColumnHidden(categoriesModel->fieldIndex("catid"), true);
    ui_mainview.tableCategories->setItemDelegate(new QItemDelegate(ui_mainview.tableCategories));

    categoriesModel->select();
    ui_mainview.tableCategories->setCurrentIndex(categoriesModel->index(0, 0));

  }
  else {
      //At this point, what to do?
     // inform to the user about the error and finish app  or retry again some time later?
    QString details = db.lastError().text();
    KMessageBox::detailedError(this, i18n("Squeeze has encountered an error, click details to see the error details."), details, i18n("Error"));
    QTimer::singleShot(10000, this, SLOT(setupMeasuresModel()));
  }
}

void squeezeView::setupClientsModel()
{
  if (db.isOpen()) {
    clientsModel->setTable("clients");
    ui_mainview.clientsView->setViewMode(QListView::IconMode);
    ui_mainview.clientsView->setGridSize(QSize(170,170));
    ui_mainview.clientsView->setEditTriggers(QAbstractItemView::NoEditTriggers);
    ui_mainview.clientsView->setResizeMode(QListView::Adjust);
    ui_mainview.clientsView->setModel(clientsModel);
    ui_mainview.clientsView->setModelColumn(clientsModel->fieldIndex("photo"));
    ui_mainview.clientsView->setSelectionMode(QAbstractItemView::SingleSelection);

    UsersDelegate *delegate = new UsersDelegate(ui_mainview.clientsView);
    ui_mainview.clientsView->setItemDelegate(delegate);

    clientsModel->select();
    ui_mainview.clientsView->setCurrentIndex(clientsModel->index(0, 0));

  }
  else {
      //At this point, what to do?
     // inform to the user about the error and finish app  or retry again some time later?
    QString details = db.lastError().text();
    KMessageBox::detailedError(this, i18n("Squeeze has encountered an error, click details to see the error details."), details, i18n("Error"));
    QTimer::singleShot(10000, this, SLOT(setupClientsModel()));
  }
}

/* widgets */

void squeezeView::settingsChanged()
{
  emit signalChangeStatusbar( i18n("Settings changed") );
}


void squeezeView::setOffersFilter()
{
  if (ui_mainview.groupFilterOffers->isChecked()) {
    if (ui_mainview.chOffersFilterByProduct->isChecked()) {
      //Get codes and names from offers and products
      QString myFilter;
      QStringList codes;
      QString desc;
      if (ui_mainview.editOffersFilterByProduct->text().isEmpty()) desc = "."; else desc =ui_mainview.editOffersFilterByProduct->text();
      if (!db.isOpen()) openDB();
      if (db.isOpen()) {
        QSqlQuery qry(db);
        QString qryStr= QString("SELECT P.code, P.name, O.product_id FROM offers AS O, products AS P WHERE P.code = O.product_id and P.name REGEXP '%1' ").arg(desc);
        if (!qry.exec(qryStr)) qDebug()<<"Error:" << qry.lastError();
        else {
          codes.clear();
          while (qry.next()) {
            int fieldId   = qry.record().indexOf("code");
            //int fieldName = qry.record().indexOf("name");
            qulonglong c = qry.value(fieldId).toULongLong();
            //QString text = qry.value(fieldName).toString();
            codes.append(QString("offers.product_id=%1 ").arg(c));
          }
          myFilter = codes.join(" OR ");
        }
       }
      if (myFilter == "") myFilter = "offers.product_id=0"; //there should not be a product with code=0
      offersModel->setFilter(myFilter);
    }
    else if (ui_mainview.chOffersTodayDiscounts->isChecked()) {
        //get selected date
        QString day,month,year;
        QDate date = QDate::currentDate();
        day   = QString::number(date.day());
        month = QString::number(date.month());
        year  = QString::number(date.year());

        offersModel->setFilter(QString("offers.validuntilday<=%1 && offers.validuntilmonth<=%2 && offers.validuntilyear<=%3").arg(day).arg(month).arg(year));
    }
    else if (ui_mainview.chOffersSelectDate->isChecked()) {
        //get selected date
        QString day,month,year;
        QDate date = ui_mainview.offersDateEditor->date();
        day   = QString::number(date.day());
        month = QString::number(date.month());
        year  = QString::number(date.year());

        offersModel->setFilter(QString("offers.validuntilday='%1' && offers.validuntilmonth='%2' && offers.validuntilyear='%3'").arg(day).arg(month).arg(year));
    }
    else { //old offers
      QString day,month,year;
        QDate date = QDate::currentDate();
        day   = QString::number(date.day());
        month = QString::number(date.month());
        year  = QString::number(date.year());

        offersModel->setFilter(QString("validuntilday<%1 && validuntilmonth<%2 && validuntilyear<%3").arg(day).arg(month).arg(year));
        qDebug()<<offersModel->filter();
    }
  }
  else offersModel->setFilter(""); //show all offers...
  offersModel->select();
  //FIXME & TODO: implement and save on database, a begin date for discounts. To program a discount before it starts.
}


void squeezeView::usersViewOnSelected(const QModelIndex & index)
{
 if (db.isOpen()) {
    //getting data from model...
    const QAbstractItemModel *model = index.model();
    int row = index.row();
    QModelIndex indx = model->index(row, usersModel->fieldIndex("id"));
    int id = model->data(indx, Qt::DisplayRole).toInt();
    indx = model->index(row, usersModel->fieldIndex("username"));
    QString username = model->data(indx, Qt::DisplayRole).toString();
    indx = model->index(row, usersModel->fieldIndex("name"));
    QString name = model->data(indx, Qt::DisplayRole).toString();
    indx = model->index(row, usersModel->fieldIndex("address"));
    QString address = model->data(indx, Qt::DisplayRole).toString();
    indx = model->index(row, usersModel->fieldIndex("phone"));
    QString phone = model->data(indx, Qt::DisplayRole).toString();
    indx = model->index(row, usersModel->fieldIndex("phone_movil"));
    QString cell = model->data(indx, Qt::DisplayRole).toString();
    indx = model->index(row, usersModel->fieldIndex("photo"));
    QByteArray photoBA = model->data(indx, Qt::DisplayRole).toByteArray();
    indx = model->index(row, usersModel->fieldIndex("password"));
    QString oldPassword = model->data(indx, Qt::DisplayRole).toString();
    indx = model->index(row, usersModel->fieldIndex("salt"));
    QString oldSalt = model->data(indx, Qt::DisplayRole).toString();

    QPixmap photo;
    photo.loadFromData(photoBA);
    QString password;
    QString salt;

    //Launch Edit dialog
    UserEditor *userEditorDlg = new UserEditor(this);
    //Set data on dialog
    userEditorDlg->setId(id);
    userEditorDlg->setUserName(username);
    userEditorDlg->setRealName(name);
    userEditorDlg->setAddress(address);
    userEditorDlg->setPhone(phone);
    userEditorDlg->setCell(cell);
    userEditorDlg->setPhoto(photo);

    if (userEditorDlg->exec() ) {
      username = userEditorDlg->getUserName();
      name     = userEditorDlg->getRealName();
      address  = userEditorDlg->getAddress();
      phone    = userEditorDlg->getPhone();
      cell     = userEditorDlg->getCell();
      photo    = userEditorDlg->getPhoto();

      QByteArray bytes = Misc::pixmap2ByteArray(new QPixmap(photo));

      //PAssword
      if (!userEditorDlg->getNewPassword().isEmpty()) {
        QByteArray saltBA = Hash::getSalt();
        salt = QString(saltBA);
        QString pswdTmp = salt+userEditorDlg->getNewPassword();
        QByteArray passwdBA = pswdTmp.toLocal8Bit();
        password = Hash::password2hash(passwdBA);
      }
      else {
        password = oldPassword;
        salt = oldSalt;
      }

      //Modify data on mysql...
      if (!db.isOpen()) openDB();
      QSqlQuery query(db);
      query.prepare("UPDATE users SET photo=:photo, username=:uname, name=:name, address=:address, phone=:phone, phone_movil=:cell, salt=:salt, password=:pass  WHERE id=:code;");
      query.bindValue(":code", id);
      query.bindValue(":photo", bytes);
      query.bindValue(":uname", username);
      query.bindValue(":name", name);
      query.bindValue(":address", address);
      query.bindValue(":phone", phone);
      query.bindValue(":cell", cell);
      query.bindValue(":pass", password);
      query.bindValue(":salt", salt);
      if (!query.exec()) qDebug()<<"Error:" << query.lastError();

      usersModel->select();
    }
    delete userEditorDlg;
  }
}


void squeezeView::productsViewOnSelected(const QModelIndex &index)
{
 if (db.isOpen()) {
  //getting data from model...
    const QAbstractItemModel *model = index.model();
    int row = index.row();
    QModelIndex indx = model->index(row, productsModel->fieldIndex("code"));
    qulonglong id = model->data(indx, Qt::DisplayRole).toULongLong();
    indx = model->index(row, productsModel->fieldIndex("name"));
    QString name = model->data(indx, Qt::DisplayRole).toString();
    indx = model->index(row, productsModel->fieldIndex("price"));
    double price = model->data(indx, Qt::DisplayRole).toDouble();
    indx = model->index(row, productsModel->fieldIndex("stockqty"));
    double stockQty = model->data(indx, Qt::DisplayRole).toDouble();
    indx = model->index(row, productsModel->fieldIndex("cost"));
    double cost = model->data(indx, Qt::DisplayRole).toDouble();
    indx = model->index(row, productsModel->fieldIndex("soldunits"));
    double soldunits = model->data(indx, Qt::DisplayRole).toDouble();
    indx = model->index(row, productsModel->fieldIndex("datelastsold"));
    QString datelastsold = model->data(indx, Qt::DisplayRole).toString();
    indx = model->index(row, productsModel->fieldIndex("units"));
    int units = model->data(indx, Qt::DisplayRole).toInt();
    indx = model->index(row, productsModel->fieldIndex("taxpercentage"));
    double tax1 = model->data(indx, Qt::DisplayRole).toDouble();
    indx = model->index(row, productsModel->fieldIndex("extrataxes"));
    double tax2 = model->data(indx, Qt::DisplayRole).toDouble();
    indx = model->index(row, productsModel->fieldIndex("category"));
    int category = model->data(indx, Qt::DisplayRole).toInt();
    indx = model->index(row, productsModel->fieldIndex("points"));
    qulonglong points = model->data(indx, Qt::DisplayRole).toULongLong();
    indx = model->index(row, productsModel->fieldIndex("photo"));
    QByteArray photoBA = model->data(indx, Qt::DisplayRole).toByteArray();
    QPixmap photo;
    photo.loadFromData(photoBA);

    //Launch Edit dialog
    ProductEditor *productEditorDlg = new ProductEditor(this);
    //Set data on dialog
    productEditorDlg->disableCode(); //On Edit product, code cannot be changed.
    productEditorDlg->setDb(db);
    productEditorDlg->setCode(id);
    productEditorDlg->setDescription(name);
    productEditorDlg->setStockQty(stockQty);
    productEditorDlg->setPrice(price);
    productEditorDlg->setCost(cost);
    productEditorDlg->setMeasure(units);
    productEditorDlg->setTax1(tax1);
    productEditorDlg->setTax2(tax2);
    productEditorDlg->setCategory(category);
    productEditorDlg->setPhoto(photo);
    productEditorDlg->setPoints(points);

    qulonglong newcode=0;
    //Launch dialog, and if dialog is accepted...
    if (productEditorDlg->exec() ) {
      //get changed|unchanged values
      newcode      = productEditorDlg->getCode();
      name         = productEditorDlg->getDescription();
      stockQty     = productEditorDlg->getStockQty();
      price        = productEditorDlg->getPrice();
      cost         = productEditorDlg->getCost();
      units        = productEditorDlg->getMeasureId();
      tax1         = productEditorDlg->getTax1();
      tax2         = productEditorDlg->getTax2();
      category     = productEditorDlg->getCategoryId();
      points       = productEditorDlg->getPoints();
      photo        = productEditorDlg->getPhoto();
      QByteArray bytes = Misc::pixmap2ByteArray(new QPixmap(photo)); //Photo ByteArray

      //Update database
      if (!db.isOpen()) openDB();
      QSqlQuery query(db);
      query.prepare("UPDATE products SET code=:newcode, photo=:photo, name=:name, price=:price, stockqty=:stock, cost=:cost, soldunits=:soldunits, datelastsold=:lastsold, units=:measure, taxpercentage=:tax1, extrataxes=:tax2, category=:category, points=:points WHERE code=:id");
      query.bindValue(":id", id);
      query.bindValue(":newcode", newcode);
      query.bindValue(":photo", bytes);
      query.bindValue(":name",name);
      query.bindValue(":price",price);
      query.bindValue(":stock", stockQty);
      query.bindValue(":cost", cost);
      query.bindValue(":soldunits", soldunits);
      query.bindValue(":lastsold", datelastsold);
      query.bindValue(":measure", units);
      query.bindValue(":tax1", tax1);
      query.bindValue(":tax2", tax2);
      query.bindValue(":category",category);
      query.bindValue(":points", points);
      if (!query.exec()) qDebug()<<"Error:" << query.lastError();
      //TODO: Checar ofertas y cambiarlas/borrarlas
      if (id != newcode) {
        QSqlQuery q(db);
        QString qs = QString("UPDATE offers SET product_id=%2 WHERE product_id=%1;").arg(id).arg(newcode);
        qDebug()<<qs;
        if (!q.exec( qs )) {
          qDebug()<<"cannot update offer for product id:"<<id<<" to new id:"<<newcode;
        }
        else {
          qDebug()<<q.numRowsAffected();
        }
      }
      //FIXME: We must see error types, which ones are for duplicate KEYS (codes) to advertise the user.
      productsModel->select();
    }
    delete productEditorDlg;
  }
}

void squeezeView::clientsViewOnSelected(const QModelIndex & index)
{
  if (db.isOpen()) {
    //getting data from model...
    const QAbstractItemModel *model = index.model();
    int row = index.row();
    QModelIndex indx = model->index(row, clientsModel->fieldIndex("id"));
    int id = model->data(indx, Qt::DisplayRole).toInt();
    indx = model->index(row, clientsModel->fieldIndex("name"));
    QString name = model->data(indx, Qt::DisplayRole).toString();
    indx = model->index(row, clientsModel->fieldIndex("address"));
    QString address = model->data(indx, Qt::DisplayRole).toString();
    indx = model->index(row, clientsModel->fieldIndex("phone"));
    QString phone = model->data(indx, Qt::DisplayRole).toString();
    indx = model->index(row, clientsModel->fieldIndex("phone_movil"));
    QString cell = model->data(indx, Qt::DisplayRole).toString();
    indx = model->index(row, clientsModel->fieldIndex("points"));
    qulonglong points = model->data(indx, Qt::DisplayRole).toULongLong();
    indx = model->index(row, clientsModel->fieldIndex("discount"));
    double discount = model->data(indx, Qt::DisplayRole).toDouble();
    indx = model->index(row, clientsModel->fieldIndex("photo"));
    QByteArray photoBA = model->data(indx, Qt::DisplayRole).toByteArray();

    QPixmap photo;
    photo.loadFromData(photoBA);

    //Launch Edit dialog
    ClientEditor *clientEditorDlg = new ClientEditor(this);
    //Set data on dialog
    clientEditorDlg->setId(id);
    clientEditorDlg->setName(name);
    clientEditorDlg->setAddress(address);
    clientEditorDlg->setPhone(phone);
    clientEditorDlg->setCell(cell);
    clientEditorDlg->setPhoto(photo);
    clientEditorDlg->setPoints(points);
    clientEditorDlg->setDiscount(discount);

    if (clientEditorDlg->exec() ) {
      name     = clientEditorDlg->getName();
      address  = clientEditorDlg->getAddress();
      phone    = clientEditorDlg->getPhone();
      cell     = clientEditorDlg->getCell();
      photo    = clientEditorDlg->getPhoto();
      points   = clientEditorDlg->getPoints();
      discount = clientEditorDlg->getDiscount();

      QByteArray bytes = Misc::pixmap2ByteArray(new QPixmap(photo));

      //Modify data on mysql...
      if (!db.isOpen()) openDB();
      QSqlQuery query(db);
      query.prepare("UPDATE clients SET photo=:photo, name=:name, address=:address, phone=:phone, phone_movil=:cell, points=:points, discount=:disc  WHERE id=:code;");
      query.bindValue(":code", id);
      query.bindValue(":photo", bytes);
      query.bindValue(":points", points);
      query.bindValue(":disc", discount);
      query.bindValue(":name", name);
      query.bindValue(":address", address);
      query.bindValue(":phone", phone);
      query.bindValue(":cell", cell);
      if (!query.exec()) qDebug()<<"Error:" << query.lastError();

      clientsModel->select();
    }
    delete clientEditorDlg;
  }
}

void squeezeView::doPurchase()
{
  if (db.isOpen()) {
    QStringList items;
    items.clear();
    qDebug()<<"doPurchase...";
    PurchaseEditor *purchaseEditorDlg = new PurchaseEditor(this);
    purchaseEditorDlg->setDb(db);
    if (purchaseEditorDlg->exec()) {
      QHash<qulonglong, ProductInfo> hash = purchaseEditorDlg->getHash();
      ProductInfo info;
      //Iterate the hash
      QHashIterator<qulonglong, ProductInfo> i(hash);
      while (i.hasNext()) {
        i.next();
        info = i.value();
        //Modify data on mysql...
        if (!db.isOpen()) openDB();
        QSqlQuery query(db);
        //validDiscount is for checking if product already exists on db. see line # 396 of purchaseeditor.cpp
        if (info.validDiscount) qDebug()<<"product already on db...";
        if (info.validDiscount) query.prepare("UPDATE products SET photo=:photo, name=:name, price=:price, stockqty=:stock, cost=:cost, units=:measure, taxpercentage=:tax1, extrataxes=:tax2, category=:category, points=:points WHERE code=:id");
        else query.prepare("INSERT INTO products (code, name, price, stockqty, cost, units, taxpercentage, extrataxes, photo, category, points) VALUES (:id, :name, :price, :stock, :cost, :measure, :tax1, :tax2, :photo, :category, :points);");
        query.bindValue(":id", info.code);
        query.bindValue(":photo", info.photo);
        query.bindValue(":name", info.desc);
        query.bindValue(":price", info.price);
        double fq = info.purchaseQty+info.stockqty;
        query.bindValue(":stock", fq);
        query.bindValue(":cost", info.cost);
        query.bindValue(":measure", info.units);
        query.bindValue(":tax1", info.tax);
        query.bindValue(":tax2", info.extratax);
        query.bindValue(":category", info.category);
        query.bindValue(":points", info.points);
        if (!query.exec()) qDebug()<<"Error:" << query.lastError();
        productsModel->select();
        items.append(QString::number(info.code)+"/"+QString::number(info.purchaseQty));
        }
        //Now add a transaction for buy
        QDateTime datetime = QDateTime::currentDateTime();
        QString day, month, year, hour, minute;
        day    = datetime.toString("d");
        month  = datetime.toString("M");
        year   = datetime.toString("yyyy");
        hour   = datetime.toString("h");
        minute = datetime.toString("m");
        QSqlQuery query2(db);
        query2.prepare("INSERT INTO transactions (type, amount, day, month, year, hour, minute, paidwith, changegiven, paymethod, state, userid, cardnumber, itemcount, itemslist, cardauthnumber, utility, terminalnum) VALUES (:type, :amount, :day, :month, :year, :hour, :minute, :paidwith, :changegiven, :paymethod, :state, :userid, :cardnumber, :itemcount, :itemslist, :cardauthnumber, :utility, :terminalnum)");
        query2.bindValue(":type", tBuy);
        query2.bindValue(":amount", purchaseEditorDlg->getTotalBuy());
        query2.bindValue(":day", day);
        query2.bindValue(":month", month);
        query2.bindValue(":year", year);
        query2.bindValue(":hour", hour);
        query2.bindValue(":minute", minute);
        query2.bindValue(":paidwith",0.0 );
        query2.bindValue(":changegiven", 0.0);
        query2.bindValue(":paymethod", pCash);
        query2.bindValue(":state", tCompleted);
        query2.bindValue(":userid", 1);//FIXME...
        query2.bindValue(":cardnumber", "-NA-");
        query2.bindValue(":itemcount", purchaseEditorDlg->getItemCount());
        query2.bindValue(":itemslist", items.join(";"));
        query2.bindValue(":cardauthnumber","-NA-");
        query2.bindValue(":utility", 0);
        query2.bindValue(":terminalnum", 0);
        if (!query2.exec() ) {
          int errNum = query2.lastError().number();
          QSqlError::ErrorType errType = query2.lastError().type();
          QString errStr = query2.lastError().text();
          QString details = i18n("Error #%1, Type:%2\n'%3'",QString::number(errNum), QString::number(errType),errStr);
          KMessageBox::detailedError(this, i18n("Squeeze has encountered an error when querying the database, click details to see the error details."), details, i18n("Error"));
      }
    }
  }
}

void squeezeView::createUser()
{
  if (db.isOpen()) {
    UserEditor *userEditorDlg = new UserEditor(this);
    QString username,name,address,phone,cell;
    QPixmap photo;

    if (userEditorDlg->exec() ) {
      username = userEditorDlg->getUserName();
      name     = userEditorDlg->getRealName();
      address  = userEditorDlg->getAddress();
      phone    = userEditorDlg->getPhone();
      cell     = userEditorDlg->getCell();
      photo    = userEditorDlg->getPhoto();

      QByteArray bytes = Misc::pixmap2ByteArray(new QPixmap(photo));

      QByteArray saltBA = Hash::getSalt();
      QString salt = QString(saltBA);
      QString pswdTmp = salt+userEditorDlg->getNewPassword();
      QByteArray passwdBA = pswdTmp.toLocal8Bit();
      QString password = Hash::password2hash(passwdBA);

      if (!db.isOpen()) openDB();
      QSqlQuery query(db);
      query.prepare("INSERT INTO users (username, password, salt, name, address, phone, phone_movil, photo) VALUES(:uname, :pass, :salt, :name, :address, :phone, :cell, :photo)");
      query.bindValue(":photo", bytes);
      query.bindValue(":uname", username);
      query.bindValue(":name", name);
      query.bindValue(":address", address);
      query.bindValue(":phone", phone);
      query.bindValue(":cell", cell);
      query.bindValue(":pass", password);
      query.bindValue(":salt", salt);
      if (!query.exec()) qDebug()<<"Error:" << query.lastError();
      //FIXME: We must see error types, which ones are for duplicate KEYS (codes) to advertise the user.

      usersModel->select();
    }
    delete userEditorDlg;
  }
}

void squeezeView::createOffer()
{
  if (db.isOpen()) {
    PromoEditor *promoEditorDlg = new PromoEditor(this);
    promoEditorDlg->setDb(db);
    if (promoEditorDlg->exec() ) {

      int day,month,year;
      QDate date = promoEditorDlg->getDate();
      day   = date.day();
      month = date.month();
      year  = date.year();

      if (!db.isOpen()) openDB();
      QSqlQuery query(db);
      query.prepare("INSERT INTO offers (discount,validuntilday,validuntilmonth,validuntilyear,product_id) VALUES(:discount, :day, :month, :year, :code)");
      query.bindValue(":discount", promoEditorDlg->getDiscount());
      query.bindValue(":day", day);
      query.bindValue(":month", month);
      query.bindValue(":year", year);
      query.bindValue(":code", promoEditorDlg->getSelectedProductCode());
      if (!query.exec()) qDebug()<<"Error:" << query.lastError();

      offersModel->select();
    }
    delete promoEditorDlg;
  }
}

void squeezeView::createProduct()
{
 if (db.isOpen()) {
  ProductEditor *prodEditorDlg = new ProductEditor(this);
  prodEditorDlg->setDb(db);
  prodEditorDlg->enableCode();
  qulonglong newcode = 0;

  if (prodEditorDlg->exec()) {
    int resultado = prodEditorDlg->result();

    newcode = prodEditorDlg->getCode();
    if (!db.isOpen()) openDB();
    QSqlQuery query(db);
    //This switch is for the new feature: When adding a new product, if entered code exists, it will be edited. to save time...
    switch (resultado) {
      case QDialog::Accepted:
      case statusNormal:
        query.prepare("INSERT INTO products (code, name, price, stockqty, cost, soldunits, datelastsold, units, taxpercentage, extrataxes, photo, category, points) VALUES (:code, :name, :price, :stock, :cost, :soldunits, :lastsold, :units, :tax1, :tax2, :photo, :category, :points);");
        query.bindValue(":code", newcode);
        query.bindValue(":name", prodEditorDlg->getDescription());
        query.bindValue(":price", prodEditorDlg->getPrice());
        query.bindValue(":stock", prodEditorDlg->getStockQty());
        query.bindValue(":cost", prodEditorDlg->getCost());
        query.bindValue(":soldunits", 0);
        query.bindValue(":lastsold", "Never");
        query.bindValue(":units", prodEditorDlg->getMeasureId());
        query.bindValue(":tax1", prodEditorDlg->getTax1());
        query.bindValue(":tax2", prodEditorDlg->getTax2());
        query.bindValue(":photo", Misc::pixmap2ByteArray(new QPixmap(prodEditorDlg->getPhoto())));
        query.bindValue(":category", prodEditorDlg->getCategoryId());
        query.bindValue(":points", prodEditorDlg->getPoints());
        if (!query.exec()) qDebug()<<"Error:" << query.lastError();
        productsModel->select();
      break;
      case statusMod:
        query.prepare("UPDATE products SET photo=:photo, name=:name, price=:price, stockqty=:stock, cost=:cost, units=:measure, taxpercentage=:tax1, extrataxes=:tax2, category=:category, points=:points WHERE code=:id");
        query.bindValue(":id", newcode);
        query.bindValue(":photo", Misc::pixmap2ByteArray(new QPixmap(prodEditorDlg->getPhoto())));
        query.bindValue(":name", prodEditorDlg->getDescription());
        query.bindValue(":price", prodEditorDlg->getPrice());
        query.bindValue(":stock", prodEditorDlg->getStockQty());
        query.bindValue(":cost", prodEditorDlg->getCost());
        query.bindValue(":measure", prodEditorDlg->getMeasureId());
        query.bindValue(":tax1", prodEditorDlg->getTax1());
        query.bindValue(":tax2", prodEditorDlg->getTax2());
        query.bindValue(":category",prodEditorDlg->getCategoryId());
        query.bindValue(":points", prodEditorDlg->getPoints());
        if (!query.exec()) qDebug()<<"Error:" << query.lastError();
        productsModel->select();
      break;
      case QDialog::Rejected:
      default:
      break;
    }
  }
 }
}

void squeezeView::createMeasure()
{
 if (db.isOpen()) {
    int row = ui_mainview.tableMeasures->currentIndex().row();
    if (row==-1) row=0;
    if (ui_mainview.stackedWidget->currentIndex() != pBrowseMeasures)
      ui_mainview.stackedWidget->setCurrentIndex(pBrowseMeasures);
    if (measuresModel->tableName().isEmpty()) setupMeasuresModel();

    measuresModel->insertRow(row);
  }
}

void squeezeView::createCategory()
{
  if (db.isOpen()) {
    int row = ui_mainview.tableCategories->currentIndex().row();
    if (row==-1) row=0;
    if (ui_mainview.stackedWidget->currentIndex() != pBrowseCategories)
      ui_mainview.stackedWidget->setCurrentIndex(pBrowseCategories);
    if (categoriesModel->tableName().isEmpty()) setupCategoriesModel();

    categoriesModel->insertRow(row);
 }
}

void squeezeView::createClient()
{
  if (db.isOpen()) {
    ClientEditor *clientEditorDlg = new ClientEditor(this);
    QString name,address,phone,cell;
    double discount=0;
    qulonglong points;
    QPixmap photo;

    if (clientEditorDlg->exec() ) {
      name     = clientEditorDlg->getName();
      address  = clientEditorDlg->getAddress();
      phone    = clientEditorDlg->getPhone();
      cell     = clientEditorDlg->getCell();
      photo    = clientEditorDlg->getPhoto();
      points   = clientEditorDlg->getPoints();
      discount = clientEditorDlg->getDiscount();

      QByteArray bytes = Misc::pixmap2ByteArray(new QPixmap(photo));
      if (!db.isOpen()) openDB();
      QSqlQuery query(db);
      query.prepare("INSERT INTO clients (name, address, phone, phone_movil, points, discount, photo) VALUES(:name, :address, :phone, :cell,:points, :discount, :photo)");
      query.bindValue(":photo", bytes);
      query.bindValue(":points", points);
      query.bindValue(":discount", discount);
      query.bindValue(":name", name);
      query.bindValue(":address", address);
      query.bindValue(":phone", phone);
      query.bindValue(":cell", cell);
      if (!query.exec()) qDebug()<<"Error:" << query.lastError();
      //FIXME: We must see error types, which ones are for duplicate KEYS (codes) to advertise the user.

      clientsModel->select();
    }
    delete clientEditorDlg;
  }
}

void squeezeView::deleteSelectedClient()
{
  if (db.isOpen()) {
    QModelIndex index = ui_mainview.clientsView->currentIndex();
    if (clientsModel->tableName().isEmpty()) setupClientsModel();
    if (index == clientsModel->index(-1,-1) ) {
      KMessageBox::information(this, i18n("Please select a client to delete, then press the delete button again."), i18n("Cannot delete"));
    }
    else  {
      QString uname = clientsModel->record(index.row()).value("name").toString();
      qulonglong clientId = clientsModel->record(index.row()).value("id").toULongLong();
      if (clientId > 1) {
        int answer = KMessageBox::questionYesNo(this, i18n("Do you really want to delete the client named %1?",uname),
                                              i18n("Delete"));
        if (answer == KMessageBox::Yes) {
          clientsModel->removeRow(index.row());
          clientsModel->submitAll();
          clientsModel->select();
        }
    } else KMessageBox::information(this, i18n("Default client cannot be deleted."), i18n("Cannot delete"));
   }
 }
}

void squeezeView::deleteSelectedUser()
{
  if (db.isOpen()) {
    QModelIndex index = ui_mainview.usersView->currentIndex();
    if (usersModel->tableName().isEmpty()) setupUsersModel();
    if (index == usersModel->index(-1,-1) ) {
      KMessageBox::information(this, i18n("Please select a user to delete, then press the delete button again."), i18n("Cannot delete"));
      //TODO: Present a dialog to select which user to delete...
    }
    else  {
      QString uname = usersModel->record(index.row()).value("name").toString();
      int answer = KMessageBox::questionYesNo(this, i18n("Do you really want to delete the user named %1?",uname),
                                              i18n("Delete"));
      if (answer == KMessageBox::Yes) {
        usersModel->removeRow(index.row());
        usersModel->submitAll();
        usersModel->select();
      }
   }
 }
}

void squeezeView::deleteSelectedOffer()
{
  if (db.isOpen()) {
    QModelIndex index = ui_mainview.tableBrowseOffers->currentIndex();
    if (offersModel->tableName().isEmpty()) setupOffersModel();
    if (index == offersModel->index(-1,-1) ) {
      //FIXME: Hey, I think the word "offer" does not mean what i mean... (special..)
      KMessageBox::information(this, i18n("Please select an offer to delete, then press the delete button again."), i18n("Cannot delete"));
      //TODO: Present a dialog to select which user to delete...
    }
    else  {
      int answer = KMessageBox::questionYesNo(this, i18n("Do you really want to delete the selected discount?"),
                                              i18n("Delete"));
      if (answer == KMessageBox::Yes) {
        offersModel->removeRow(index.row());
        offersModel->submitAll();
        offersModel->select();
      }
    }
  }
}

void squeezeView::deleteSelectedProduct()
{
  if (db.isOpen()) {
    QModelIndex index = ui_mainview.productsView->currentIndex();
    if (productsModel->tableName().isEmpty()) setupProductsModel();
    if (index == productsModel->index(-1,-1) ) {
      KMessageBox::information(this, i18n("Please select a product to delete, then press the delete button."), i18n("Cannot delete"));
    }
    else  {
      int answer = KMessageBox::questionYesNo(this, i18n("Do you really want to delete the selected product?"),
                                              i18n("Delete"));
      if (answer == KMessageBox::Yes) {
        productsModel->removeRow(index.row());
        productsModel->submitAll();
        productsModel->select();
      }
    }
  }
}

void squeezeView::deleteSelectedMeasure()
{
  if (db.isOpen()) {
    QModelIndex index = ui_mainview.tableMeasures->currentIndex();
    if (measuresModel->tableName().isEmpty()) setupMeasuresModel();
    if (index == measuresModel->index(-1,-1) ) {
      KMessageBox::information(this, i18n("Please select a row to delete, then press the delete button again."), i18n("Cannot delete"));
    }
    else  {
      qulonglong measureId = clientsModel->record(index.row()).value("id").toULongLong();
      if (measureId > 1) {
        int answer = KMessageBox::questionYesNo(this, i18n("Do you really want to delete the selected row?"),
                                                i18n("Delete"));
        if (answer == KMessageBox::Yes) {
          measuresModel->removeRow(index.row());
          measuresModel->submitAll();
          measuresModel->select();
        }
      } else KMessageBox::information(this, i18n("Default measure cannot be deleted."), i18n("Cannot delete"));
    }
  }
}

void squeezeView::deleteSelectedCategory()
{
  if (db.isOpen()) {
    QModelIndex index = ui_mainview.tableCategories->currentIndex();
    if (categoriesModel->tableName().isEmpty()) setupCategoriesModel();
    if (index == offersModel->index(-1,-1) ) {
      KMessageBox::information(this, i18n("Please select a category to delete, then press the delete button again."), i18n("Cannot delete"));
    }
    else  {
      int answer = KMessageBox::questionYesNo(this, i18n("Do you really want to delete the selected category?"),
                                              i18n("Delete"));
      if (answer == KMessageBox::Yes) {
        categoriesModel->removeRow(index.row());
        categoriesModel->submitAll();
        categoriesModel->select();
      }
    }
  }
}

#include "squeezeview.moc"
