/***************************************************************************
 *   Copyright (C) 2007 by Miguel Chavez Gamboa                            *
 *   miguel.chavez.gamboa@gmail.com                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *

 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef _InputDialog_H_
#define _InputDialog_H_

#include <QtGui>

enum DialogType       {dialogMoney=0, dialogMeasures=1, dialogTicket=3};

class InputDialog : public QDialog
{
  Q_OBJECT
  private:
    QHBoxLayout *titleLayout;
    QVBoxLayout *vLayout;
    QHBoxLayout *buttonsLayout;
    QLineEdit   *lineEdit;
    QLabel      *label;
    QLabel      *lPixmap;
    QPushButton *buttonAccept;
    QPushButton *buttonCancel;

  public:
    InputDialog(QWidget *parent=0L, bool integer=true, DialogType type=dialogMoney, QString msg="", double min=0.001, double max=100000000.0);
    virtual void paint(QPainter *);
    double dValue;
    int    iValue;
  protected slots:
    void acceptIt();
  protected:
    void paintEvent(QPaintEvent *e);
};

#endif
