/*
 * This file is part of Licq, an instant messaging client for UNIX.
 * Copyright (C) 1999-2010 Licq developers
 *
 * Licq is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Licq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Licq; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdio.h>
#include <locale.h>
#include <unistd.h>

#include <licq/pluginbase.h>

#include "console.h"
#include "pluginversion.h"

CLicqConsole *licqConsole;

const char *LP_Usage()
{
  static const char usage[] =
      "Usage:  Licq [ options ] -p console\n";
  return usage;
}

const char *LP_Name()
{
  static const char name[] = "Console";
  return name;
}


const char *LP_Version()
{
  static const char version[] = PLUGIN_VERSION_STRING;
  return version;
}

const char *LP_Status()
{
  static const char status[] = "running";
  return status;
}

const char *LP_Description()
{
  static const char desc[] = "Console plugin based on ncurses";
  return desc;
}

const char *LP_ConfigFile()
{
  return "licq_console.conf";
}

bool LP_Init(int argc, char **argv)
{
  //char *LocaleVal = new char;
  //LocaleVal = setlocale (LC_ALL, "");
  //bindtextdomain (PACKAGE, LOCALEDIR);
  //textdomain (PACKAGE);
  setlocale(LC_ALL, "");

  // parse command line for arguments
  int i = 0;
  while( (i = getopt(argc, argv, "h")) > 0)
  {
    switch (i)
    {
    case 'h':  // help
      puts(LP_Usage());
      return false;
    }
  }
  licqConsole = new CLicqConsole(argc, argv);
  return (licqConsole != NULL);
}


int LP_Main()
{
  int nResult = licqConsole->Run();
  licqConsole->Shutdown();
  delete licqConsole;
  return nResult;
}


