/***********************************************************************************

	Copyright (C) 2007-2008 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_DATA_HEADER
#define LIFEOGRAPH_DATA_HEADER

//typedef void (*LIFEOFUNCVOIDVOID) (void);

namespace LIFEO {
	enum RESULT {	OK,
					ABORTED,
					SUCCESS,
					FAILURE,
					COULD_NOT_START,
					COULD_NOT_FINISH,
					WRONG_PASSWORD,
                    APPEARENTLY_ENCRYTED_FILE,
                    APPEARENTLY_PLAIN_FILE,
                    INCOMPATIBLE_FILE,
                    EMPTY_DATABASE
                     };
    const char  DB_FILE_HEADER[] = "RZNMDB"; // sole remnant of the old name
    const int   DB_FILE_VERSION_INT(37);
    const int   DB_FILE_VERSION_INT_MIN(34); // minimum version that can be read
	const std::string::size_type	PASSPHRASE_MIN_SIZE(4);
}

/*
class LIFEODATETYPE {


};

class LIFEODATE : public LIFEODATETYPE {
	public:
		int	Year;
		int	Month;
		int	Day;
};
*/

class LIFEOENTRY {
	public:
							LIFEOENTRY ();
							LIFEOENTRY (unsigned int, unsigned int,
                                        unsigned int, const std::string&);

		const std::string&	get_text () const {
			return (Text);
		}
		void				set_text (const std::string& n_text) {
			Text = n_text;
		}

		const std::string	get_title () const {
			if (Text.size() < 1)
				return ("untitled");
			unsigned int l_pos = Text.find('\n', 0);
			if (l_pos == std::string::npos)
				return (Text);

			//std::string l_str;

			return (Text.substr(0, l_pos));

		}
		const std::string	get_date_str (void) const;

        bool                get_filtered_out (void) const {
            return FilteredOut;
        }
        void                set_filtered_out (bool l_filteredOut = true) {
            FilteredOut = l_filteredOut;
        }

		unsigned int		get_day () const {
			return Day;
		}
		unsigned int		get_month () const {
			return Month;
		}
		unsigned int		get_year () const {
			return Year;
		}

	    bool                is_favored (void) const {
            return Favored;
        }
        void                make_favored (void) {
            Favored=true;
        }
        void                make_unfavored (void) {
            Favored=false;
        }

    
    protected:
		unsigned int			Year, Month, Day;
		std::string				Text;
        bool                    Favored;

        bool                    FilteredOut;

	private:

};

typedef std::vector<LIFEOENTRY>::iterator LIFEOENTRYITER;



class LIFEODATA {
	public:
							LIFEODATA (void);

        int                 get_todays_first_entry (void);
                            // adds a new entry to today even if there is already one or more
		int 				add_today (void);

	// DISK I/O
		LIFEO::RESULT		read_body (void);
        LIFEO::RESULT       read_header (void);

		LIFEO::RESULT		write (const std::string& = ""); // do according to OptionPlainDB
		LIFEO::RESULT		write (bool, const std::string& = ""); // do according to variable
		LIFEO::RESULT		write_plain (const std::string& = "", bool = false);
		LIFEO::RESULT		write_encrypted (const std::string& = "");

        void                clear (void);

		int					get_size() const {
			return (Entry.size());
		}

		void				set_path (const std::string&);
		const std::string&	get_path (void) const;
        bool                is_path_set (void) const;

		void				set_passphrase (const std::string&);
		std::string			get_passphrase (void) const;
		bool				compare_passphrase (const std::string&) const;
		bool				is_passphrase_set (void) const;

		int					get_entry (unsigned int, unsigned int, unsigned int);
		const LIFEOENTRY&	get_entry (int) const;
		LIFEOENTRY&         get_entry (int);
		bool				add_entry (const LIFEOENTRY&);
		int					create_entry (unsigned int, unsigned int,
                                          unsigned int, const std::string& = "");
		bool				delete_entry (const LIFEOENTRYITER&);
		bool				delete_entry (int);
		int					list_entries (void);

		int					set_filter (const std::string&);
		void                remove_filter (void);

		//void				do_for_each_entry (LIFEOFUNCVOIDVOID);

	protected:
		std::vector<LIFEOENTRY>     Entry;
		std::string					Path;
		std::string					Passphrase;

        LIFEO::RESULT               parse_db_body_text (std::stringstream&);
        bool                        create_db_body_text (std::stringstream&);
        bool                        create_db_header_text (std::stringstream&, bool);
		LIFEO::RESULT 				read_encrypted (void);
		LIFEO::RESULT 				read_plain (void);
        
        std::ios::pos_type          BodyPosition;

	private:
		// options
		bool				        OptionPlainDB;

	friend class LIFEOGRAPH;
};

#endif
