/***********************************************************************************

	Copyright (C) 2007-2008 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#include <gtkmm/main.h>

#include "lifeograph.hpp"


int main (int argc, char *argv[]) {
    // LIBGETTEXT REQUIREMENTS
    setlocale (LC_ALL, "");
    bindtextdomain (PACKAGE, LOCALEDIR);
    textdomain (PACKAGE);

	Gnome::Conf::init();
	Gtk::Main kit(argc, argv);

	Glib::set_application_name(LIFEO::PROGRAM_NAME);

    {
        std::string l_pathIcon(PIXMAPDIR "/lifeograph.png");
        bool l_iconFound(true);
    if (!Glib::file_test(l_pathIcon, Glib::FILE_TEST_EXISTS)) {
        l_pathIcon = argv[0];
        l_pathIcon += ".png";
        if (!Glib::file_test(l_pathIcon, Glib::FILE_TEST_EXISTS))
            l_iconFound=false;
	}
    if (l_iconFound)
        Gtk::Window::set_default_icon_from_file(l_pathIcon);
    }
    
    LIFEOGRAPH Lifeograph(argc, argv);

	Lifeograph.run();

	return 0;
}
