/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_WIDGET_PANEL_EXPANDABLE_HEADER
#define LIFEOGRAPH_WIDGET_PANEL_EXPANDABLE_HEADER


#include "diary.hpp"
#include "views.hpp"


namespace LIFEO
{

class ColrecTheme : public Gtk::TreeModel::ColumnRecord
{
	public:
		ColrecTheme()
		{
			add( m_icon );
			add( m_name );
			add( m_ptr );
		}

		Gtk::TreeModelColumn< Glib::RefPtr< Gdk::Pixbuf > >	m_icon;
		Gtk::TreeModelColumn< Glib::ustring >				m_name;
		Gtk::TreeModelColumn< Theme* >						m_ptr;
};

class WidgetPanelExp
{
	public:
									WidgetPanelExp( void );

		void						populate_themes( void );

	protected:
		void						handle_drag_begin(
											const Glib::RefPtr< Gdk::DragContext >& );
		void						handle_drag_data_get( const Glib::RefPtr<Gdk::DragContext>&,
														  Gtk::SelectionData&,
														  guint, guint );

		void						handle_button_press_themes( GdkEventButton* );
		void						handle_button_release_themes( GdkEventButton* );

		void						show_widget( Gtk::Widget*, Gtk::Arrow* );

		//Gtk::Expander				*m_expander_todos;	// TODO
		Gtk::Button					*m_expander_tags;
		Gtk::Button					*m_expander_themes;

		Gtk::Widget					*m_widget_tags;
		Gtk::Widget					*m_widget_themes;

		Gtk::Arrow					*m_arrow_tags;
		Gtk::Arrow					*m_arrow_themes;

		Gtk::Widget					*m_cur_widget;

		Gtk::TreeView				*m_treeview_themes;
		Glib::RefPtr< Gtk::ListStore >
									m_liststore_themes;
		ColrecTheme					colrec_theme;

		bool						m_flag_dragging;
		Theme						*m_theme_dragged;
};


} // end of namespace LIFEO

#endif
