/****************************************************************************
**
** $Id: directory.h,v 1.88 2004/04/25 23:20:21 riemer Exp $
**
** Copyright (C) 1999-2004 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Frank Hemer <frank@hemer.org>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Tom Mishima <tmishima@mail.at-m.or.jp>
**    Joerg Preiss <auba@auba.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/


#ifndef DIRECTORY_H_20010626
#define DIRECTORY_H_20010626

//----------------------------------------------------------------------------

#include "config.h"


#include <qlistview.h>
#include <qfileinfo.h>
#include <qdict.h>
#include <qtextedit.h>

#include "CommandInterface.h"
#include "FileListViewItem.h"
#include "qstringlist.h"

class CvsBuffer;

//----------------------------------------------------------------------------

class CmdThread;
class Directory;
class NonCvsListView;
class CvsIgnoreListView;
class CvsListView;
class CCvsOutput;

//----------------------------------------------------------------------------
struct Revision {
  QString string;
  bool missing;
};

struct Date {
  QString string;
  QDateTime datetime;
  QDateTime localdatetime;
  QDate date;
  QTime time;
  bool dummy;
  bool newDummy;
  bool conflict;
};

struct Option {
  QString string;
  bool b;
  bool o;
  bool v;
};

struct Sticky {
  QString string;
  bool T;
  bool D;
};

struct CVSEntries {
  QString name;
  Revision rev;
  Date date;
  Option option;
  Sticky sticky;
};

enum EntryStates_E {
    ES_unknown                                    =  0,
    ES_probably_up_to_date                        =  1,
    ES_probably_up_to_date_and_timezone_incorrect =  2,
    ES_up_to_date                                 =  3,
    ES_noncvs                                     =  4,
    ES_modified                                   =  5,
    ES_added                                      =  6,
    ES_removed                                    =  7,
    ES_needs_patch                                =  8,
    ES_needs_merge                                =  9,
    ES_needs_checkout                             = 10,
    ES_missing                                    = 11,
    ES_missing_dir                                = 12, 
    ES_conflict                                   = 13
};
typedef enum EntryStates_E EntryStates;

//----------------------------------------------------------------------------

class Entry
{
public:
   Entry(const QString& fileName, EntryStates state, Directory * Dir ) 
   {
      m_fileName = fileName;
      m_state = ES_unknown;
      myDirectory = Dir;
      setState( state );
   }

   void setState( EntryStates s );
   Directory * getDirectory() { return myDirectory; }
   
   QString fileName() {return m_fileName;}
   EntryStates state() {return m_state;}
   
protected:
   QString m_fileName;
   Directory * myDirectory;
   EntryStates m_state;
};


class CCvsCommand;


class Directory : public QListViewItem, CommandInterface
{

  static const bool VIRTUAL;

 public:
 
   Directory( 
     QListView * parent, 
     QStringList,
     const QString& fileName, 
     CvsListView * CvsFileListView,
     NonCvsListView * NonCvsFileListView,
     CvsIgnoreListView * CvsIgnoreFileListView);
   Directory( 
     QListViewItem * parent, 
     const QString& fileName, 
     CvsListView * CvsFileListView,
     NonCvsListView * NonCvsFileListView,
     CvsIgnoreListView * CvsIgnoreFileListView,
     bool virtualDir=false);

   virtual ~Directory();

   void connect( QObject *, const char *);

   virtual int rtti()const;
   virtual int compare ( QListViewItem *, int, bool) const;
   Directory * parent();

   // set open this item and all items above it
   void setAllOpen( );
   void expandAllDir();
   void collapsAllDir();
   void analyzeAll();
   
   QString fullName() {return m_fullName;}
   QString shortName();
   QString relativeName();
   Directory * topDir();
   Directory * topCvsDir();
   QString rootDir() {return m_rootDir;}
   QString repository() {return m_repository;}
   QString userName() {return m_userName;}
   QString host() {return m_host;}
   int port() {return m_port;}
   QString connectMethod() {return m_connectMethod;}
   QString getDirTag() {return m_dirTag;}
   QString getCvsRoot() {return m_cvsRoot;}

   bool haveCvsDir() {return m_haveCvsDir || m_subDirHasCvsDir;}
   bool isCvsControlled() {return m_haveCvsDir;}
/*    bool analyzeDirs( bool onTheFly); */
   bool isAnalyzed() {return m_isAnalyzedDir;}
   bool isDisabled() {return m_disabled;}
   bool isVirtual() {return m_virtual;}
   QStringList* getSubProjectList() {return &m_subProjectList;}
   QStringList* getDisabledList() {return &m_disabledList;}
   QString getLastError() {return m_lastErrorMsg;}
   bool hasDisabled();
   bool isModified();
   bool isFilesModified();

   //functions telling about cvs file state
   bool isCvsRegistered(QString);
   bool isBinary(QString);

   Directory * addDir(QString newDir,bool addVirtual=false);
   void updateDisabledList(QStringList&);
   void updateSubProjectList(QStringList&);

   //setze alle in m_curCvsUpdateFileList enthaltenen files auf uptodate
   void setFilesToUpToDate(QStringList& updateFileList);   
   void fillFileListWithEntries(QStringList& fileList);
   void fillFileListWithFullNameEntries(QStringList& fileList);
   
   void activateItem(bool);
   void setAndAppendEntry(QString&, EntryStates);
   bool setAndAppendTmpEntryQueryUpdate(QString); //special case for query-update files missing and not in CVS/Entries
   void setAllToUpToDate();
   void recCheckForModifications(bool);
   void validateCvsFilesStatus(bool recursive = false, bool forceCacheReset = false, bool forceEntriesReset = false);
   void checkAndShowStatus(FileListViewItem *item = 0, bool checkOnly = false, bool resetCache = false);   //0 --> for all entries
   void checkAndUpdateFileCache(QString&);
   bool removeFromFileCache(QString&);
   void removeTmpEntries(QString name=QString::null);
   void recRemoveTmpEntries(bool);
   void recGetOpenDirsStringList(QStringList&);

   Directory* searchDirOfRepository(QString repository);
   Directory* searchDirOfPath(QString path, bool findVirtual = false);
   Directory* searchLastValidDirOfPath(QString path);

   bool loginOk(CCvsOutput*,bool showMessage = false);
   void removeLogin(CCvsOutput*);
   bool entriesFileModified();
   bool entriesLogFileModified();

   // state bubble up
   void setState( EntryStates, bool fromChild = false);
   void setDirIcon();
   void checkNonCvsFilesDirState();
   void resetState( void );

   // keep to accelerate setState()
   EntryStates get_ES_Max();
   void set_ES_Max(EntryStates);
   void calc_ES_Max();
   void calcDirChilds_ES_Max();

   bool parseCvsCallResult(CvsBuffer*, int, QStringList *stringList = 0);
   void afterCall(int,CvsBuffer*,bool);

   bool setEntry(QString&, EntryStates);
   EntryStates getState(QString);

   Directory * reloadChild(QString); //remove and reinsert Dir with all its subdirs without rereading the whole project
   virtual void setOpen( bool);
   void setOpen(bool,QString &);
   void removeChild( Directory*);

   bool checkCvsDir();
   bool execute(CCvsCommand &);
   bool unexecute(CCvsCommand &);

   void setAutoUpdate(bool);

   bool recCopyTree(QString,QString,bool deleteSource=FALSE);
   bool recCopyCvsFiles(QString);
   bool copyFile(QString,QString,int,bool deleteSource=FALSE);

   bool recRemoveUnregisteredFiles(QString &);

   void setCvsCallTime(QDateTime &);

protected:

   int isTreeEmpty( void );
   void recResetState( void );
   bool recAnalyzeAll();

   void init(const QString& fileName, 
	     CvsListView * CvsFileListView,
	     NonCvsListView * NonCvsFileListView,
	     CvsIgnoreListView * CvsIgnoreFileListView);

   static bool checkValidCvsDir( QString & path );
   void activate();

   void removeEntry(QString&);
   void appendEntry(QString&, Entry*);
   EntryStates alignWithEntries(QString name, EntryStates stateId);
   FileListViewItem * setStatusInFileListView(FileListViewItem *item, CVSEntries *cvsEntry, bool checkOnly = false);
   virtual void paintCell( QPainter *p, const QColorGroup &cg,
                            int column, int width, int alignment );
  
   char * getUnchangedPix(QFileInfo & info);                                    

   QString     m_fullName;
   bool        m_disabled;
   bool        m_readable;
   bool        m_haveCvsDir;
   bool        m_subDirHasCvsDir;
   bool        m_isAnalyzedDir;
   CvsListView  *m_pCvsFileListView;
   NonCvsListView  *m_pNonCvsFileListView;
   CvsIgnoreListView *m_pCvsIgnoreFileListView;
   bool        m_activatingIsNecessary;
   
   QString     m_cvsRoot;
   QString     m_connectMethod;
   QString     m_userName;
   QString     m_passwd;
   QString     m_host;
   int         m_port;
   QString     m_rootDir;
   QString     m_repository;
   QString     m_dirTag;
   
   QDict<Entry> m_entries;
   QDateTime   m_modTimeOfEntries;
   QDateTime   m_modTimeOfEntriesLog;
   
   QDict<bool> m_ignoreFiles;
   QDict<bool> m_nonCvsFiles;
   QDateTime   m_modTimeOfIgnores;

   QString m_curCvsRepository;
   EntryStates m_curCvsState;

   // cache state for acceleration
   EntryStates m_curCvsStateMax;
   EntryStates m_curCvsDirStateMax;

 private:

   bool analyzeDirs( bool onTheFly);
   void setStatusText( const QString &, int ms=0);
   void removeChild( QString);
   static const QString getHomeFilesToIgnore(QDateTime&, bool&);
   const QString getDirFilesToIgnore(const QString, bool&);
   bool updateFileCacheAndCheckForIgnores(const QString, QString&, bool, bool&);

   QDateTime m_lastModTimeOfDir;
   QDateTime m_lastCvsCallTime;

   QDateTime m_lastTimeHomeIgnoresChanged;
   QDateTime m_lastTimeDirIgnoresChanged;
   QString m_pDirIgnores;
   bool m_checkedForIgnoresFile;

   bool getDisabled(QString filename);

   bool recExecute(CCvsCommand &);
   bool recUnexecute(CCvsCommand &);

   QDict<CVSEntries> m_CVSEntries; // all CVS/Entries cached for acceleration
   QDict<CVSEntries>* getCVSEntries( bool forceCacheReset = false);
   bool m_entriesCached;

   Directory* m_topDir;//topdir of project
   bool m_isSubProjectRoot;
   QListView * m_topView;
   bool m_hasDSTBug;
   QStringList m_disabledList;
   QStringList m_subProjectList;
   bool m_virtual;
   QStringList m_tmpEntries;
   QString m_lastErrorMsg;
   bool m_isAutoUpdate;

   QSignal * m_pDirectorySuicide;
};

//----------------------------------------------------------------------------

#endif   //DIRECTORY_H_20010626

