/***************************************************************************
                          defaultplugin.cpp  -  description
                             -------------------
    begin                : 日 10月 26 2003
    copyright            : (C) 2003 by Sheldon Lee Wen
    email                : leewsb@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <config.h>
#include <lineak/lconfig.h>
#include <lineak/lkbd.h>
#include <lineak/lkey.h>
#include <lineak/lobject.h>
#include "soundctrl.h"
#include <lineak/cdromctrl.h>

#include <lineak/plugin_definitions.h>
#include <lineak/displayctrl.h>
#include <lineak/lineak_util_functions.h>

#include <algorithm>
#include <cctype>

#include <iostream>
#include <sstream>
#include <stdlib.h>
using namespace std;

#include "defaultplugin.h"

/** These are required */
#define NUM_MACROS 5

char* default_symbols[NUM_MACROS] = { "EAK_EJECT", "EAK_VOLUP", "EAK_VOLDOWN", "EAK_MUTE", "EAK_SLEEP" };
macro_info* default_macinfo = NULL;
identifier_info* idinfo = NULL;
LConfig* myConfig = NULL;
bool verbose = false;
bool enable;

displayCtrl* default_Display = NULL;

extern "C" int initialize(init_info init) {
        verbose = init.verbose;
	enable = init.global_enable;
	myConfig = init.config;

        return true;
}
extern "C" identifier_info* identifier() {
	idinfo = new (identifier_info);
        idinfo->description = "Default EAK macros.";
        idinfo->identifier = "default";
        idinfo->type = "MACRO";
        return idinfo;
}

extern "C" int exec(LObject* imyKey,XEvent xev) {
	LCommand command;
	if (imyKey->getType() == CODE || imyKey->getType() == SYM)
	    command = imyKey->getCommand(xev.xkey.state);
	if (imyKey->getType() == BUTTON)
	    command = imyKey->getCommand(xev.xbutton.state);

        string dname;

        if (imyKey->isToggle())
	   dname = imyKey->getNextToggleName();
        else
           dname = imyKey->getName();

	/* Give verbose output about the command and display name */
	if (verbose) {
		cout << "----------------------------------------" << endl;
		//cout << "For keycode: " << keycode << endl;
		cout << " Key: " << endl << *(imyKey) << endl;
	  	cout << "	XOSD Display: " << dname << endl;
		cout << "	Command: " << command << endl;
		cout << "----------------------------------------" << endl;
	}
	        /* lookup the key in our EAKeylist */
        if (!command.isEmpty())    {
                if (verbose) cout << "enable = " << enable << endl;
                if (enable) {
                        if (verbose) cout << "... that's the " <<  imyKey->getName() << " key" << endl;
                        /* check if the key has to run a SPECIAL command */
                        if ( command.getMacroType() == "EAK_EJECT" ) { /* Eject */
                                macroEAK_EJECT(command);
                        } else if ( command.getMacroType() == "EAK_VOLUP" ) { /* VolumeUp */
                                macroEAK_VOLUP(command);
                        } else if (command.getMacroType() == "EAK_VOLDOWN" ) { /* VolumeDown */
                                macroEAK_VOLDOWN(command);
                        } else if (command.getMacroType() == "EAK_MUTE" ) { /* Mute */
                                macroEAK_MUTE(command);
                        } else if (command.getMacroType() == "EAK_SLEEP" ) { /* Sleep (not implemented yet) */
                                macroEAK_SLEEP(command);
//                        } else if (command.getMacroType() == "EAK_SCREEN_LOCK" ) { /* Screen lock (not implemented yet) */
//                                macroEAK_SCREEN_LOCK(command);
                        } else if (command.isMacro()) { /** If we are a macro, but we can't find one that matches, return false. */
                                return false;
                        } else if (command.getCommand() == null) { /* no command defined */
                                if (verbose) cout << "... but it has no command bound to it :(" << endl;
                                cout << *(imyKey);
                        } 
                        /** Rotate the key state if it's a toggleable key */
			if (imyKey->isToggle())
				imyKey->toggleState();
                }
        }

	return true;
}
extern "C" macro_info* macrolist() {
	default_macinfo = new (macro_info);
	default_macinfo->num_macros = NUM_MACROS;
	default_macinfo->macro_list = default_symbols;
        return default_macinfo;
}
extern "C" void cleanup() {
        if (verbose) cout << "Cleaning up plugin defaultplugin" << endl;
	if (default_macinfo != NULL) {
		delete (default_macinfo);
		default_macinfo = NULL;
	}
	if (idinfo != NULL) {
                delete (idinfo);
                idinfo = NULL;
        }

	if (verbose) cout << "Done cleaning up plugin defaultplugin" << endl;
}
extern "C" void initialize_display(displayCtrl *imyDisplay) {
        if (verbose) cout << "Initializing display!" << endl;
        default_Display = imyDisplay;
}

void macroEAK_EJECT(LCommand &command) {
        const vector<string>& args = command.getArgs();
  /** If there is just the macro, and no arguments, use the globally defined cdrom device, and
      eject that */
        if (args.size() == 0) {
        cdromCtrl myCdrom(myConfig->getValue("CdromDevice"));
                myCdrom.eject();
    }
        /** If however, the macro contains arguments, then attempt to eject all of those */
        else {
          cdromCtrl cd;
          for (vector<string>::const_iterator it = args.begin(); it != args.end(); it++) {
                cd.setCdromdev(*it);
        /** Output the command */
                if (default_Display != NULL) {
                   default_Display->show(string("Ejecting CDRom"));
                }
                cd.eject();
    }
  }
}
/** macroEAK_Mute. In order to support using lots of soundCtrl devices in s disposable
        manner. i.e. create one when you want, then throw it away when you don't, and supporting
        lots of user mixer devices, we need to keep track of soundCtrl objects for each mixer we
        may have used. They get added on a per use basis. This is b/c the toggleMute() method of
        the soundCtrl class depends on a private variable that tracks the state of the mixer (i.e. muted
        or not). If we just instantiate and destroy the objects as we need them we loose the
        state of this variable. I support I could have created a static vector of mute states for the
        class, but I felt that was getting really beyond the function of this class. */
void macroEAK_MUTE(LCommand &command) {
        const vector<string>& args = command.getArgs();
  static map<string,soundCtrl> soundDevices;
        int retval = 0;
        string mixer = myConfig->getValue("MixerDevice");

  /** If there is just the macro, and no arguments, use the default volume stepping, and
      adjust by that */
  if (args.size() == 0) {
      /* Set the mixer device */
     /** If the soundDevice object for the corresponding mixer is not in the map. Add it */
      if ((soundDevices[mixer]).getMixer() != mixer) {
            soundCtrl mySound(mixer);
        soundDevices[mixer] = mySound;
      }
      retval = (soundDevices[mixer]).toggleMute();
     if (default_Display != NULL) {
        if (retval == -1)
           default_Display->volume(displayCtrl::MUTE);
        else
           default_Display->volume(retval);
     }
  }
  else {
  /** We should have either an integer, or integer-string pairs, which correspond to the increment
        value, and the device to adjust. */
    // Assume we have just an increment value.
    int value = 0;
        if (args.size() == 1) {
          value = atoi(args[0].c_str());
     /** If the soundDevice object for the corresponding mixer is not in the map. Add it */
      if ((soundDevices[mixer]).getMixer() != mixer) {
            soundCtrl mySound(mixer);
        soundDevices[mixer] = mySound;
      }
      retval = (soundDevices[mixer]).toggleMute(value);
      if (default_Display != NULL) {
         if (retval == -1)
            default_Display->volume(displayCtrl::MUTE);
         else
            default_Display->volume(retval);
      }
    }
    // Assume we have integer and value pairs.
    else {
        if (args.size() >=2 && (args.size() % 2 == 0)) {
//              soundCtrl sound;
                        for (vector<string>::const_iterator it = args.begin(); it != args.end();) {
                        value = atoi(it->c_str());
                    it++;
                    string device = *it;
                    it++;
                /** If there is no soundCtrl object for this mixer, add one */
                if ((soundDevices[device]).getMixer() != device) {
                        soundCtrl mySound(device);
                    soundDevices[device] = mySound;
                }
                    retval = (soundDevices[mixer]).toggleMute(value);
                    if (default_Display != NULL) {
                           if (retval == -1)
                                  default_Display->volume(displayCtrl::MUTE);
                           else
                                  default_Display->volume(retval);
                    }
        }
      }
    }
  }
}

void macroEAK_VOLUP(LCommand &command) {
        const vector<string>& args = command.getArgs();
        int retval = 0;
        string mixer = myConfig->getValue("MixerDevice");
  /** If there is just the macro, and no arguments, use the default volume stepping, and
      adjust by that */
  if (verbose) cout << "EAK_VOLUP" << endl;
        if (args.size() == 0) {
        if (verbose) cout << "doing default volume up\n";
            /* Set the mixer device */
            soundCtrl mySound(mixer);
        retval = mySound.volumeUp();
        if (default_Display != NULL)
            default_Display->volume(retval);
  }
  else {
  /** We should have either an integer, or integer-string pairs, which correspond to the increment
        value, and the device to adjust. */
    // Assume we have just an increment value.
      int value = 0;
      if (args.size() == 1) {
      if (verbose) cout << "single volume up\n";
      value = atoi(args[0].c_str());
      soundCtrl mySound(mixer);
      retval = mySound.volumeUp(value);
      if (default_Display != NULL)
            default_Display->volume(retval);

    }
    // Assume we have integer and value pairs.
    else {
        if (args.size() >=2 && (args.size() % 2 == 0)) {
        if (verbose) cout << "multiple volume ups\n";
        soundCtrl sound;
                        for (vector<string>::const_iterator it = args.begin(); it != args.end();) {
                        value = atoi(it->c_str());
                it++;
                string device = *it;
                it++;
          if (verbose) cout << device << " adjusted by: " << value << endl;
                sound.setMixer(device);
                retval = sound.volumeUp(value);
                if (default_Display != NULL)
                   default_Display->volume(retval);

        }
      }
    }
  }
}

void macroEAK_VOLDOWN(LCommand &command) {
        const vector<string>& args = command.getArgs();
        int retval = 0;
        string mixer = myConfig->getValue("MixerDevice");
  /** If there is just the macro, and no arguments, use the default volume stepping, and
      adjust by that */

        if (args.size() == 0) {
          if (verbose) cout << "default volumeDown\n";
          /* Set the mixer device */
          soundCtrl mySound(mixer);
          retval = mySound.volumeDown();
          if (default_Display != NULL)
             default_Display->volume(retval);
    }
    else {
    /** We should have either an integer, or integer-string pairs, which correspond to the increment
          value, and the device to adjust. */
      // Assume we have just an increment value.
      int value = 0;
          if (args.size() == 1) {
                        value = atoi(args[0].c_str());
        // If the value is positive, make it negative.
        if ( value > 0)
          value = 0 - value;
        if (verbose) cout << "single volume down by: " << value << endl;
            soundCtrl mySound(mixer);
        retval = mySound.volumeDown(value);
        if (default_Display != NULL)
                 default_Display->volume(retval);
    }
    // Assume we have integer and value pairs.
    else {
        if (args.size() >=2 && (args.size() % 2 == 0)) {
                soundCtrl sound;
                        for (vector<string>::const_iterator it = args.begin(); it != args.end();) {
                        value = atoi(it->c_str());
                it++;
                string device = *it;
                it++;
                if ( value > 0)
              value = 0 - value;
                if (verbose) cout << device << " adjusted by: " << value << endl;
                sound.setMixer(device);
                retval = sound.volumeDown(value);
                if (default_Display != NULL)
                          default_Display->volume(retval);
        }
      }
    }
  }
}

void macroEAK_SLEEP(LCommand &command) {
        if (default_Display != NULL)
          default_Display->show ("Sleep");
}
/*
void CommandExec::macroEAK_SCREEN_LOCK(LCommand &command) {
        const vector<string>& args = command.getArgs();
        if (!args.empty()) {
    string method = args[0];
    // Transform the method to uppercase so we can do a comparison.
    int (*pf)(int)=toupper;
    std::transform(method.begin(), method.end(), method.begin(), pf);
                string comm;
                if (!fork()) {
                        if (method == "KDE")
                                comm = "dcop kdesktop KScreensaverIface lock";
                if (method == "GNOME" || method == "XSCREENSAVER" )
                                comm = "xscreensaver-command -lock";

          //comm = lineak_util_functions::unescape(comm,"#");
                                        comm += " &";
                 // child process that tries to run the command, and then exits
                // all specials done, let's go for it... ;)
                if (verbose) cout << "Locking screen for desktop " << method << endl;
                                        system(comm.c_str());
                                        exit(1);
                        }
                        // NOTE: no, we don't wait() for the child. we just ignore the SIGCLD signal
        }
        else
                cerr << "EAK_SCREEN_LOCK macro requires an argument" << endl;

}
*/
