/***************************************************************************
                          msgpasser.cpp  -  description
                             -------------------
    begin                : Sun Feb 23 2003
    copyright            : (C) 2003 by Sheldon Lee Wen
    email                : leewsb@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <lineak/msgpasser.h>
#include <string>
#include <iostream>
#include <lineak/definitions.h>

using namespace std;
bool msgPasser::running = true;
//int CMDSIZE = CMDSIZE;
const int msgPasser::RECIEVE_KEY = dRECIEVE_KEY;
const int msgPasser::SEND_KEY = dSEND_KEY;
const int msgPasser::HUP = dHUP;
const int msgPasser::RELOAD = dRELOAD;
const int msgPasser::EXIT = dEXIT;
const int msgPasser::TERM = dTERM;
const int msgPasser::DISABLE = dDISABLE;
const int msgPasser::ENABLE = dENABLE;
const int msgPasser::COMMAND = dCOMMAND;

msgPasser::msgPasser(int ikey){
  msg_to_recieve = 0;
  failed = false;
  string pathname = getenv("HOME");
  pathname += LINEAKDIR;
  key = ftok(pathname.c_str(), ikey);
  if (key == -1) {
  	cerr << "Failed to generate a System V IPC key." << endl;
  }
  else
   	key = ikey + getuid();
//	start();
}

msgPasser::~msgPasser(){
}
bool msgPasser::start() {
	msgid = msgget((key_t)key, 0640 | IPC_CREAT);
	if (msgid == -1) {
		cerr << "Failed to set up message queue with error: " << errno << endl;
		failed = true;
	}
	return (failed);
}
void msgPasser::quit() {
	if (msgid != -1) {
		if (msgctl (msgid, IPC_RMID, 0) == -1) {
			cerr << "msgctl(IPC_RMID) failed" << endl;
		}
	}
	msgid = -1;
}
eak_msg msgPasser::getMessage() {
	myMsg.msg_type = 0;
	strcpy(myMsg.directive.args,"");
	if (msgrcv(msgid, (void *)&myMsg, sizeof(eak_direct_t), msg_to_recieve, IPC_NOWAIT) == -1 ) {}
		//cerr << "msgrcv failed with error: " << errno << endl;

	return myMsg;
}
void msgPasser::sendMessage(int comm, string args) {
	myMsg.msg_type = comm;

	strcpy(myMsg.directive.args, args.c_str());
	if (msgsnd(msgid, (void *)&myMsg, sizeof(eak_direct_t), IPC_NOWAIT) == -1)
		cerr << "msgsnd failed" << endl;

}
