#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>
#include "../common.h"
#include "srv_def.h"
#include "lists.h"
#include "cfg.h"
#include "global_vars.h"
#include "../config.h"

#define LCS_CONFIG_LINE	1024

#define LCS_PARANUM	63

#define LCS_CONF_BIND_TO 6
#define LCS_CONF_PORT	5
#define LCS_CONF_FILTER	7
#define LCS_CONF_FIP	8
#define LCS_CONF_FMASK	9
#define LCS_CONF_SEND_TPUT 10
#define LCS_CONF_PINGER 12
#define LCS_CONF_PING_IP 13
#define LCS_CONF_PING_IV 14
#define LCS_CONF_PING_DS 15
#define LCS_CONF_ISDN	16
#define LCS_CONF_ISDNCHANOP	17
#define LCS_CONF_SHUTDOWN 20
#define LCS_CONF_LIMSHTDN_IP 21
#define LCS_CONF_LIMSHTDN_MASK 22
#define LCS_CONF_CON_TYPE 23
#define LCS_CONF_USERACCT 29
#define LCS_CONF_LPTSTATUS 38
#define LCS_CONF_LINE	41
#define LCS_CONF_ALLOWMANUALLY 43
#define LCS_CONF_HTML_STATUS 44
#define LCS_CONF_PIDFILE 45
#define LCS_CONF_PINGERHOSTNAME 46
#define LCS_CONF_LINE_LOCKING 48
#define LCS_CONF_SYSLOGCALLFROM 49
#define LCS_CONF_LINE_MKLOG 57
#define LCS_CONF_ISDNCALLERSLOG 58
#define LCS_CONF_ADBTABLE 59
#define LCS_CONF_ADBNAME 60
#define LCS_CONF_ADBPHONE 61
#define LCS_CONF_CALLERSLOG 62
#define LCS_IPL_ALLOW	"allow"
#define LCS_IPL_DENY	"deny"
#define LCS_CONF_YES	"yes"
#define LCS_CONF_NO	"no"

#if HAVE_MYSQL
#define LCS_CONF_DBHOST 52
#define LCS_CONF_DBPORT 53
#define LCS_CONF_DBUSER 54
#define LCS_CONF_DBPASS 55
#define LCS_CONF_DBNAME 56
#endif
char ip[16];
char dumstr[500];
char dbs[20];
//unsigned short dbport;
unsigned int dbport;
char yesno[2][4] = { "no", "yes" };
char *CT_KEYS[CT_NUM_KEYS] = { "netdev", "isdn", "file" }; // mapping of server->con_type
#define LCS_NUM_LPTSTAT_TYPES	3
char *LCS_LPTSTAT_TYPES[LCS_NUM_LPTSTAT_TYPES] = {"off", "lines", "clients"};
char *conf_params[LCS_PARANUM]
    = { "interface", "script_up", "script_dn", "script_esc", "magicpass",
        "port", "bind_to", "filter_type", "filter_ip", "filter_mask",
	"send_throughput", "con_timeout", "pinger", "pinger_ip",
	"pinger_interval", "pinger_datasize", "use_isdn", "isdn_id",
	"isdn_channel", "isdn_channel_op", "script_shutdown",
	"limit_shutdown_ip", "limit_shutdown_mask", "con_type",
	"con_status_file", "logfile", "client_online", "client_offline",
	"passwd_file", "user_accounting",
	"caller_nr_pos", "receiver_nr_pos", "caller_delimiter", 
	"receiver_delimiter", "month_pos", "day_pos", "time_pos",
	"addressbook_location", "lptstatus", "lptaddr", "lptline",
	"line", "isdninfo", "allow_manually", "html_status", "pidfile",
	"pinger_hostname", "con_down_timeout", "line_locking", "syslog_call_from",
	"line_baud_up", "line_baud_down",
	"db_hostname", "db_port", "db_user", "db_pass", "db_name",
	"mklog", "isdn_callerslog", "addrbook_table", "addrbook_namecol", "addrbook_numcol",
	"callerslog" };
void *conf_addrs[LCS_PARANUM]; // runtime initialisation
char *conf_formats[LCS_PARANUM]
    = { "%s", "%[^\n]s", "%[^\n]s", "%s", "%s", "%d", "%s",
	"%s", "%[0-9.]s", "%[0-9.]s",
	"%s", "%d", "%s", "%[0-9.]s", "%d", "%d", "%s", "%s", "%d", "%s",
	"%s", "%[0-9.]s", "%[0-9.]s", "%s",
	"%s", "%s", "%s", "%s",
	"%s", "%s",
	"%d", "%d", "%s", "%s", "%d", "%d", "%d",
	"%s", "%s", "%x", "%16s",
	"%16s", "%255s", "%4s", "%s", "%s",
	"%s", "%d", "%s", "%s",
	"%d", "%d",
	"%s", "%d", "%s", "%s", "%s",
	"%4s", "%4s", "%s", "%s", "%s",
	"%s" };
	
void config_set_conf_lineaddrs(struct line_t* line)
{
    conf_addrs[0] = line->interface;
    conf_addrs[1] = line->script_up;
    conf_addrs[2] = line->script_dn;
    conf_addrs[3] = line->script_esc;
    conf_addrs[11] = &line->con_up_timeout;
    conf_addrs[14] = &line->pinger_interval;
    conf_addrs[15] = &line->pinger_datasize;
    conf_addrs[17] = line->isdn_id;
    conf_addrs[18] = &line->isdn_channel;
    conf_addrs[19] = line->isdn_channel_op;
    conf_addrs[24] = line->con_status_file;
    conf_addrs[26] = line->client_online;
    conf_addrs[27] = line->client_offline;
    conf_addrs[42] = line->isdninfo;
    conf_addrs[47] = &line->con_down_timeout;
	conf_addrs[50] = &line->baud_up;
	conf_addrs[51] = &line->baud_down;
}

void config_set_conf_addrs()
{
    /* values for the server record */
    conf_addrs[4] = dumstr; //server->magicpass;
    conf_addrs[5] = &server->port;
    conf_addrs[6] = ip;
    conf_addrs[7] = dumstr;
    conf_addrs[8] = ip;
    conf_addrs[9] = ip;
    conf_addrs[10] = dumstr;
    conf_addrs[20] = server->script_shutdown;
    conf_addrs[21] = ip;
    conf_addrs[22] = ip;
    conf_addrs[25] = server->logfile_name;
    conf_addrs[28] = server->passwd_file;
    conf_addrs[29] = dumstr;
    conf_addrs[30] = &server->caller_nr_pos;
    conf_addrs[31] = &server->receiver_nr_pos;
    conf_addrs[32] = server->caller_delimiter;
    conf_addrs[33] = server->receiver_delimiter;
    conf_addrs[34] = &server->month_pos;
    conf_addrs[35] = &server->day_pos;
    conf_addrs[36] = &server->time_pos;
    conf_addrs[37] = server->addressbook_location;
    conf_addrs[38] = dumstr;
    conf_addrs[39] = &server->lpt_addr;
    conf_addrs[40] = server->lpt_linename;
    conf_addrs[41] = dumstr;
    conf_addrs[44] = dumstr;
    conf_addrs[45] = dumstr;
    /* non changing addr for line_t records */
    conf_addrs[12] = dumstr;
    conf_addrs[13] = ip;
    conf_addrs[16] = dumstr;
    conf_addrs[23] = dumstr;
    conf_addrs[43] = dumstr; // allow_manually [yes|no]
    conf_addrs[46] = dumstr; // pinger_hostname %s
    conf_addrs[48] = dumstr; // line_locking [yes|no]
	conf_addrs[49] = dumstr; // syslog_call_from [yes/NO]
//#if HAVE_MYSQL
    conf_addrs[52] = dbs;  
//    conf_addrs[53] = &server->db_port;
    conf_addrs[53] = &dbport;
    conf_addrs[54] = dbs;
    conf_addrs[55] = dbs;
    conf_addrs[56] = dbs;
//#endif
	conf_addrs[57] = dumstr; // mklog [yes/no]
	conf_addrs[58] = dumstr; // isdn_callerslog [yes/no]
	conf_addrs[59] = dumstr; //server->addrbook_table;
	conf_addrs[60] = dumstr; //server->addrbook_namecol;
	conf_addrs[61] = dumstr; //server->addrbook_numcol;
	conf_addrs[62] = dumstr; // server->callerslog;
}

void config_load_linedefaults(struct line_t *line)
{
 char *sup = LCS_SCRIPT_UP;
 char *sdn = LCS_SCRIPT_DN;
 char *ifac = LCS_INTERFACE;
 char *chanop = LCS_SCRIPT_ADDCHAN;
 char *isdninf = LCS_FILE_ISDNINFO;
 bzero(line, sizeof(struct line_t));
 line->allow_manually = 1;
 line->con_stat = CST_DOWN;
 line->con_type = CT_NETDEV; // analog --> net device (e.g. ppp0)
 line->con_up_timeout = LCS_CON_UP_TIMEOUT;
 line->con_down_timeout = LCS_CON_DN_TIMEOUT;
 line->pinger_datasize = LCS_PING_DATA;
 line->pinger_ip = 0;
 line->pinger_interval = LCS_PING_INTERVAL;
 line->pinger_hostname = NULL;
 line->used_channels = 1;	// at least one channel is used... :)
 line->line_locking = 1;
 line->baud_up = 64000;
 line->baud_down = 64000;
 line->mklog = 1;
 strcpy(line->script_up, sup);
 strcpy(line->script_dn, sdn);
 strcpy(line->interface, ifac);
 strcpy(line->isdn_channel_op, chanop);
 strcpy(line->isdninfo, isdninf);
}

void config_load_defaults()
{
 bzero(server, sizeof(struct server_t));
 server->bind_to = INADDR_ANY;
 server->port = htons(LCS_PORT);
 server->big_loop = time(NULL);
 server->mid_loop = server->big_loop;
 server->small_loop = time(NULL);
 server->big_loop_min = LCS_BIG_LOOP;
 server->ipl_type = IPL_ALLOW;
 server->shtdn_ipl_type = IPL_ALLOW;
 server->use_user_accounting = 1;
 server->caller_nr_pos = LCS_CALLER_NR_POS;
 server->receiver_nr_pos = LCS_RECEIVER_NR_POS;
 server->month_pos = LCS_MONTH_POS;
 server->day_pos = LCS_DAY_POS;
 server->time_pos = LCS_TIME_POS;
 server->lpt_status = 0;
 server->isdn_callerslog = 0;
 strcpy(server->passwd_file, "[automatic]");
 server->callerslog = strdup("/var/log/isdn.caller.log");
#if HAVE_MYSQL 
 server->db_port = LCS_DB_PORT;
#endif 
// server->syslog_call_from = 0;
 // we don't preload server->script_shutdown
 // don't init magicpass! (currently not used, came from ver 1.x)
}

void dump_configs()
{
 struct in_addr addr, addr2;
 struct ipl_item_t *iplentry = (struct ipl_item_t*)ipl.first;
 struct line_t *curline;
 addr.s_addr = server->bind_to;
 fprintf(stdout, "GLOBAL:\n");
 if ( server->pidfile )
     fprintf(stdout, "- pidfile: %s\n", server->pidfile);
 if ( server->html_status_pipe )
     fprintf(stdout, "- html_status: %s\n", server->html_status_pipe);
 fprintf(stdout, "- user_accounting: %s\n", yesno[(int)server->use_user_accounting]);
 if ( server->use_user_accounting )
     fprintf(stdout, "  - passwd_file: %s\n", server->passwd_file);
 fprintf(stdout, "- bind_to: %s\n- port: %d\n", inet_ntoa(addr), ntohs(server->port));
 fprintf(stdout, "- send_throughput: %s\n", yesno[(int)server->send_throughput]);
 if ( server->logfile_name[0] )
 {
     fprintf(stdout, "- logfile: %s\n", server->logfile_name);
 }
 if ( server->lpt_status )
 {
     fprintf(stdout, "- lpt-status: %s\n", LCS_LPTSTAT_TYPES[server->lpt_status]);
     fprintf(stdout, "  - port: 0x%x\n", server->lpt_addr);
     if ( server->lpt_linename[0] )
         fprintf(stdout, "  - linename: %s\n", server->lpt_linename);
 }
 fprintf(stdout, "- isdn_callerslog: %s\n", yesno[(int)server->isdn_callerslog]);
 if ( server->isdn_callerslog )
	fprintf(stdout, "  - callerslog: %s\n", server->callerslog);
 if ( server->isdn_callerslog && server->addrbook_table )
 {
 	fprintf(stdout, "  - addrbook_table: %s\n", server->addrbook_table);
 	fprintf(stdout, "  - addrbook_namecol: %s\n", server->addrbook_namecol);
 	fprintf(stdout, "  - addrbook_numcol: %s\n", server->addrbook_numcol);
 }
 if ( !server->isdn_callerslog )
	 fprintf(stdout, "- syslog_call_from: %s\n", yesno[(int)server->syslog_call_from]);
 fprintf(stdout, "- filter_type: ");
 switch (server->ipl_type)
 {
     case IPL_ALLOW: fprintf(stdout, "allow\n"); break;
     case IPL_DENY: fprintf(stdout, "deny\n"); break;
     case IPL_INVALID: fprintf(stdout, "error, filter disabled.\n"); break;
     default: fprintf(stdout, "your processor is mad!\n");
 }
 while (iplentry != NULL)
 {
      switch (iplentry->type) {
          case IPL_RANGE: fprintf(stdout, "  - range: "); break;
          case IPL_MASK: fprintf(stdout,  "  - mask:  "); break;
      }
      addr.s_addr = iplentry->ipa;
      addr2.s_addr = iplentry->ipb;
      fprintf(stdout, "%15s   ", inet_ntoa(addr));
      fprintf(stdout, "%15s\n", inet_ntoa(addr2));
      iplentry = (struct ipl_item_t*)iplentry->next;
 }
#if HAVE_MYSQL
 if (server->db_hostname[0])
 {
      fprintf(stdout, "- database config:\n");
      fprintf(stdout, "  - Hostname: %s\n", server->db_hostname);
      fprintf(stdout, "  - DB port: %d\n", server->db_port);
      fprintf(stdout, "  - DB name: %s\n", server->db_name);
      fprintf(stdout, "  - Username: %s\n", server->db_user);
      fprintf(stdout, "  - Password: NOT SHOWN\n");
 }
#endif 

#ifdef SHUTDOWN_OK
 if ( server->script_shutdown[0] )
 {
     fprintf(stdout, "- script_shutdown: %s\n", server->script_shutdown);
     fprintf(stdout, "- shutdown filter (type allow):\n");
     iplentry = (struct ipl_item_t*)shtdn_ipl.first;
     while (iplentry != NULL)
     {
          switch (iplentry->type) {
              case IPL_RANGE: fprintf(stdout, "  - range: "); break;
              case IPL_MASK: fprintf(stdout,  "  - mask:  "); break;
          }
          addr.s_addr = iplentry->ipa;
          addr2.s_addr = iplentry->ipb;
          fprintf(stdout, "%15s   ", inet_ntoa(addr));
          fprintf(stdout, "%15s\n", inet_ntoa(addr2));
          iplentry = (struct ipl_item_t*)iplentry->next;
     }
 }
#endif
/*----------- now the line dependent configuration ---------------*/
 curline = (struct line_t*)lstlines.first;
 while ( curline )
 {
    fprintf(stdout, "\nLINE [%d:%s]:\n", curline->id, curline->linename);
	fprintf(stdout, " - mklog: %s\n", yesno[(int)curline->mklog]);
    fprintf(stdout, " - allow_manually: %s\n", yesno[(int)curline->allow_manually]);
    fprintf(stdout, " - interface: %s\n", curline->interface);
	fprintf(stdout, " - line_baud_up: %d\n - line_baud_down: %d\n",
			curline->baud_up, curline->baud_down);
    fprintf(stdout, " - script_up: %s\n - script_dn: %s\n - script_esc: %s\n",
	curline->script_up, curline->script_dn, curline->script_esc);
    fprintf(stdout, " - con_timeout: %d\n", (int)curline->con_up_timeout);
    fprintf(stdout, " - line_locking: %s\n", yesno[(int)curline->line_locking]);
    fprintf(stdout, " - pinger: %s\n", yesno[(int)curline->pinger]);
    if ( curline->pinger )
    {
	if ( curline->pinger_hostname )
	    fprintf(stdout, "   - pinger_hostname: %s\n", curline->pinger_hostname);
	else
	{
	    addr.s_addr = curline->pinger_ip;
	    fprintf(stdout, "   - pinger_ip:       %s\n", inet_ntoa(addr));
	}
	fprintf(stdout, "   - pinger_interval: %d\n", (int)curline->pinger_interval);
	fprintf(stdout, "   - pinger_datasize: %d\n", curline->pinger_datasize);
    } 
    fprintf(stdout, " - con_type: %s\n", CT_KEYS[curline->con_type]);
    switch ( curline->con_type )
    {
	case CT_NETDEV: break;
        case CT_ISDN:
	    fprintf(stdout, "   - isdninfo: %s\n", curline->isdninfo);
	    fprintf(stdout, "   - isdn_id: %s\n   - isdn_channel: %d\n",
    	        curline->isdn_id, curline->isdn_channel);
            fprintf(stdout, "   - isdn_channel_op: %s\n", curline->isdn_channel_op);
	    break;
	case CT_FILE:
	    fprintf(stdout, "   - con_status_file: %s\n", curline->con_status_file);
	    break;
	default: fprintf(stdout, "   - ERROR: con_type is invalid!\n");
    }
    if ( curline->client_online[0] )
	fprintf(stdout, " - client_online: %s\n - client_offline: %s\n",
    		curline->client_online, curline->client_offline);
    curline = (struct line_t*)curline->next;
 }
}

int read_config(int argc, char **argv)
{
 struct in_addr addr;
 struct ipl_item_t *iplentry;
 char *cfile = LCS_CONFIG_FILE;
 char *cf = cfile;
 FILE *fp;
 char line[LCS_CONFIG_LINE+1], *lpos;
 void *ptr1, *ptr2;
 int var, i;
 struct line_t *curline;
 config_set_conf_addrs();
 config_load_defaults();
 /* create & init default line, id 0 */
 curline = (struct line_t*)list_add(&lstlines, sizeof(struct line_t));
 if ( !curline )
 {
     fprintf(stderr, "Not enough memory to load configuration.\n");
     return(-2);
 }
 curline->id = lstlines.count - 1;
 config_set_conf_lineaddrs(curline);
 config_load_linedefaults(curline);
 /* go on */
 if ( (argc >= 3) && (!strcmp("-c", argv[1])) )
 {
     cf = argv[2];
     fprintf(stdout, "using '%s' as config file.\n", cf);
 }
 if ( !(fp = fopen(cf, "r")) ) {
     fprintf(stderr, "error opening %s!\n", cf);
     return(-1);
 }
 fprintf(stdout, "loading config file... ");
 fflush(stdout);
 while ( fgets(line, sizeof(line), fp) != NULL )
 {
    if ( line[0] == '#' || line[0] == '\n' ) continue;
    for ( var=0; var < LCS_PARANUM; var++ )
    {
	if ( strstr(line, conf_params[var]) != line ) continue;
	lpos = line + strlen(conf_params[var]);
	if ( *lpos++ != ' ' ) continue;	// have space after each keyword
	sscanf(lpos, conf_formats[var], conf_addrs[var]);
	switch (var)
	{
	    case LCS_CONF_LINE:
		// integrity of current line gets checked at the end.
		// let's begin with the settings of a new line
		curline = (struct line_t*)list_add(&lstlines, sizeof(struct line_t));
		if ( !curline )
		{
		    fprintf(stderr, "Not enough memory to load configuration.\n");
		    list_flush(&lstlines);
		    return(-2);
		}
		config_set_conf_lineaddrs(curline);
		config_load_linedefaults(curline);
		ptr1 = ((char*)lstlines.first) + sizeof(struct list_hdr_t);
		ptr2 = ((char*)curline) + sizeof(struct list_hdr_t);
		// copy from the global defaults...
		memcpy(ptr2, ptr1, sizeof(struct line_t)-sizeof(struct list_hdr_t));
		curline->id = lstlines.count - 1;
		strncpy(curline->linename, dumstr, LCP3_LINENAME_LEN+1);
		break;
	    case LCS_CONF_BIND_TO:
	        inet_aton(ip, &addr);
	        server->bind_to = addr.s_addr;
	        break;
	    case LCS_CONF_PORT:
	        server->port = htons(server->port);
	        break;
	    case LCS_CONF_FILTER:
	        if ( strstr(dumstr, LCS_IPL_ALLOW) == dumstr )
			server->ipl_type = IPL_ALLOW;
		else if ( strstr(dumstr, LCS_IPL_DENY) == dumstr )
		    server->ipl_type = IPL_DENY;
		else server->ipl_type = IPL_INVALID;
		break;
	    case LCS_CONF_SEND_TPUT:
		if ( !strcasecmp(dumstr, LCS_CONF_NO) )
		    server->send_throughput = 0;
		else
		    server->send_throughput = 1;
		break;
#if HAVE_MYSQL
            case LCS_CONF_DBHOST:
                strcpy(server->db_hostname, dbs);
                break;
            case LCS_CONF_DBPORT:
                server->db_port = (unsigned short)dbport;
                break;
            case LCS_CONF_DBUSER:
                strcpy(server->db_user, dbs);
                break;
            case LCS_CONF_DBPASS:
                strcpy(server->db_pass, dbs);
                break;
            case LCS_CONF_DBNAME:
                strcpy(server->db_name, dbs);
                break;
#endif	
            case LCS_CONF_PINGER:
	        if ( !strcasecmp(dumstr, LCS_CONF_YES) )
		    curline->pinger = 1;
		else
		    curline->pinger = 0;
		break;
	    case LCS_CONF_PING_IP:
		inet_aton(ip, &addr);
		curline->pinger_ip = addr.s_addr;
		break;
	    case LCS_CONF_PING_DS:
		if ( curline->pinger_datasize > LCS_PING_MAXDATA )
		    curline->pinger_datasize = LCS_PING_MAXDATA;
		break;
	    case LCS_CONF_PING_IV:
		if ( curline->pinger_interval < LCS_PING_MININTERVAL )
		    curline->pinger_interval = LCS_PING_MININTERVAL;
		break;
	    case LCS_CONF_ISDN: // backward compatibility
		if ( !strcasecmp(dumstr, LCS_CONF_YES) )
		    curline->con_type = CT_ISDN;
		break;
	    case LCS_CONF_ISDNCHANOP:
		curline->use_isdn_chanop = 1;
		break;
	    case LCS_CONF_USERACCT:
	        if ( !strcasecmp(dumstr, LCS_CONF_NO) )
		    server->use_user_accounting = 0;
		else
		    server->use_user_accounting = 1;
		break;
	    case LCS_CONF_SHUTDOWN:
#ifndef SHUTDOWN_OK
	        fprintf(stdout, "\nShutdown support disabled. See linesrv-2.1/configure --help for details.\n");
#endif
	        break;
	    case LCS_CONF_CON_TYPE:
	        for (i=0;i<CT_NUM_KEYS;i++)
	        {
		    if ( !strcasecmp(dumstr, CT_KEYS[i]) )
		    {
		        curline->con_type = i;
		        break;
		    }
		}
		if ( strcasecmp(dumstr, CT_KEYS[i]) )
		{
		    fprintf(stderr, "Invalid con_type for line '%s'!\n", curline->linename);
		    return(-2);
		}
		break;
	    case LCS_CONF_LPTSTATUS:
		for (i=0;i<LCS_NUM_LPTSTAT_TYPES;i++)
		{
		    if ( !strcasecmp(dumstr, LCS_LPTSTAT_TYPES[i]) )
		    {
			server->lpt_status = i;
			break;
		    }
		}
		break;
	    case LCS_CONF_ALLOWMANUALLY:
	        if ( !strcasecmp(dumstr, LCS_CONF_YES) )
			    curline->allow_manually = 1;
			else
			    curline->allow_manually = 0;
			break;
		case LCS_CONF_LINE_MKLOG:
	        if ( !strcasecmp(dumstr, LCS_CONF_YES) )
			    curline->mklog = 1;
			else
			    curline->mklog = 0;
			break;
	    case LCS_CONF_LINE_LOCKING:
	        if ( !strcasecmp(dumstr, LCS_CONF_YES) )
		    curline->line_locking = 1;
		else
		    curline->line_locking = 0;
		break;
	    case LCS_CONF_HTML_STATUS:
		server->html_status_pipe = strdup(dumstr);
		break;
	    case LCS_CONF_PIDFILE:
		server->pidfile = strdup(dumstr);
		break;
		case LCS_CONF_ADBTABLE:
			if ( server->addrbook_table ) free(server->addrbook_table);
			server->addrbook_table = strdup(dumstr);
			break;
		case LCS_CONF_ADBNAME:
			if ( server->addrbook_namecol ) free(server->addrbook_namecol);
			server->addrbook_namecol = strdup(dumstr);
			break;
		case LCS_CONF_ADBPHONE:
			if ( server->addrbook_numcol ) free(server->addrbook_numcol);
			server->addrbook_numcol = strdup(dumstr);
			break;
		case LCS_CONF_CALLERSLOG:
			if ( server->callerslog ) free(server->callerslog);
			server->callerslog = strdup(dumstr);
			break;
		case LCS_CONF_SYSLOGCALLFROM:
	        if ( !strcasecmp(dumstr, LCS_CONF_YES) )
		    	server->syslog_call_from = 1;
			else
				server->syslog_call_from = 0;
			break;
		case LCS_CONF_ISDNCALLERSLOG:
	        if ( !strcasecmp(dumstr, LCS_CONF_YES) )
		    	server->isdn_callerslog = 1;
			else
				server->isdn_callerslog = 0;
			break;
	    case LCS_CONF_PINGERHOSTNAME:
		curline->pinger_hostname = strdup(dumstr);
		break;
	    case LCS_CONF_FIP:
	    case LCS_CONF_FMASK:
	        // ok, got new filter entry
	        if (server->ipl_type != IPL_INVALID)
	        {
		    iplentry = (struct ipl_item_t*)list_add(&ipl, sizeof(struct ipl_item_t));
		    if ( !iplentry )
		    {
		        server->ipl_type = IPL_INVALID;
		    }
		    else if ( inet_aton(ip, &addr) )
		    {
		        switch (var) {
			    case LCS_CONF_FIP:
			        iplentry->type = IPL_RANGE;
			        break;
			    case LCS_CONF_FMASK:
			        iplentry->type = IPL_MASK;
			        break;
			    default:;
			}
			iplentry->ipa = addr.s_addr;
			lpos += strlen(ip)+1;
			sscanf(lpos, conf_formats[var], conf_addrs[var]);
			if ( inet_aton(ip, &addr) )
			{
			    iplentry->ipb = addr.s_addr;
			}
			else list_del(&ipl, (struct list_hdr_t*)iplentry);
		    }
		    else list_del(&ipl, (struct list_hdr_t*)iplentry);
		}
		break;
	    case LCS_CONF_LIMSHTDN_IP:
	    case LCS_CONF_LIMSHTDN_MASK:
	        // ok, got new shutdown - filter entry
	        if (server->shtdn_ipl_type != IPL_INVALID)
	        {
		    iplentry = (struct ipl_item_t*)list_add(&shtdn_ipl, sizeof(struct ipl_item_t));
		    if ( !iplentry )
		    {
		        server->shtdn_ipl_type = IPL_INVALID;
		    }
		    else if ( inet_aton(ip, &addr) )
		    {
		        switch (var) {
		    	    case LCS_CONF_LIMSHTDN_IP:
				iplentry->type = IPL_RANGE;
				break;
			    case LCS_CONF_LIMSHTDN_MASK:
				iplentry->type = IPL_MASK;
				break;
			    default:;
			}
			iplentry->ipa = addr.s_addr;
			lpos += strlen(ip)+1;
			sscanf(lpos, conf_formats[var], conf_addrs[var]);
			if ( inet_aton(ip, &addr) )
			{
			    iplentry->ipb = addr.s_addr;
			}
			else list_del(&shtdn_ipl, (struct list_hdr_t*)iplentry);
		    }
		    else list_del(&shtdn_ipl, (struct list_hdr_t*)iplentry);
		}
		break;
	    default:
	}
    }
 }
 fclose(fp);
 fprintf(stdout, "done.\n");
 // we have to correct some little things...
 // first, erease the default settings for new created lines from the list:
 list_del(&lstlines, lstlines.first);
 // print out the loaded configs
 dump_configs();
 // talk about & handle strange things...
 curline = (struct line_t*)lstlines.first;
 while ( curline )
 {
     // the following means "if ( a XOR b )", is there an XOR op in C??
     if ( ((curline->client_online[0])||(curline->client_offline[0]))
          && (!((curline->client_online[0])&&(curline->client_offline[0]))) )
     {   // disable client dependent scripts if not both are set
         fprintf(stderr, "Set both of the client_online and client_offline scripts!\n");
         curline->client_online[0] = 0;
         curline->client_offline[0] = 0;
     }
     if ( (curline->con_type == CT_FILE) && (!curline->con_status_file[0]) )
     {
         fprintf(stderr, "con_type is 'file' but no file was specified (use 'con_status_file <fname>').\n");
         list_flush(&lstlines);
         return(-1);
     }
     switch (curline->con_type)
     {
         case CT_NETDEV:
         case CT_ISDN:
         case CT_FILE:
	     break;
	 default:
	     fprintf(stdout, "Bad con_type (%d) for line '%s'!\n", curline->con_type, curline->linename);
	     list_flush(&lstlines);
	     return(-1);
     }
     curline = (struct line_t*)curline->next;
 }
 if ( !lstlines.first )
 {
     fprintf(stderr, "You didn't specify a line! Use the 'line' keyword.");
     return(-1);
 }
 if ( (geteuid() != 0) && (server->lpt_status) )
 {
     fprintf(stderr, "You must be root to use the lpt_status feature!\n");
     server->lpt_status = 0;
 }
 else if ( server->lpt_addr > 0x3ff )
 {
     fprintf(stderr, "LPT port mustn't be higher than 0x3ff!\n");
     server->lpt_addr = 0;
 }
 if ( !(server->lpt_addr) )
     server->lpt_status = 0;
#ifdef SHUTDOWN_OK
 if ( shtdn_ipl.count == 0 ) fprintf(stdout, "Shutdown not usable without extra filter-list.\n");
#endif
 return(0);
}
