/* $Id: about.c,v 1.8 2005/03/28 19:39:46 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "../li18n.h"
#include "../defs.h"
#include "../errors.h"
#include "hig-widgets.h"
#include "gtkdefs.h"

#include "util.h"
#include "about.h"

extern lingGtkMainWindow *main_app;

#define INFO_A NAME " v" VERSION " - " INTVERSION
#define MARKUP_ABOUT "<span size=\"large\" weight=\"bold\">%s</span>\n%s\n%s"

void
about_activate (void)
{
     GtkWidget *dlg_about;
     GtkWidget *box_main;
     GtkWidget *box_about;
     GtkWidget *box_info;
     GtkWidget *img_logo;
     GtkWidget *lbl_about;
     GtkWidget *btn_link;
     GtkWidget *align;
     GtkWidget *lbl_link;
     GtkWidget *notebook_about;
     GtkWidget *scr_win_team;
     GtkWidget *lbl_team;
     GtkWidget *text_view_team;
     GtkWidget *scr_win_license;
     GtkWidget *lbl_license;
     GtkWidget *text_view_license;
     GtkTextBuffer *buf_credits;
     GtkTextBuffer *buf_license;

     gchar *file = NULL;
     gchar *buf = NULL;
     GError *err = NULL;
     gsize n;
     gchar *text = NULL;

     debug ("Creating about dialog...\n");

     /* about window */
     text = g_strdup_printf ("%s %s", _("About"), NAME);
     dlg_about = gtk_dialog_new_with_buttons (text,
                                              GTK_WINDOW (main_app->window),
                                              GTK_DIALOG_MODAL |
                                              GTK_DIALOG_DESTROY_WITH_PARENT,
                                              GTK_STOCK_CLOSE,
                                              GTK_RESPONSE_CLOSE,
                                              NULL);
     g_free (text);
     gtk_dialog_set_has_separator (GTK_DIALOG (dlg_about), FALSE);
     gtk_container_set_border_width (GTK_CONTAINER (dlg_about), WIDGET_BORDER);
     gtk_window_set_resizable (GTK_WINDOW (dlg_about), FALSE);

     /* main box */
     box_main = hig_vbox_new ();
     gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dlg_about)->vbox), box_main,
                         TRUE, TRUE, 0);
     
     /* about box */
     box_about = hig_hbox_new ();
     gtk_container_set_border_width (GTK_CONTAINER (box_about), 0);
     gtk_box_pack_start (GTK_BOX (box_main), box_about, FALSE, TRUE, 0);
     
     /* logo */
     img_logo = gtk_image_new_from_stock (GTK_STOCK_MISSING_IMAGE,
                                          GTK_ICON_SIZE_DIALOG);
     gtk_box_pack_start (GTK_BOX (box_about), img_logo, FALSE, TRUE, 0);

     /* text info box */
     box_info = hig_vbox_new ();
     gtk_container_set_border_width (GTK_CONTAINER (box_about), 0);
     gtk_box_pack_start (GTK_BOX (box_about), box_info, FALSE, FALSE, 0);

     /* label */
     text = g_strdup_printf (MARKUP_ABOUT, INFO_A, DESCRIPTION, COPYRIGHT);
     lbl_about = gtk_label_new (NULL);
     gtk_label_set_markup (GTK_LABEL (lbl_about), text);
     gtk_box_pack_start (GTK_BOX (box_info), lbl_about, FALSE, FALSE, 0);
     g_free (text);

     /* link  */
     btn_link = gtk_button_new ();
     gtk_button_set_relief (GTK_BUTTON (btn_link), GTK_RELIEF_NONE);
     g_signal_connect_swapped (G_OBJECT (btn_link), "clicked",
                               G_CALLBACK (util_open_link), LINK);
     gtk_box_pack_start (GTK_BOX (box_info), btn_link, FALSE, FALSE, 0);

     align = gtk_alignment_new (0.0, 0.0, 0.0, 0.0);
     gtk_container_add (GTK_CONTAINER (btn_link), align);

     text = g_strdup_printf (MARKUP_LINK, LINK);
     lbl_link = gtk_label_new (NULL);
     gtk_label_set_markup (GTK_LABEL (lbl_link), text);
     gtk_misc_set_alignment (GTK_MISC (lbl_link), 0.0, 0.5);
     gtk_container_add (GTK_CONTAINER (align), lbl_link);
     g_free (text);

     /* notebook for the texts */
     notebook_about = gtk_notebook_new ();
     /* TODO: there has to be a better solution than size_request */
     gtk_widget_set_size_request (notebook_about, 250, 200);
     gtk_box_pack_start (GTK_BOX (box_main), notebook_about, TRUE, TRUE, 0);
     
     /* credit window */
     scr_win_team = hig_scrolled_window_new ();
     lbl_team = gtk_label_new (_("Team"));
     gtk_notebook_append_page (GTK_NOTEBOOK (notebook_about), scr_win_team,
                               lbl_team);
    
     /* create the text view for it */
     text_view_team = gtk_text_view_new ();
     gtk_text_view_set_editable (GTK_TEXT_VIEW (text_view_team), FALSE);
     gtk_text_view_set_pixels_above_lines (GTK_TEXT_VIEW (text_view_team), 1);
     gtk_text_view_set_left_margin (GTK_TEXT_VIEW (text_view_team), 10);
     gtk_text_view_set_right_margin (GTK_TEXT_VIEW (text_view_team), 10);
     gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (text_view_team), FALSE);
     gtk_container_add (GTK_CONTAINER (scr_win_team), text_view_team);

     /* fill the buffer */
     buf_credits = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text_view_team));
     file = g_build_filename (DATAPATH, "AUTHORS", NULL);
     if (!g_file_get_contents (file, &buf, &n, &err))
     {
          error_warning (_("AUTHORS file could not be read!"),
                         err->message, ERR_NOT_AVAILABLE);
          g_error_free (err);
          err = NULL;
     }
     if (buf)
          gtk_text_buffer_set_text (buf_credits, buf, (gint) n);
     g_free (buf);
     g_free (file);

     /* license window */
     scr_win_license = hig_scrolled_window_new ();
     lbl_license = gtk_label_new (_("License"));
     gtk_notebook_append_page (GTK_NOTEBOOK (notebook_about), scr_win_license,
                               lbl_license);
    
     /* create the text view */
     text_view_license = gtk_text_view_new ();
     gtk_text_view_set_editable (GTK_TEXT_VIEW (text_view_license), FALSE);
     gtk_text_view_set_pixels_above_lines (GTK_TEXT_VIEW (text_view_license),
                                           1);
     gtk_text_view_set_left_margin (GTK_TEXT_VIEW (text_view_license), 10);
     gtk_text_view_set_right_margin (GTK_TEXT_VIEW (text_view_license), 10);
     gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (text_view_license),
                                       FALSE);
     gtk_container_add (GTK_CONTAINER (scr_win_license), text_view_license);

     /* fill the buffer */
     buf_license =
          gtk_text_view_get_buffer (GTK_TEXT_VIEW (text_view_license));
     file = g_build_filename (DATAPATH, "COPYING", NULL);
     if (!g_file_get_contents (file, &buf, &n, &err))
     {
          error_warning (_("COPYRIGHT file could not be read!"),
                         err->message, ERR_NOT_AVAILABLE);
          g_error_free (err);
          err = NULL;
     }
     if (buf)
          gtk_text_buffer_set_text (buf_license, buf, (gint) n);
     g_free (buf);
     g_free (file);

     gtk_widget_show_all (GTK_DIALOG (dlg_about)->vbox);
     gtk_dialog_run (GTK_DIALOG (dlg_about));
     gtk_widget_destroy (dlg_about);
     return;
}
