/* $Id: util.h,v 1.12 2005/03/24 10:27:25 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LING_GTKUTIL_H
#define LING_GTKUTIL_H 1

#include <gtk/gtk.h>
#include "../li18n.h"

void
util_open_link (const gchar *link);

void
util_play_sound (const gchar *file);

void
util_new_status (GtkStatusbar *status, const gchar *msg);

void
util_get_folderselection (GtkWidget *widget);

void
util_get_fileselection (GtkWidget *widget);

gchar*
util_run_fileselection (const gchar *title, GtkFileChooserAction action);

GtkWidget*
util_create_button_with_image (const gchar *label, const gchar *icon,
                               gboolean right);

#define UTIL_CREATE_BUTTON_NEXT() \
    util_create_button_with_image (_("_Next"), GTK_STOCK_GO_FORWARD, FALSE)
#define UTIL_CREATE_BUTTON_PREV() \
    util_create_button_with_image (_("_Previous"), GTK_STOCK_GO_BACK, TRUE)

void
util_copy_int (GtkWidget *widget, int *data);

void 
util_copy_string (GtkWidget *widget, gchar **data);

void
util_copy_boolean (GtkWidget *widget, gboolean *data);

gboolean
util_ask_for_confirmation (const gchar *title, const gchar *text);

void 
util_info (const gchar *text);

void
util_event_unregister (void *object);

gchar*
util_get_file_with_locale (gchar *path, gchar *file);

#endif /* LING_GTKUTIL_H */
