/* $Id: gfilter.c,v 1.10 2005/03/28 12:51:58 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2001-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "../li18n.h"
#include "../errors.h"
#include "../gtk/custom/hig-widgets.h"
#include "../gtk/gtkdefs.h"
#include "../gtk/menu.h"
#include "../gtk/util.h"
#include "../gtk/gtkimport.h"
#include "../gtk/gtkconfig.h"
#include "filter.h"

extern lingGtkMainWindow *main_app;
extern lingGtkPrefs *settings;

static guint id = 0;

const gchar* plugin_name (void);
const gchar* plugin_desc (void);
void plugin_init (void);
void plugin_free (void);

static GtkWidget* kvoctrain_options (void);
static lingLesson* kvoctrain_import_file (const char *file);

const gchar*
plugin_name (void)
{
     return "Import filter plugin";
}

const gchar*
plugin_desc (void)
{
     return "Import filter plugin for LingoTeach";
}

void
plugin_init (void)
{
     /* we only have to register the shipped import filters here, 
      * that should not be too complicated 
      */
     
     gtkimport_register_filter ("KVocTrain", "0.0.1", kvoctrain_options,
                                kvoctrain_import_file);
     return;
}

void
plugin_free (void)
{
     gtkimport_unregister_filter ("KVocTrain", "0.0.1");

     return;
}


/* 
 * KVocTrain import filters 
 */

struct
{
     gchar *lang_from;
     gchar *lang_to;
} KVocOptions;

static void set_lang (GtkWidget *combo, gpointer which)
{
     if (GPOINTER_TO_INT (which) == 0)
          KVocOptions.lang_from =
               gtk_combo_box_get_active_text (GTK_COMBO_BOX (combo));
     else
          KVocOptions.lang_to =
               gtk_combo_box_get_active_text (GTK_COMBO_BOX (combo));
     return;
}

static GtkWidget*
kvoctrain_options (void)
{
     GtkWidget *tbl_langs;
     GtkWidget *lbl_lang1;
     GtkWidget *cmb_lang1;
     GtkWidget *lbl_lang2;
     GtkWidget *cmb_lang2;

     gint i = 0;
     
     KVocOptions.lang_from = NULL;
     KVocOptions.lang_to = NULL;

     /* table */
     tbl_langs = hig_table_new (2, 2);

     /* languages */
     lbl_lang1 = gtk_label_new_with_mnemonic (_("Language _1"));
     gtk_table_attach (GTK_TABLE (tbl_langs), lbl_lang1, 0, 1, 0, 1,
                       GTK_FILL, GTK_FILL, 0, 0);

     cmb_lang1 = gtk_combo_box_new_text ();
     while (settings->prefs->languages[i])
          gtk_combo_box_append_text (GTK_COMBO_BOX (cmb_lang1),
                                     settings->prefs->languages[i++]);
     gtk_combo_box_set_active (GTK_COMBO_BOX (cmb_lang1), 0);
     g_signal_connect (G_OBJECT (cmb_lang1), "changed",
                       G_CALLBACK (set_lang), GINT_TO_POINTER (0));
     KVocOptions.lang_from =
          gtk_combo_box_get_active_text (GTK_COMBO_BOX (cmb_lang1));

     gtk_table_attach (GTK_TABLE (tbl_langs), cmb_lang1, 1, 2, 0, 1,
                       GTK_FILL, GTK_FILL, 0, 0);
     gtk_label_set_mnemonic_widget (GTK_LABEL (lbl_lang1), cmb_lang1);

     lbl_lang2 = gtk_label_new_with_mnemonic (_("Language _2"));
     gtk_table_attach (GTK_TABLE (tbl_langs), lbl_lang2, 0, 1, 1, 2,
                       GTK_FILL, GTK_FILL, 0, 0);

     cmb_lang2 = gtk_combo_box_new_text ();
     i = 0;
     while (settings->prefs->languages[i])
          gtk_combo_box_append_text (GTK_COMBO_BOX (cmb_lang2),
                                     settings->prefs->languages[i++]);
     gtk_combo_box_set_active (GTK_COMBO_BOX (cmb_lang2), 0);
     g_signal_connect (G_OBJECT (cmb_lang2), "changed",
                       G_CALLBACK (set_lang), GINT_TO_POINTER (1));
     KVocOptions.lang_to =
          gtk_combo_box_get_active_text (GTK_COMBO_BOX (cmb_lang2));

     gtk_table_attach (GTK_TABLE (tbl_langs), cmb_lang2, 1, 2, 1, 2,
                       GTK_FILL, GTK_FILL, 0, 0);
     gtk_label_set_mnemonic_widget (GTK_LABEL (lbl_lang2), cmb_lang2);

     return tbl_langs;
}

static lingLesson*
kvoctrain_import_file (const char *file)
{
     return kvoctrain_import (file, KVocOptions.lang_from,
                              KVocOptions.lang_to);
}
